/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.core;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import pcl.lc.util.Facing3;
import pcl.lc.util.Vector3;

public class TeleportationAgent {
    public Entity teleportEntityAndRider(Entity entity, Vector3 destination, Vector3 velocity, Facing3 rotation, int dimension) {
        Entity rider = entity.field_70153_n;
        if (rider != null) {
            rider.func_70078_a(null);
        }
        entity = this.teleportEntity(entity, destination, velocity, rotation, dimension);
        if (rider != null) {
            rider = this.teleportEntityAndRider(rider, destination, velocity, rotation, dimension);
            rider.func_70078_a(entity);
            entity.field_98038_p = false;
        }
        return entity;
    }

    private Entity teleportEntity(Entity entity, Vector3 destination, Vector3 velocity, Facing3 rotation, int dimension) {
        Entity newEntity;
        if (entity.field_71093_bK == dimension) {
            System.out.println("Performing local teleportation.");
            newEntity = this.teleportWithinDimension(entity, destination, velocity, rotation);
        } else {
            newEntity = this.teleportToOtherDimension(entity, destination, velocity, rotation, dimension);
            newEntity.field_71093_bK = dimension;
        }
        return newEntity;
    }

    private Entity teleportWithinDimension(Entity entity, Vector3 destination, Vector3 velocity, Facing3 rotation) {
        if (entity instanceof EntityPlayerMP) {
            return this.teleportPlayerWithinDimension((EntityPlayerMP)entity, destination, velocity, rotation);
        }
        return this.teleportEntityToWorld(entity, destination, velocity, rotation, (WorldServer)entity.field_70170_p);
    }

    private Entity teleportPlayerWithinDimension(EntityPlayerMP entity, Vector3 destination, Vector3 velocity, Facing3 rotation) {
        return entity;
    }

    private Entity teleportToOtherDimension(Entity entity, Vector3 destination, Vector3 velocity, Facing3 rotation, int dimension) {
        if (entity instanceof EntityPlayerMP) {
            return this.transferPlayerToDimension((EntityPlayerMP)entity, destination, velocity, rotation, dimension);
        }
        return this.teleportEntityToDimension(entity, destination, velocity, rotation, dimension);
    }

    private Entity transferPlayerToDimension(EntityPlayerMP player, Vector3 destination, Vector3 velocity, Facing3 rotation, int newDimension) {
        MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
        int j = player.field_71093_bK;
        WorldServer worldserver = minecraftserver.func_71218_a(j);
        WorldServer worldserver1 = minecraftserver.func_71218_a(newDimension);
        player.field_71093_bK = newDimension;
        player.field_70170_p.func_72900_e((Entity)player);
        player.field_70128_L = false;
        this.setPositionAndVelocity((Entity)player, destination, velocity, rotation);
        if (player.func_70089_S()) {
            worldserver.func_72866_a((Entity)player, false);
        }
        player.func_70029_a((World)worldserver1);
        Entity entity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)player), (World)worldserver1);
        if (entity != null) {
            entity.func_82141_a((Entity)player, true);
            worldserver1.func_72838_d(entity);
        }
        player.field_70128_L = true;
        return entity;
    }

    private Entity teleportEntityToDimension(Entity entity, Vector3 destination, Vector3 velocity, Facing3 rotation, int dimension) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        WorldServer world = server.func_71218_a(dimension);
        return this.teleportEntityToWorld(entity, destination, velocity, rotation, world);
    }

    private Entity teleportEntityToWorld(Entity oldEntity, Vector3 destination, Vector3 velocity, Facing3 rotation, WorldServer newWorld) {
        WorldServer oldWorld = (WorldServer)oldEntity.field_70170_p;
        NBTTagCompound nbt = new NBTTagCompound();
        oldEntity.func_70039_c(nbt);
        this.extractEntityFromWorld((World)oldWorld, oldEntity);
        Entity newEntity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)newWorld);
        if (newEntity != null) {
            if (oldEntity instanceof EntityLiving) {
                this.copyMoreEntityData((EntityLiving)oldEntity, (EntityLiving)newEntity);
            }
            this.setPositionAndVelocity(newEntity, destination, velocity, rotation);
            newEntity.field_98038_p = true;
            newWorld.func_72838_d(newEntity);
            newEntity.func_70029_a((World)newWorld);
        }
        oldWorld.func_82742_i();
        if (oldWorld != newWorld) {
            newWorld.func_82742_i();
        }
        return newEntity;
    }

    private void setPositionAndVelocity(Entity entity, Vector3 destination, Vector3 velocity, Facing3 rotation) {
        entity.field_70159_w = velocity.x;
        entity.field_70181_x = velocity.y;
        entity.field_70179_y = velocity.z;
        entity.field_70177_z = (float)rotation.yaw;
        entity.field_70125_A = (float)rotation.pitch;
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).func_70634_a(destination.x, destination.y, destination.z);
        } else {
            entity.func_70107_b(destination.x, destination.y, destination.z);
        }
        entity.field_70170_p.func_72866_a(entity, false);
    }

    private void copyMoreEntityData(EntityLiving oldEntity, EntityLiving newEntity) {
        float s = oldEntity.func_70689_ay();
        if (s != 0.0f) {
            newEntity.func_70659_e(s);
        }
    }

    private void extractEntityFromWorld(World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            world.field_73010_i.remove(entity);
            world.func_72854_c();
        }
        int i = entity.field_70176_ah;
        int j = entity.field_70164_aj;
        if (entity.field_70175_ag && world.func_72863_F().func_73149_a(i, j)) {
            world.func_72964_e(i, j).func_76622_b(entity);
        }
        world.field_72996_f.remove(entity);
        world.func_72847_b(entity);
    }
}

