/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.core;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;
import pcl.lc.api.internal.IModule;
import pcl.lc.cfg.ConfigHelper;
import pcl.lc.cfg.ModuleConfig;
import pcl.lc.cfg.ModuleList;
import pcl.lc.module.ModuleCore;
import pcl.lc.module.ModuleCritters;
import pcl.lc.module.ModuleDecor;
import pcl.lc.module.ModuleIntegration;
import pcl.lc.module.ModuleMachine;
import pcl.lc.module.ModulePower;
import pcl.lc.module.ModuleStargates;
import pcl.lc.module.ModuleWorldGenerator;

public class ModuleManager {
    private static ArrayList<Module> loadedModules = new ArrayList();
    private static ModuleList moduleConfig;

    public ModuleManager(ModuleList moduleConfig) {
        ModuleManager.moduleConfig = moduleConfig;
    }

    public void preInit(FMLPreInitializationEvent event) {
        EnumSet<Module> modules = EnumSet.allOf(Module.class);
        Iterator i = modules.iterator();
        while (i.hasNext()) {
            Module theModule = (Module)((Object)i.next());
            if (this.isModuleEnabled(theModule)) continue;
            LanteaCraft.getLogger().log(Level.INFO, "Removing module " + (Object)((Object)theModule) + " because it is disabled in config.");
            i.remove();
        }
        boolean flag = true;
        while (flag) {
            flag = false;
            Iterator j = modules.iterator();
            while (j.hasNext()) {
                Module theModule = (Module)((Object)j.next());
                Set<Module> dependencies = theModule.moduleOf().getDependencies();
                if (dependencies == null || modules.containsAll(dependencies)) continue;
                LanteaCraft.getLogger().log(Level.INFO, "Removing module " + (Object)((Object)theModule) + " because it is missing dependencies.");
                j.remove();
                flag = true;
            }
        }
        ArrayList<Module> loadStack = new ArrayList<Module>();
        loadStack.add(Module.CORE);
        int p = 0;
        while (modules.size() > 0 && 255 > p) {
            Iterator k = modules.iterator();
            ++p;
            while (k.hasNext()) {
                Module theModule = (Module)((Object)k.next());
                if (theModule == Module.CORE) {
                    k.remove();
                    continue;
                }
                Set<Module> loadAfter = theModule.moduleOf().getLoadDependenciesAfter();
                if (loadAfter == null) {
                    if (loadStack.contains((Object)theModule)) continue;
                    LanteaCraft.getLogger().log(Level.INFO, "Adding module " + (Object)((Object)theModule) + " as it has no load order.");
                    loadStack.add(theModule);
                    k.remove();
                    continue;
                }
                if (loadStack.containsAll(loadAfter)) {
                    int l = 0;
                    for (Module mod : loadAfter) {
                        if (loadStack.indexOf((Object)mod) <= l) continue;
                        l = loadStack.indexOf((Object)mod);
                    }
                    LanteaCraft.getLogger().log(Level.INFO, "Adding module " + (Object)((Object)theModule) + " as it has all parents resolved.");
                    loadStack.add(l + 1, theModule);
                    k.remove();
                    continue;
                }
                LanteaCraft.getLogger().log(Level.INFO, "Cannot add module " + (Object)((Object)theModule) + "; waiting for other loading data.");
            }
        }
        if (p >= 254) {
            LanteaCraft.getLogger().log(Level.WARN, "There were issues resolving dependencies; full resolution was aborted.");
        }
        loadedModules.addAll(loadStack);
        StringBuilder stack = new StringBuilder().append("Load order: ");
        for (int m = 0; m < loadedModules.size(); ++m) {
            stack.append("[").append(m).append("=>").append((Object)loadedModules.get(m)).append("] ");
        }
        LanteaCraft.getLogger().log(Level.INFO, stack.toString());
        for (Module mod : loadedModules) {
            mod.loaded = true;
            mod.moduleOf().preInit(event);
        }
    }

    public void init(FMLInitializationEvent event) {
        for (Module mod : loadedModules) {
            mod.moduleOf().init(event);
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        for (Module mod : loadedModules) {
            mod.moduleOf().postInit(event);
        }
    }

    private boolean isModuleEnabled(Module theModule) {
        ModuleConfig config = ConfigHelper.findModuleConfigByName(moduleConfig, theModule.name());
        return (Boolean)config.parameters().get("enabled");
    }

    public static ModuleConfig getConfig(IModule module) {
        for (Module list : Module.values()) {
            if (!list.loaded || !list.moduleOf.equals(module)) continue;
            return ConfigHelper.findModuleConfigByName(moduleConfig, list.name());
        }
        return null;
    }

    public static enum Module {
        CORE(new ModuleCore()),
        STARGATE(new ModuleStargates()),
        POWER(new ModulePower()),
        MACHINE(new ModuleMachine()),
        WORLDGEN(new ModuleWorldGenerator()),
        CRITTERS(new ModuleCritters()),
        DECOR(new ModuleDecor()),
        INTEGRATION(new ModuleIntegration());

        private final IModule moduleOf;
        private boolean loaded = false;

        private Module(IModule moduleOf) {
            this.moduleOf = moduleOf;
        }

        public IModule moduleOf() {
            return this.moduleOf;
        }

        public boolean isLoaded() {
            return this.loaded;
        }
    }
}

