/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.client.audio;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.client.audio.AudioEngine;
import pcl.lc.client.audio.AudioPosition;
import pcl.lc.client.audio.AudioSource;

public class SoundHost {
    protected final Object owner;
    private HashMap<String, AudioSourceWrapper> sources;
    private ArrayList<String> dead_sources;

    public SoundHost(Object owner) {
        this.owner = owner;
        this.sources = new HashMap();
        this.dead_sources = new ArrayList();
    }

    public void tick() {
        for (Map.Entry<String, AudioSourceWrapper> wrapper : this.sources.entrySet()) {
            wrapper.getValue().tick();
            if (wrapper.getValue().canPlay()) continue;
            this.dead_sources.add(wrapper.getKey());
        }
        for (String dead : this.dead_sources) {
            this.sources.remove(dead);
        }
        this.dead_sources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannel(String name, String filename, AudioPosition position, float volume, int age) {
        if (BuildInfo.SS_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("SoundHost operation: ADD %s %s %s", filename, Float.valueOf(volume), age));
        }
        HashMap<String, AudioSourceWrapper> hashMap = this.sources;
        synchronized (hashMap) {
            this.sources.put(name, new AudioSourceWrapper(filename, position, volume, age));
        }
    }

    public boolean channelExists(String channel) {
        return this.sources.containsKey(channel) && this.sources.get(channel) != null;
    }

    public void playChannel(String channel) {
        AudioSourceWrapper wrapper;
        if (BuildInfo.SS_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("SoundHost operation: PLAY %s", channel));
        }
        if ((wrapper = this.sources.get(channel)) != null) {
            if (wrapper.playing()) {
                wrapper.stop();
            }
            wrapper.play();
        }
    }

    public void pauseChannel(String channel) {
        AudioSourceWrapper wrapper;
        if (BuildInfo.SS_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("SoundHost operation: PAUSE %s", channel));
        }
        if ((wrapper = this.sources.get(channel)) != null) {
            wrapper.pause();
        }
    }

    public void stopChannel(String channel) {
        AudioSourceWrapper wrapper;
        if (BuildInfo.SS_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("SoundHost operation: STOP %s", channel));
        }
        if ((wrapper = this.sources.get(channel)) != null) {
            wrapper.stop();
        }
        this.sources.remove(channel);
    }

    public void shutdown(boolean force) {
        if (!force) {
            for (AudioSourceWrapper wrapper : this.sources.values()) {
                if (!wrapper.playing()) continue;
                return;
            }
        }
        if (BuildInfo.SS_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("SoundHost operation: SHUTDOWN", new Object[0]));
        }
        for (AudioSourceWrapper wrapper : this.sources.values()) {
            wrapper.stop();
            wrapper.shutdown();
        }
        this.sources.clear();
    }

    private class AudioSourceWrapper {
        private String filename;
        private AudioPosition position;
        private float volume;
        private AudioSource vsource;
        private int maxAge;
        private int age;
        private boolean stopped;

        public AudioSourceWrapper(String filename, AudioPosition position, float volume, int maxAge) {
            this.filename = filename;
            this.position = position;
            this.volume = volume;
            this.maxAge = maxAge;
        }

        public void tick() {
            if (!this.playing() || this.stopped) {
                return;
            }
            if (this.maxAge > 0) {
                ++this.age;
            }
            if (this.age > this.maxAge) {
                this.stop();
            }
        }

        public boolean alive() {
            return (0 > this.maxAge || this.maxAge > this.age) && this.playing();
        }

        public boolean canPlay() {
            return !this.stopped;
        }

        public void setupSource() {
            AudioEngine engine = LanteaCraft.getProxy().getAudioEngine();
            this.vsource = engine.create(SoundHost.this.owner, this.position, this.filename, 0 > this.age, false, this.volume);
        }

        public void play() {
            if (this.vsource == null) {
                this.setupSource();
            }
            if (this.vsource.isPlaying()) {
                this.vsource.stop();
            }
            this.vsource.play();
        }

        public boolean playing() {
            return this.vsource != null && this.vsource.isPlaying();
        }

        public void pause() {
            if (this.vsource != null) {
                this.vsource.pause();
            }
        }

        public void stop() {
            if (this.vsource != null) {
                this.vsource.stop();
            }
            this.vsource = null;
            this.stopped = true;
        }

        public void shutdown() {
            if (this.vsource != null) {
                this.vsource.stop();
                this.vsource.remove();
            }
        }
    }
}

