/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.client.audio;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import pcl.lc.LanteaCraft;
import pcl.lc.api.internal.ITickAgent;
import pcl.lc.client.audio.AudioEngine;
import pcl.lc.client.audio.AudioPosition;
import pcl.lc.client.audio.AudioSource;
import pcl.lc.client.audio.ClientAudioSource;

public class ClientAudioEngine
extends AudioEngine
implements ITickAgent {
    private static int sourceCounter = 0;
    public final float falloffDistance = 22.0f;
    private final int maxStreamingSources = 8;
    public boolean enabled = true;
    public int maxSources = 32;
    public float masterVolume = 0.5f;
    private SoundManager manager = null;
    private SoundSystem system = null;
    private volatile Thread initThread;
    private Field soundman_state;
    private HashMap<SoundHostObject, ArrayList<AudioSource>> hostSourceList = new HashMap();

    private static String label() {
        StringBuilder label = new StringBuilder();
        label.append("lc_directsound_").append(sourceCounter);
        if (++sourceCounter > 512) {
            sourceCounter %= 512;
        }
        return label.toString();
    }

    @Override
    public void initialize() {
        int k = 0;
        for (Field field : SoundManager.class.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(Boolean.TYPE)) continue;
            this.soundman_state = field;
            ++k;
        }
        if (k != 1) {
            this.enabled = false;
            return;
        }
        SoundSystemConfig.setNumberStreamingChannels((int)8);
        SoundSystemConfig.setNumberNormalChannels((int)(this.maxSources - 8));
        this.soundman_state.setAccessible(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static SoundSystem getSoundSystem(SoundManager soundManager) {
        for (Field field : SoundManager.class.getDeclaredFields()) {
            if (!SoundSystem.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                return (SoundSystem)field.get(soundManager);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static SoundManager getSoundManager() {
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        for (Field field : SoundHandler.class.getDeclaredFields()) {
            if (!SoundManager.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                return (SoundManager)field.get(handler);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onSoundSetup(SoundLoadEvent event) {
        if (!this.enabled) {
            return;
        }
        this.hostSourceList.clear();
        this.system = null;
        if (this.initThread != null) {
            this.initThread.interrupt();
            try {
                this.initThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LanteaCraft.getLogger().log(Level.INFO, "LanteaCraft audio task starting.");
        this.manager = ClientAudioEngine.getSoundManager();
        this.initThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        boolean loaded;
                        try {
                            loaded = ClientAudioEngine.this.soundman_state.getBoolean(ClientAudioEngine.this.manager);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        if (loaded) {
                            ClientAudioEngine.this.system = ClientAudioEngine.getSoundSystem(ClientAudioEngine.this.manager);
                            if (ClientAudioEngine.this.system == null) {
                                LanteaCraft.getLogger().log(Level.WARN, "Can't get audio system. LanteaCraft sound offline.");
                                ClientAudioEngine.this.enabled = false;
                            } else {
                                LanteaCraft.getLogger().log(Level.INFO, "LanteaCraft sound online.");
                            }
                            break;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ClientAudioEngine.this.initThread = null;
            }
        }, "LanteaCraft audio hook task");
        this.initThread.start();
    }

    @Override
    public AudioSource create(Object owner, AudioPosition position, String file, boolean looping, boolean override, float volume) {
        String tag = ClientAudioEngine.label();
        ClientAudioSource source = new ClientAudioSource(this.system, position, file, looping, override, volume, tag);
        SoundHostObject host = new SoundHostObject(owner);
        if (!this.hostSourceList.containsKey(host)) {
            this.hostSourceList.put(host, new ArrayList());
        }
        this.hostSourceList.get(host).add(source);
        return source;
    }

    @Override
    public void advance() {
        if (!this.enabled) {
            return;
        }
        if (this.system == null) {
            return;
        }
        float vol = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.MASTER);
        if (this.masterVolume != vol) {
            this.masterVolume = vol;
        }
        Vector<SoundHostObject> stopSounds = new Vector<SoundHostObject>();
        EntityClientPlayerMP client = Minecraft.func_71410_x().field_71439_g;
        if (client == null) {
            stopSounds.addAll(this.hostSourceList.keySet());
        } else {
            PriorityQueue<AudioSource> soundQueue = new PriorityQueue<AudioSource>();
            for (Map.Entry<SoundHostObject, ArrayList<AudioSource>> entry : this.hostSourceList.entrySet()) {
                if (entry.getKey().isEnqueued()) {
                    stopSounds.add(entry.getKey());
                    continue;
                }
                for (AudioSource audioSource : entry.getValue()) {
                    audioSource.advance((EntityPlayer)client);
                    if (!(audioSource.getRealVolume() > 0.0f)) continue;
                    soundQueue.add(audioSource);
                }
            }
            int k = 0;
            while (!soundQueue.isEmpty()) {
                AudioSource source = (AudioSource)soundQueue.poll();
                if (this.maxSources > k) {
                    source.activate();
                } else {
                    source.cull();
                }
                ++k;
            }
        }
        for (SoundHostObject host : stopSounds) {
            this.removeSources(host);
        }
    }

    private void removeSources(Object o) {
        if (this.system == null) {
            return;
        }
        SoundHostObject host = !(o instanceof SoundHostObject) ? new SoundHostObject(o) : (SoundHostObject)o;
        if (!this.hostSourceList.containsKey(host)) {
            return;
        }
        ArrayList<AudioSource> sources = this.hostSourceList.get(host);
        for (AudioSource source : sources) {
            source.remove();
        }
        this.hostSourceList.remove(host);
    }

    private static class SoundHostObject
    extends WeakReference<Object> {
        public SoundHostObject(Object host) {
            super(host);
        }

        public int hashCode() {
            if (this.get() != null) {
                return this.get().hashCode();
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SoundHostObject)) {
                return this.get().equals(o);
            }
            return this.get().equals(((SoundHostObject)o).get());
        }
    }
}

