/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pcl.lc.cfg.ConfigList;
import pcl.lc.cfg.ConfigNode;
import pcl.lc.cfg.DOMHelper;
import pcl.lc.cfg.ModuleConfig;
import pcl.lc.cfg.ModuleList;
import pcl.lc.cfg.XMLParserException;

public class XMLParser {
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public XMLParser() {
        this.factory.setIgnoringComments(false);
    }

    public ModuleList read(InputStream chunk) throws XMLParserException {
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Document doc = builder.parse(chunk);
            NodeList root = doc.getChildNodes();
            Node modRoot = DOMHelper.findNode(root, "ModConfig", false);
            if (modRoot == null) {
                throw new XMLParserException("Missing ModConfig root tag.");
            }
            return this.readRoot(modRoot);
        }
        catch (IOException e) {
            throw new XMLParserException("Can't parse; IOException occured.", e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLParserException("Can't parse; configuration exception.", e);
        }
        catch (SAXException e) {
            throw new XMLParserException("Can't parse; document syntax exception.", e);
        }
    }

    private ModuleList readRoot(Node modRoot) throws XMLParserException {
        ModuleList root = new ModuleList("ModConfig");
        ArrayList<ModuleConfig> rootChildren = new ArrayList<ModuleConfig>();
        NodeList childrenRoot = modRoot.getChildNodes();
        for (int i = 0; i < childrenRoot.getLength(); ++i) {
            Node child = childrenRoot.item(i);
            if (!DOMHelper.isNodeOfType(child, "Module", false)) continue;
            rootChildren.add(this.readModuleConfig(root, (Element)child));
        }
        root.setChildren(rootChildren);
        return root;
    }

    private ModuleConfig readModuleConfig(ConfigNode parent, Element moduleNode) throws XMLParserException {
        DOMHelper.checkedAllAttributes(moduleNode, new String[]{"name", "enabled"});
        ModuleConfig moduleRoot = new ModuleConfig("Module", parent);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ArrayList<ConfigNode> rootChildren = new ArrayList<ConfigNode>();
        parameters.put("name", moduleNode.getAttribute("name"));
        parameters.put("enabled", DOMHelper.popBoolean(moduleNode.getAttribute("enabled"), false));
        NodeList childrenRoot = moduleNode.getChildNodes();
        for (int i = 0; i < childrenRoot.getLength(); ++i) {
            Node child = childrenRoot.item(i);
            if (!(child instanceof Element)) continue;
            rootChildren.add(this.readRecusriveObject(moduleRoot, (Element)child));
        }
        moduleRoot.setParameters(parameters);
        moduleRoot.setChildren(rootChildren);
        Comment nodeComment = DOMHelper.findLeadingComment(moduleNode);
        if (nodeComment != null) {
            moduleRoot.setComment(nodeComment.getData());
        }
        return moduleRoot;
    }

    private ConfigNode readRecusriveObject(ConfigNode parent, Element element) throws XMLParserException {
        Comment nodeComment;
        if (element.hasChildNodes()) {
            ConfigList group = new ConfigList(element.getTagName(), parent);
            ArrayList<ConfigNode> childrenGroup = new ArrayList<ConfigNode>();
            if (element.hasAttributes()) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                NamedNodeMap nodes = element.getAttributes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    parameters.put(nodes.item(i).getNodeName(), nodes.item(i).getNodeValue());
                }
                group.setParameters(parameters);
            }
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                childrenGroup.add(this.readRecusriveObject(group, (Element)child));
            }
            group.setChildren(childrenGroup);
            Comment nodeComment2 = DOMHelper.findLeadingComment(element);
            if (nodeComment2 != null) {
                group.setComment(nodeComment2.getData());
            }
            return group;
        }
        ConfigNode single = new ConfigNode(element.getTagName(), parent);
        if (element.hasAttributes()) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            NamedNodeMap nodes = element.getAttributes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                parameters.put(nodes.item(i).getNodeName(), nodes.item(i).getNodeValue());
            }
            single.setParameters(parameters);
        }
        if ((nodeComment = DOMHelper.findLeadingComment(element)) != null) {
            single.setComment(nodeComment.getData());
        }
        return single;
    }
}

