/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.cfg;

import java.util.ArrayList;
import pcl.lc.cfg.ConfigList;
import pcl.lc.cfg.ConfigNode;
import pcl.lc.cfg.DOMHelper;
import pcl.lc.cfg.ModuleConfig;
import pcl.lc.cfg.ModuleList;

public class ConfigHelper {
    public static ModuleConfig findModuleConfigByName(ModuleList list, String name) {
        for (ModuleConfig element : list.children()) {
            if (!element.name().equalsIgnoreCase("Module") || !element.parameters().containsKey("name") || !element.parameters().get("name").toString().equalsIgnoreCase(name)) continue;
            return element;
        }
        ModuleConfig config = new ModuleConfig("Module", list);
        config.parameters().put("name", name);
        config.parameters().put("enabled", true);
        list.children().add(config);
        config.modify();
        return config;
    }

    public static ConfigNode findConfigByClass(ConfigList list, String clazz) {
        ConfigNode targetNode = null;
        for (ConfigNode child : list.children()) {
            if (!child.name().equals(clazz)) continue;
            targetNode = child;
        }
        return targetNode;
    }

    public static ArrayList<ConfigNode> findAllConfigByClass(ConfigList list, String clazz) {
        ArrayList<ConfigNode> result = new ArrayList<ConfigNode>();
        for (ConfigNode child : list.children()) {
            if (!child.name().equals(clazz)) continue;
            result.add(child);
        }
        return result;
    }

    public static Object getOrSetParam(ConfigList list, String clazz, String name, String paramName, String comment, Object value) {
        ConfigNode targetNode = null;
        for (ConfigNode child : list.children()) {
            if (!child.name().equals(clazz) || !child.parameters().containsKey("name") || !(child.parameters().get("name") instanceof String) || !((String)child.parameters().get("name")).equalsIgnoreCase(name)) continue;
            targetNode = child;
        }
        if (targetNode == null) {
            targetNode = new ConfigNode(clazz, comment, list);
            targetNode.parameters().put("name", name);
            list.children().add(targetNode);
            targetNode.modify();
        }
        if (!targetNode.parameters().containsKey(paramName)) {
            targetNode.parameters().put(paramName, value);
            targetNode.modify();
        }
        return targetNode.parameters().get(paramName);
    }

    public static boolean getOrSetBooleanParam(ConfigList list, String clazz, String name, String paramName, String comment, Boolean state) {
        ConfigNode targetNode = null;
        for (ConfigNode child : list.children()) {
            if (!child.name().equals(clazz) || !child.parameters().containsKey("name") || !(child.parameters().get("name") instanceof String) || !((String)child.parameters().get("name")).equalsIgnoreCase(name)) continue;
            targetNode = child;
        }
        if (targetNode == null) {
            targetNode = new ConfigNode(clazz, comment, list);
            targetNode.parameters().put("name", name);
            list.children().add(targetNode);
            targetNode.modify();
        }
        if (!targetNode.parameters().containsKey(paramName)) {
            targetNode.parameters().put(paramName, state);
            targetNode.modify();
        }
        return DOMHelper.popBoolean(targetNode.parameters().get(paramName).toString(), false);
    }
}

