/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;
import pcl.lc.base.worldgen.ChunkData;
import pcl.lc.cfg.ConfigHelper;
import pcl.lc.cfg.ConfigList;
import pcl.lc.cfg.ConfigNode;
import pcl.lc.cfg.ModuleConfig;
import pcl.lc.core.OreTypes;
import pcl.lc.module.ModuleCore;

public class NaquadahOreWorldGen
implements IWorldGenerator {
    private static int genUnderLavaOdds = 4;
    private static int maxNodesUnderLava = 8;
    private static int genIsolatedOdds = 8;
    private static int maxIsolatedNodes = 4;
    private static EnumSet<OreTypes> enabledOreSpawns = EnumSet.of(OreTypes.NAQUADAH, OreTypes.TRINIUM);

    public static void configure(ModuleConfig cfg) {
        ConfigList enabledOres = (ConfigList)ConfigHelper.findConfigByClass(cfg, "EnabledOres");
        if (enabledOres != null) {
            enabledOreSpawns.clear();
            for (ConfigNode node : enabledOres.children()) {
                OreTypes typeof;
                if (!node.name().equalsIgnoreCase("Ore") || !node.parameters().containsKey("name") || !(node.parameters().get("name") instanceof String) || (typeof = OreTypes.fromString(node.parameters().get("name").toString())) == null) continue;
                enabledOreSpawns.add(typeof);
            }
        } else {
            enabledOres = new ConfigList("EnabledOres", "Enabled ore-generation list", cfg);
            for (OreTypes typeof : enabledOreSpawns) {
                ConfigNode spawnrule = new ConfigNode("Ore", enabledOres);
                spawnrule.parameters().put("name", typeof.name());
                enabledOres.children().add(spawnrule);
                spawnrule.modify();
            }
            cfg.children().add(enabledOres);
            enabledOres.modify();
        }
        genUnderLavaOdds = Integer.parseInt(ConfigHelper.getOrSetParam(cfg, "OreGenerator", "genUnderLava", "odds", "Odds and density of generation under lava", genUnderLavaOdds).toString());
        maxNodesUnderLava = Integer.parseInt(ConfigHelper.getOrSetParam(cfg, "OreGenerator", "genUnderLava", "size", "Odds and density of generation under lava", maxNodesUnderLava).toString());
        genIsolatedOdds = Integer.parseInt(ConfigHelper.getOrSetParam(cfg, "OreGenerator", "genIsolated", "odds", "Odds and density of generation of above lava nodes", genUnderLavaOdds).toString());
        maxIsolatedNodes = Integer.parseInt(ConfigHelper.getOrSetParam(cfg, "OreGenerator", "genIsolated", "size", "Odds and density of generation of above lava nodes", genUnderLavaOdds).toString());
    }

    public void readChunk(ChunkData data, Chunk chunk) {
        for (OreTypes typeof : enabledOreSpawns) {
            if (data.getOreGenerated(typeof)) continue;
            this.generateChunk(typeof, chunk.field_76637_e, chunk);
        }
    }

    private Random requestRandomFor(int x, int z, World world, int oreTypeof) {
        return new Random((long)((1 + oreTypeof) * (x + z)) ^ world.func_72905_C());
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        Chunk target = world.func_72964_e(chunkX, chunkZ);
        ChunkData data = ChunkData.forChunk(target);
        for (OreTypes typeof : enabledOreSpawns) {
            if (data.getOreGenerated(typeof)) continue;
            this.generateChunk(typeof, world, target);
        }
    }

    public void regenerate(Chunk chunk) {
        ChunkData data = ChunkData.forChunk(chunk);
        for (OreTypes typeof : enabledOreSpawns) {
            if (data.getOreGenerated(typeof)) continue;
            this.generateChunk(typeof, chunk.field_76637_e, chunk);
        }
    }

    private Block getBlock(Chunk chunk, int x, int y, int z) {
        return chunk.func_150810_a(x, y, z);
    }

    private void setBlock(Chunk chunk, int x, int y, int z, Block block, int metadata) {
        chunk.func_150807_a(x, y, z, block, metadata);
    }

    void generateNode(Chunk chunk, World world, Random random, Block block, int metadata, int cx, int cy, int cz, int density) {
        LanteaCraft.getLogger().log(Level.TRACE, String.format("Node generator building node around %s %s %s with density %s typeof %s", cx + 16 * chunk.func_76632_l().field_77276_a, cy, cz + 16 * chunk.func_76632_l().field_77275_b, density, metadata));
        Block blockStone = (Block)Block.field_149771_c.func_82594_a("stone");
        int tries = 0;
        block8: while (density > 0) {
            int tx = cx;
            int ty = cy;
            int tz = cz;
            do {
                int trans = random.nextInt(6);
                switch (trans) {
                    case 0: {
                        ++tx;
                        break;
                    }
                    case 1: {
                        --tx;
                        break;
                    }
                    case 2: {
                        ++ty;
                        break;
                    }
                    case 3: {
                        --ty;
                        break;
                    }
                    case 4: {
                        ++tz;
                        break;
                    }
                    case 5: {
                        --tz;
                    }
                }
                if (tx > 15 || tz > 15 || 0 > tx || 0 > ty || 0 > tz) continue block8;
            } while (this.getBlock(chunk, tx, ty, tz).equals((Object)ModuleCore.Blocks.lanteaOre));
            if (!this.getBlock(chunk, tx, ty, tz).equals(blockStone)) break;
            if (this.getBlock(chunk, tx, ty, tz).equals(blockStone)) {
                this.setBlock(chunk, tx, ty, tz, block, metadata);
                --density;
                tries = 0;
                continue;
            }
            if (tries++ <= 5) continue;
            break;
        }
    }

    private boolean odds(Random random, int n) {
        return random.nextInt(n) == 0;
    }

    void generateChunk(OreTypes typeof, World world, Chunk chunk) {
        Random random = this.requestRandomFor(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, world, typeof.ordinal());
        Block blockStone = (Block)Block.field_149771_c.func_82594_a("stone");
        if (!this.odds(random, genIsolatedOdds)) {
            // empty if block
        }
        int n = random.nextInt(maxIsolatedNodes) + 1;
        for (int i = 0; i < n; ++i) {
            int z;
            int y;
            int x = random.nextInt(16);
            if (!this.getBlock(chunk, x, y = random.nextInt(64), z = random.nextInt(16)).equals(blockStone)) continue;
            LanteaCraft.getLogger().log(Level.TRACE, String.format("Attempting to place Naquadah node at %s %s %s", x, y, z));
            this.generateNode(chunk, world, random, (Block)ModuleCore.Blocks.lanteaOre, typeof.ordinal(), x, y, z, 6);
        }
        ChunkData.forChunk(chunk).markOreGenerated(OreTypes.NAQUADAH);
    }
}

