/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.worldgen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.WeakHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;
import pcl.lc.base.worldgen.NaquadahOreWorldGen;
import pcl.lc.core.OreTypes;

public class ChunkData {
    private static WeakHashMap<Chunk, ChunkData> chunkCache = new WeakHashMap();
    private ArrayList<OreTypes> generatedOres = new ArrayList();

    public static ChunkData forChunk(Chunk chunk) {
        ChunkData data = chunkCache.get(chunk);
        if (data == null) {
            data = new ChunkData();
            chunkCache.put(chunk, data);
        }
        return data;
    }

    public static void onChunkLoad(ChunkDataEvent.Load e) {
        Chunk chunk = e.getChunk();
        ChunkData data = ChunkData.forChunk(chunk);
        data.readFromNBT(e.getData());
        NaquadahOreWorldGen gen = LanteaCraft.getProxy().getOreGenerator();
        if (gen != null) {
            gen.readChunk(data, chunk);
        }
    }

    public static void onChunkSave(ChunkDataEvent.Save e) {
        Chunk chunk = e.getChunk();
        ChunkData data = ChunkData.forChunk(chunk);
        data.writeToNBT(e.getData());
    }

    public static void flush() {
        chunkCache.clear();
    }

    private ChunkData() {
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound lcCompound;
        NBTTagIntArray lcOres;
        if (nbt.func_74764_b("LanteaCraftMeta") && (lcOres = (NBTTagIntArray)(lcCompound = nbt.func_74775_l("LanteaCraftMeta")).func_74781_a("OreGenList")) != null) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Reading %s ore generation patterns", lcOres.func_150302_c().length));
            this.generatedOres.clear();
            for (int element : lcOres.func_150302_c()) {
                this.generatedOres.add(OreTypes.fromOrdinal(element));
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound lcCompound = new NBTTagCompound();
        Iterator<OreTypes> k = this.generatedOres.iterator();
        LanteaCraft.getLogger().log(Level.INFO, String.format("Saving %s ore generation patterns", this.generatedOres.size()));
        int[] result = new int[this.generatedOres.size()];
        int j = 0;
        while (k.hasNext()) {
            result[j] = k.next().ordinal();
            ++j;
        }
        NBTTagIntArray lcOres = new NBTTagIntArray(result);
        lcCompound.func_74782_a("OreGenList", (NBTBase)lcOres);
        nbt.func_74782_a("LanteaCraftMeta", (NBTBase)lcCompound);
    }

    public void markOreGenerated(OreTypes typeof) {
        if (!this.generatedOres.contains((Object)typeof)) {
            this.generatedOres.add(typeof);
        }
    }

    public boolean getOreGenerated(OreTypes typeof) {
        return this.generatedOres.contains((Object)typeof);
    }
}

