/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.render;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pcl.lc.LanteaCraft;

public class WrittenFontRenderer {
    private final ResourceLocation fontImageName;
    private final ResourceLocation fontMetricName;
    private final HashMap<Integer, GlyphMetric> char_metrics = new HashMap();

    public WrittenFontRenderer(ResourceLocation fontImageName, ResourceLocation fontMetricName) {
        this.fontImageName = fontImageName;
        this.fontMetricName = fontMetricName;
    }

    public void buildFont() {
        try {
            IResource metricResource = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.fontMetricName);
            InputStream stream = metricResource.func_110527_b();
            if (stream == null) {
                throw new IOException("Could not open font metric file.");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            Element metrics = doc.getDocumentElement();
            NodeList list_character = metrics.getElementsByTagName("character");
            for (int i = 0; i < list_character.getLength(); ++i) {
                Element character = (Element)list_character.item(i);
                int charcode = Integer.parseInt(character.getAttributes().getNamedItem("key").getNodeValue());
                if (0 > charcode || charcode > 255) {
                    throw new IOException(String.format("Unsupported character code %s", charcode));
                }
                int w = -1;
                int h = -1;
                int u = -1;
                int v = -1;
                NodeList character_properties = character.getChildNodes();
                for (int k = 0; k < character_properties.getLength(); ++k) {
                    Node property = character_properties.item(k);
                    if (!(property instanceof Element)) continue;
                    Element elem = (Element)property;
                    String name = elem.getNodeName().toLowerCase();
                    int val = Integer.parseInt(elem.getFirstChild().getNodeValue());
                    if (name.equals("width")) {
                        w = val;
                        continue;
                    }
                    if (name.equals("height")) {
                        h = val;
                        continue;
                    }
                    if (name.equals("x")) {
                        u = val;
                        continue;
                    }
                    if (name.equals("y")) {
                        v = val;
                        continue;
                    }
                    throw new IOException(String.format("Unexpected metric command %s", name));
                }
                if (w == -1 || h == -1 || u == -1 || v == -1) {
                    throw new IOException(String.format("Invalid metric properties set for key %s", charcode));
                }
                this.char_metrics.put(charcode, new GlyphMetric(w, h, u, v));
            }
        }
        catch (IOException e) {
            LanteaCraft.getLogger().log(Level.WARN, "Cannot setup font.", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LanteaCraft.getLogger().log(Level.WARN, "Cannot read font metric data.", (Throwable)e);
        }
        catch (SAXException e) {
            LanteaCraft.getLogger().log(Level.WARN, "Cannot read font metric data.", (Throwable)e);
        }
        LanteaCraft.getLogger().log(Level.INFO, String.format("Read %s metric definitions from file %s", this.char_metrics.size(), this.fontMetricName.toString()));
    }

    private String boxLine(String text, PageBox page, boolean isBeginParagraph) {
        int realPageWidth = page.page_width - page.margin_left - page.margin_right;
        int freeHeight = page.getFreeHeight();
        int width_new_line = 0;
        int width_new_word = 0;
        Stack<String> words = new Stack<String>();
        Stack<Character> chars = new Stack<Character>();
        int j = text.length();
        for (int i = 0; i < j; ++i) {
            char c = text.charAt(i);
            if (c == ' ') {
                if (chars.size() <= 0) continue;
                int new_width_nl = width_new_line + width_new_word + page.min_space_size;
                if (realPageWidth >= new_width_nl) {
                    width_new_line += width_new_word;
                    words.push(String.valueOf((Object)chars.toArray(new Character[0])));
                    width_new_word = 0;
                    continue;
                }
                width_new_word = 0;
                words.clear();
                continue;
            }
            GlyphMetric metric = this.char_metrics.get(c);
            if (metric == null) continue;
            width_new_word += metric.width;
            chars.push(Character.valueOf(c));
        }
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < words.size(); ++i) {
            line.append((String)words.get(i));
            if (i == words.size() - 1) continue;
            line.append(" ");
        }
        int height_new_line = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == ' ') continue;
            GlyphMetric metric = this.char_metrics.get(c);
            if (metric.height <= height_new_line) continue;
            height_new_line = metric.height;
        }
        if (height_new_line > freeHeight) {
            return text;
        }
        int space_remain = realPageWidth - width_new_line;
        int extra_px_per_space = (int)Math.floor(space_remain / words.size());
        BoxedLine linebox = new BoxedLine(line.toString(), page.min_space_size + extra_px_per_space, height_new_line);
        return null;
    }

    private String boxParagraph(String text, PageBox page) {
        return null;
    }

    public static class PageBox {
        public final int page_width;
        public final int page_height;
        public final int margin_left;
        public final int margin_right;
        public final int min_space_size;
        public LinkedList<BoxedLine> lines = new LinkedList();

        public PageBox(int w, int h, int ml, int mr, int min_sp) {
            this.page_width = w;
            this.page_height = h;
            this.margin_left = ml;
            this.margin_right = mr;
            this.min_space_size = min_sp;
        }

        public int getFreeHeight() {
            int h = this.page_height;
            for (BoxedLine line : this.lines) {
                h -= line.line_height;
            }
            return h;
        }
    }

    public static class BoxedLine {
        public final String line;
        public final int space_size;
        public final int line_height;

        public BoxedLine(String line, int space_size, int line_height) {
            this.line = line;
            this.space_size = space_size;
            this.line_height = line_height;
        }
    }

    private class GlyphMetric {
        public int width;
        public int height;
        public int ux;
        public int vy;

        public GlyphMetric(int w, int h, int u, int v) {
            this.width = w;
            this.height = h;
            this.ux = u;
            this.vy = v;
        }
    }
}

