/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import pcl.lc.core.ResourceAccess;

public class IconButtonRenderer {
    public static void drawButton(Minecraft mc, String iconName, boolean hover, boolean pressed, int x, int y, double scale, float zLevel) {
        IconButtonRenderer.bindAndClamp(mc, "button_" + (pressed ? "down" : (hover ? "hover" : "up")) + ".png");
        IconButtonRenderer.drawTexturedRectUV(x, y, 24.0 * scale, 24.0 * scale, 0.0, 0.0, 1.0, 1.0, zLevel);
        IconButtonRenderer.bindAndClamp(mc, "icons/" + iconName + ".png");
        IconButtonRenderer.drawTexturedRectUV((double)x + 4.0 * scale, (double)y + 4.0 * scale, 16.0 * scale, 16.0 * scale, 0.0, 0.0, 1.0, 1.0, zLevel);
    }

    private static void bindAndClamp(Minecraft mc, String name) {
        mc.func_110434_K().func_110577_a(ResourceAccess.getNamedResource("textures/gui/" + name));
    }

    private static void drawTexturedRectUV(double x, double y, double w, double h, double u, double v, double us, double vs, float zLevel) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        tess.func_78374_a(x, y + h, (double)zLevel, u, v + vs);
        tess.func_78374_a(x + w, y + h, (double)zLevel, u + us, v + vs);
        tess.func_78374_a(x + w, y, (double)zLevel, u + us, v);
        tess.func_78374_a(x, y, (double)zLevel, u, v);
        tess.func_78381_a();
    }
}

