/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import pcl.lc.core.ResourceAccess;
import pcl.lc.module.stargate.GateAddressHelper;

public class GlyphRenderer {
    private static double uscale;
    private static double vscale;

    public static void drawAddress(Minecraft mc, String address, int x, int y, int length, int scale, float zLevel) {
        GlyphRenderer.bindSGTexture(mc, "symbols.png", 512 / scale, 320 / scale);
        int paddingTop = 0;
        int paddingLeft = 0;
        int borderSize = 12 / scale;
        int cellSize = 64 / scale;
        if (address.length() > 7) {
            cellSize = (int)Math.floor(448 / address.length()) / scale;
            if (448 / scale > address.length() * cellSize) {
                double freeLeftRight = 448 / scale - address.length() * cellSize;
                double freeTopBottom = 64 / scale - cellSize;
                paddingLeft += (int)Math.floor(freeLeftRight / (double)address.length());
                paddingTop += (int)Math.floor(freeTopBottom / 2.0);
            }
        }
        for (int i = 0; i < address.length(); ++i) {
            int s = GateAddressHelper.singleton().index(address.charAt(i));
            double u = uscale * (double)(s / (length - 1) * 32);
            double v = vscale * (double)(s % (length - 1) * 32);
            double u2 = uscale * 32.0;
            double v2 = vscale * 32.0;
            GlyphRenderer.drawTexturedRectUV(x + borderSize + i * cellSize + paddingLeft, y + borderSize + paddingTop, cellSize, cellSize, u, v, u2, v2, zLevel);
        }
    }

    private static void bindSGTexture(Minecraft mc, String name, int usize, int vsize) {
        mc.func_110434_K().func_110577_a(ResourceAccess.getNamedResource("textures/gui/" + name));
        uscale = 1.0 / (double)usize;
        vscale = 1.0 / (double)vsize;
    }

    private static void drawTexturedRectUV(double x, double y, double w, double h, double u, double v, double us, double vs, float zLevel) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        tess.func_78374_a(x, y + h, (double)zLevel, u, v + vs);
        tess.func_78374_a(x + w, y + h, (double)zLevel, u + us, v + vs);
        tess.func_78374_a(x + w, y, (double)zLevel, u + us, v);
        tess.func_78374_a(x, y, (double)zLevel, u, v);
        tess.func_78381_a();
    }
}

