/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.network.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.base.data.WatchedList;
import pcl.lc.base.network.IStreamPackable;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.util.WorldLocation;

public class WatchedListSyncPacket
extends ModPacket {
    private HashMap<Object, Object> valueMap;
    private ArrayList<Object> key_add;
    private ArrayList<Object> key_remove;
    private ArrayList<Object> key_modified;
    private WorldLocation origin;
    private volatile boolean forServer = false;

    public WatchedListSyncPacket() {
        this.valueMap = new HashMap();
        this.key_add = new ArrayList();
        this.key_remove = new ArrayList();
        this.key_modified = new ArrayList();
    }

    public WatchedListSyncPacket(WorldLocation location, WatchedList<String, Object> alist) {
        this.origin = location;
        this.valueMap = new HashMap();
        this.key_add = (ArrayList)alist.added().clone();
        this.key_remove = (ArrayList)alist.removed().clone();
        this.key_modified = (ArrayList)alist.modified().clone();
        for (Object added : this.key_add) {
            this.valueMap.put(added, alist.get((String)added));
        }
        for (Object modified : this.key_modified) {
            this.valueMap.put(modified, alist.get((String)modified));
        }
        for (Object deleted : this.key_remove) {
            if (!this.valueMap.containsKey(deleted)) continue;
            this.valueMap.remove(deleted);
        }
    }

    public void apply(WatchedList<String, Object> alist) {
        for (Object added : this.key_add) {
            alist.set((String)added, this.valueMap.get(added));
        }
        for (Object modified : this.key_modified) {
            alist.set((String)modified, this.valueMap.get(modified));
        }
        for (Object deleted : this.key_remove) {
            alist.remove((String)deleted);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeValue(Object o, DataOutputStream data) throws IOException {
        int intValueOf = ModPacket.getGenericID(o.getClass());
        if (intValueOf == -1) {
            IStreamPackable<?> packer = null;
            if (o instanceof IStreamPackable) {
                packer = (IStreamPackable<?>)o;
            }
            if (packer == null) {
                packer = ModPacket.findPacker(o.getClass());
            }
            if (packer == null) {
                if (!BuildInfo.NET_DEBUGGING) throw new IOException("Cannot pack " + o.getClass().getName() + "; unknown value.");
                LanteaCraft.getLogger().log(Level.WARN, String.format("Cannot pack %s!", o.getClass().getName()));
                throw new IOException("Cannot pack " + o.getClass().getName() + "; unknown value.");
            }
            data.writeInt(255);
            data.writeInt(packer.getTypeOf());
            if (BuildInfo.NET_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("Packing complex of type %s.", packer.getTypeOf()));
            }
            packer.pack(o, data);
            return;
        }
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Packing primitive of type %s.", intValueOf));
        }
        data.writeInt(intValueOf);
        if (intValueOf == -1) return;
        switch (intValueOf) {
            case 0: 
            case 1: {
                data.writeInt((Integer)o);
                return;
            }
            case 2: 
            case 3: {
                data.writeByte((Boolean)o != false ? 1 : 0);
                return;
            }
            case 4: 
            case 5: {
                data.writeDouble((Double)o);
                return;
            }
            case 6: 
            case 7: {
                data.writeFloat(((Float)o).floatValue());
                return;
            }
            case 8: 
            case 9: {
                data.writeChar(((Character)o).charValue());
                return;
            }
            case 10: {
                WatchedListSyncPacket.writeString((String)o, data);
                return;
            }
            case 11: {
                WatchedListSyncPacket.writeArrayList((ArrayList)o, data);
                return;
            }
            case 12: {
                WatchedListSyncPacket.writeHashMap((HashMap)o, data);
                return;
            }
        }
        throw new IOException("Don't know what to do with typeof " + intValueOf);
    }

    public static Object readValue(DataInputStream data) throws IOException {
        int typeAsInt = data.readInt();
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Unpacking primitive of type %s.", typeAsInt));
        }
        if (typeAsInt == -1) {
            return null;
        }
        Class<?> classValueOf = WatchedListSyncPacket.getGeneric(typeAsInt);
        if (classValueOf == null) {
            if (typeAsInt == 255) {
                IStreamPackable<?> packer;
                int packerTypeAsInt = data.readInt();
                if (BuildInfo.NET_DEBUGGING) {
                    LanteaCraft.getLogger().log(Level.INFO, String.format("Unpacking complex of type %s.", packerTypeAsInt));
                }
                if ((packer = ModPacket.findPacker(packerTypeAsInt)) != null) {
                    return packer.unpack(data);
                }
                throw new IOException(String.format("Cannot unpack; unknown value type %d.", packerTypeAsInt));
            }
            throw new IOException(String.format("Cannot unpack; no such generic %d.", typeAsInt));
        }
        if (classValueOf.equals(Integer.TYPE) || classValueOf.equals(Integer.class)) {
            return data.readInt();
        }
        if (classValueOf.equals(Boolean.TYPE) || classValueOf.equals(Boolean.class)) {
            return data.readByte() != 0;
        }
        if (classValueOf.equals(Double.TYPE) || classValueOf.equals(Double.class)) {
            return data.readDouble();
        }
        if (classValueOf.equals(Float.TYPE) || classValueOf.equals(Float.class)) {
            return Float.valueOf(data.readFloat());
        }
        if (classValueOf.equals(Character.TYPE) || classValueOf.equals(Character.class)) {
            return Character.valueOf(data.readChar());
        }
        if (classValueOf.equals(String.class)) {
            return WatchedListSyncPacket.readString(data, 8192);
        }
        if (classValueOf.equals(HashMap.class)) {
            return WatchedListSyncPacket.readHashMap(data);
        }
        if (classValueOf.equals(ArrayList.class)) {
            return WatchedListSyncPacket.readArrayList(data);
        }
        throw new IOException("Do not know what to do with " + classValueOf.getName());
    }

    public static void writeHashMap(HashMap<?, ?> values, DataOutputStream data) throws IOException {
        int sign = 0;
        int written = 0;
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            ++sign;
        }
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Packing %s values in HashMap to stream.", sign));
        }
        data.writeInt(sign);
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            WatchedListSyncPacket.writeValue(entry.getKey(), data);
            WatchedListSyncPacket.writeValue(entry.getValue(), data);
            ++written;
        }
        if (written != sign) {
            throw new IOException(String.format("Could not pack packet, wrote %s pairs, expected %s!", written, sign));
        }
    }

    public static HashMap<?, ?> readHashMap(DataInputStream data) throws IOException {
        int size = data.readInt();
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Unpacking %s values in HashMap from stream.", size));
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (int i = 0; i < size; ++i) {
            Object key = WatchedListSyncPacket.readValue(data);
            Object value = WatchedListSyncPacket.readValue(data);
            result.put(key, value);
        }
        return result;
    }

    public static void writeArrayList(ArrayList<?> array, DataOutputStream data) throws IOException {
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Packing %s values in ArrayList to stream.", array.size()));
        }
        data.writeInt(array.size());
        for (Object o : array) {
            WatchedListSyncPacket.writeValue(o, data);
        }
    }

    public static ArrayList<?> readArrayList(DataInputStream data) throws IOException {
        int size = data.readInt();
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Unpacking %s values in ArrayList from stream.", size));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            result.add(WatchedListSyncPacket.readValue(data));
        }
        return result;
    }

    public static void writeString(String s, DataOutputStream stream) throws IOException {
        stream.writeInt(s.length());
        stream.writeChars(s);
    }

    public static String readString(DataInputStream stream, int max) throws IOException {
        int len = stream.readInt();
        if (len > max) {
            throw new IOException(String.format("String too large: got %s, expected maximum %s!", len, max));
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            builder.append(stream.readChar());
        }
        return builder.toString();
    }

    public void setPacketIsForServer(boolean b) {
        this.forServer = b;
    }

    @Override
    public boolean getPacketIsForServer() {
        return this.forServer;
    }

    @Override
    public String getType() {
        return "WatchedListSyncPacket";
    }

    @Override
    public WorldLocation getOriginLocation() {
        return this.origin;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, "Packing WatchedList modified prototypes into stream.");
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(output);
        data.writeByte(this.forServer ? 1 : 0);
        IStreamPackable<?> packer = ModPacket.findPacker(WorldLocation.class);
        if (this.origin == null) {
            throw new IOException("Cannot encode void location packets.");
        }
        packer.pack(this.origin, data);
        WatchedListSyncPacket.writeArrayList(this.key_add, data);
        WatchedListSyncPacket.writeArrayList(this.key_remove, data);
        WatchedListSyncPacket.writeArrayList(this.key_modified, data);
        WatchedListSyncPacket.writeHashMap(this.valueMap, data);
        data.flush();
        data.close();
        output.flush();
        buffer.writeBytes(output.toByteArray());
    }

    @Override
    public void decodeFrom(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, "Unpacking WatchedList modified prototypes from stream.");
        }
        byte[] b = new byte[buffer.readableBytes() - buffer.readerIndex()];
        buffer.readBytes(b);
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(b));
        this.forServer = data.readByte() == 1;
        IStreamPackable<?> unpacker = ModPacket.findPacker(WorldLocation.class);
        this.origin = (WorldLocation)unpacker.unpack(data);
        this.key_add = WatchedListSyncPacket.readArrayList(data);
        this.key_remove = WatchedListSyncPacket.readArrayList(data);
        this.key_modified = WatchedListSyncPacket.readArrayList(data);
        this.valueMap = WatchedListSyncPacket.readHashMap(data);
    }
}

