/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.network.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import pcl.lc.base.network.IStreamPackable;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.util.WorldLocation;

public class TinyModPacket
extends ModPacket {
    private DataInputStream instream;
    private DataOutputStream outstream;
    private ByteArrayOutputStream outbuff;
    private WorldLocation origin;
    private boolean toServer = false;

    public TinyModPacket() {
    }

    public TinyModPacket(WorldLocation creationOrigin) {
        this.outbuff = new ByteArrayOutputStream();
        this.outstream = new DataOutputStream(this.outbuff);
        this.origin = creationOrigin;
    }

    public TinyModPacket(DataInputStream data, WorldLocation sourceOrigin) {
        this.instream = data;
        this.origin = sourceOrigin;
    }

    @Override
    public WorldLocation getOriginLocation() {
        return this.origin;
    }

    public DataInputStream getIn() {
        return this.instream;
    }

    public DataOutputStream getOut() {
        return this.outstream;
    }

    public void setIsForServer(boolean b) {
        this.toServer = b;
    }

    @Override
    public boolean getPacketIsForServer() {
        return this.toServer;
    }

    @Override
    public String getType() {
        return "TinyPacket";
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        buffer.writeByte(this.toServer ? 1 : 0);
        IStreamPackable<?> packer = ModPacket.findPacker(WorldLocation.class);
        ByteArrayOutputStream vec = new ByteArrayOutputStream();
        DataOutputStream wrapper = new DataOutputStream(vec);
        packer.pack(this.origin, wrapper);
        wrapper.flush();
        wrapper.close();
        buffer.writeBytes(vec.toByteArray());
        this.outstream.flush();
        this.outstream.close();
        buffer.writeBytes(this.outbuff.toByteArray());
    }

    @Override
    public void decodeFrom(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        byte[] b = new byte[buffer.readableBytes() - buffer.readerIndex()];
        buffer.readBytes(b);
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(b));
        IStreamPackable<?> unpacker = ModPacket.findPacker(WorldLocation.class);
        this.toServer = data.readByte() == 1;
        this.origin = (WorldLocation)unpacker.unpack(data);
        this.instream = data;
    }
}

