/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.network.packet;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.base.network.IStreamPackable;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.util.WorldLocation;

public class StandardModPacket
extends ModPacket {
    private String packetType;
    private WorldLocation origin;
    private HashMap<Object, Object> values = new HashMap();
    private volatile boolean isPacketForServer;

    public StandardModPacket() {
    }

    public StandardModPacket(WorldLocation origin) {
        this.origin = origin;
    }

    @Override
    public String getType() {
        return this.packetType;
    }

    @Override
    public WorldLocation getOriginLocation() {
        return this.origin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasField(String name) {
        HashMap<Object, Object> hashMap = this.values;
        synchronized (hashMap) {
            return this.values.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFieldWithValue(String name) {
        HashMap<Object, Object> hashMap = this.values;
        synchronized (hashMap) {
            return this.values.containsKey(name) && this.values.get(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(String name) {
        HashMap<Object, Object> hashMap = this.values;
        synchronized (hashMap) {
            return this.values.get(name);
        }
    }

    public HashMap<Object, Object> getValues() {
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String name, Object value) {
        if (value == null) {
            LanteaCraft.getLogger().log(Level.WARN, String.format("Attempt to pack null value into key %s, this is probably bad.", name));
        }
        HashMap<Object, Object> hashMap = this.values;
        synchronized (hashMap) {
            this.values.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllValues(Map<String, Object> map) {
        HashMap<Object, Object> hashMap = this.values;
        synchronized (hashMap) {
            for (Map.Entry<String, Object> item : map.entrySet()) {
                this.values.put(item.getKey(), item.getValue());
            }
        }
    }

    public void setType(String typeof) {
        this.packetType = typeof;
    }

    public void setIsForServer(boolean state) {
        this.isPacketForServer = state;
    }

    @Override
    public boolean getPacketIsForServer() {
        return this.isPacketForServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasKey(String name) {
        HashMap<Object, Object> hashMap = this.values;
        synchronized (hashMap) {
            return this.values.containsKey(name);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeValue(Object o, DataOutputStream data) throws IOException {
        int intValueOf = ModPacket.getGenericID(o.getClass());
        if (intValueOf == -1) {
            IStreamPackable<?> packer = null;
            if (o instanceof IStreamPackable) {
                packer = (IStreamPackable<?>)o;
            }
            if (packer == null) {
                packer = ModPacket.findPacker(o.getClass());
            }
            if (packer == null) {
                if (!BuildInfo.NET_DEBUGGING) throw new IOException("Cannot pack " + o.getClass().getName() + "; unknown value.");
                LanteaCraft.getLogger().log(Level.WARN, String.format("Cannot pack %s!", o.getClass().getName()));
                throw new IOException("Cannot pack " + o.getClass().getName() + "; unknown value.");
            }
            data.writeInt(255);
            data.writeInt(packer.getTypeOf());
            if (BuildInfo.NET_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("Packing complex of type %s.", packer.getTypeOf()));
            }
            packer.pack(o, data);
            return;
        }
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Packing primitive of type %s.", intValueOf));
        }
        data.writeInt(intValueOf);
        if (intValueOf == -1) return;
        switch (intValueOf) {
            case 0: 
            case 1: {
                data.writeInt((Integer)o);
                return;
            }
            case 2: 
            case 3: {
                data.writeByte((Boolean)o != false ? 1 : 0);
                return;
            }
            case 4: 
            case 5: {
                data.writeDouble((Double)o);
                return;
            }
            case 6: 
            case 7: {
                data.writeFloat(((Float)o).floatValue());
                return;
            }
            case 8: 
            case 9: {
                data.writeChar(((Character)o).charValue());
                return;
            }
            case 10: {
                StandardModPacket.writeString((String)o, data);
                return;
            }
            case 11: {
                StandardModPacket.writeArrayList((ArrayList)o, data);
                return;
            }
            case 12: {
                StandardModPacket.writeHashMap((HashMap)o, data);
                return;
            }
        }
        throw new IOException("Don't know what to do with typeof " + intValueOf);
    }

    public static Object readValue(DataInputStream data) throws IOException {
        int typeAsInt = data.readInt();
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Unpacking primitive of type %s.", typeAsInt));
        }
        if (typeAsInt == -1) {
            return null;
        }
        Class<?> classValueOf = StandardModPacket.getGeneric(typeAsInt);
        if (classValueOf == null) {
            if (typeAsInt == 255) {
                IStreamPackable<?> packer;
                int packerTypeAsInt = data.readInt();
                if (BuildInfo.NET_DEBUGGING) {
                    LanteaCraft.getLogger().log(Level.INFO, String.format("Unpacking complex of type %s.", packerTypeAsInt));
                }
                if ((packer = ModPacket.findPacker(packerTypeAsInt)) != null) {
                    return packer.unpack(data);
                }
                throw new IOException("Cannot unpack; unknown value.");
            }
            throw new IOException("Cannot unpack; unknown value.");
        }
        if (classValueOf.equals(Integer.TYPE) || classValueOf.equals(Integer.class)) {
            return data.readInt();
        }
        if (classValueOf.equals(Boolean.TYPE) || classValueOf.equals(Boolean.class)) {
            return data.readByte() != 0;
        }
        if (classValueOf.equals(Double.TYPE) || classValueOf.equals(Double.class)) {
            return data.readDouble();
        }
        if (classValueOf.equals(Float.TYPE) || classValueOf.equals(Float.class)) {
            return Float.valueOf(data.readFloat());
        }
        if (classValueOf.equals(Character.TYPE) || classValueOf.equals(Character.class)) {
            return Character.valueOf(data.readChar());
        }
        if (classValueOf.equals(String.class)) {
            return StandardModPacket.readString(data, 8192);
        }
        if (classValueOf.equals(HashMap.class)) {
            return StandardModPacket.readHashMap(data);
        }
        if (classValueOf.equals(ArrayList.class)) {
            return StandardModPacket.readArrayList(data);
        }
        throw new IOException("Do not know what to do with " + classValueOf.getName());
    }

    public static void writeHashMap(HashMap<?, ?> values, DataOutputStream data) throws IOException {
        int sign = 0;
        int written = 0;
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            ++sign;
        }
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Packing %s values in HashMap to stream.", sign));
        }
        data.writeInt(sign);
        for (Map.Entry<?, ?> entry : values.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            StandardModPacket.writeValue(entry.getKey(), data);
            StandardModPacket.writeValue(entry.getValue(), data);
            ++written;
        }
        if (written != sign) {
            throw new IOException(String.format("Could not pack packet, wrote %s pairs, expected %s!", written, sign));
        }
    }

    public static HashMap<?, ?> readHashMap(DataInputStream data) throws IOException {
        int size = data.readInt();
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Unpacking %s values in HashMap from stream.", size));
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (int i = 0; i < size; ++i) {
            Object key = StandardModPacket.readValue(data);
            Object value = StandardModPacket.readValue(data);
            result.put(key, value);
        }
        return result;
    }

    public static void writeArrayList(ArrayList<?> array, DataOutputStream data) throws IOException {
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Packing %s values in ArrayList to stream.", array.size()));
        }
        data.writeInt(array.size());
        for (Object o : array) {
            StandardModPacket.writeValue(o, data);
        }
    }

    public static ArrayList<?> readArrayList(DataInputStream data) throws IOException {
        int size = data.readInt();
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Unpacking %s values in ArrayList from stream.", size));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            result.add(StandardModPacket.readValue(data));
        }
        return result;
    }

    public static void writeString(String s, DataOutputStream stream) throws IOException {
        stream.writeInt(s.length());
        stream.writeChars(s);
    }

    public static String readString(DataInputStream stream, int max) throws IOException {
        int len = stream.readInt();
        if (len > max) {
            throw new IOException(String.format("String too large: got %s, expected maximum %s!", len, max));
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            builder.append(stream.readChar());
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("LanteaPacket { ");
        result.append("typeof ").append(this.packetType).append(", ");
        result.append("payload ").append(this.values.size()).append(", ");
        result.append("isforserver ").append(this.isPacketForServer ? "yes" : "no").append(" }");
        result.append(" \n{ ");
        for (Map.Entry<Object, Object> invariate : this.values.entrySet()) {
            result.append(invariate.getKey().toString());
            result.append(": ");
            if (invariate.getValue() != null) {
                result.append(invariate.getValue().toString());
            } else {
                result.append("(null)");
            }
            result.append(", ");
        }
        result.append("}.");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(output);
        if (this.packetType == null || this.packetType.length() == 0) {
            throw new IOException("Cannot pack blank packetType!");
        }
        if (this.origin == null) {
            throw new IOException("Cannot pack blank originType!");
        }
        if (this.packetType.length() > 512) {
            throw new IOException("packetType exceeds maximum length!");
        }
        StandardModPacket.writeString(this.packetType, data);
        data.writeByte(this.isPacketForServer ? 1 : 0);
        IStreamPackable<?> packer = ModPacket.findPacker(WorldLocation.class);
        packer.pack(this.origin, data);
        HashMap<Object, Object> hashMap = this.values;
        synchronized (hashMap) {
            StandardModPacket.writeHashMap(this.values, data);
        }
        data.flush();
        data.close();
        output.flush();
        buffer.writeBytes(output.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decodeFrom(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        byte[] b = new byte[buffer.readableBytes() - buffer.readerIndex()];
        buffer.readBytes(b);
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(b));
        this.packetType = StandardModPacket.readString(data, 512);
        this.isPacketForServer = data.readByte() == 1;
        IStreamPackable<?> unpacker = ModPacket.findPacker(WorldLocation.class);
        this.origin = (WorldLocation)unpacker.unpack(data);
        HashMap<Object, Object> hashMap = this.values;
        synchronized (hashMap) {
            this.values = StandardModPacket.readHashMap(data);
        }
    }
}

