/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.network;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import pcl.lc.base.network.IPacketHandler;
import pcl.lc.base.network.PacketLogger;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.base.network.packet.StandardModPacket;
import pcl.lc.module.stargate.tile.TileStargateBase;
import pcl.lc.util.WorldLocation;

public class ServerPacketHandler {
    private PacketLogger logger;

    public ServerPacketHandler(PacketLogger logger) {
        this.logger = logger;
    }

    public void handlePacket(ModPacket modPacket, EntityPlayer player) {
        TileEntity tile;
        if (this.logger != null) {
            this.logger.logPacket(modPacket);
        }
        WorldLocation target = modPacket.getOriginLocation();
        WorldServer w = DimensionManager.getWorld((int)target.dimension);
        if (modPacket instanceof StandardModPacket) {
            TileEntity tile2;
            StandardModPacket spacket = (StandardModPacket)modPacket;
            if (spacket.getType().equals("LanteaPacket.UpdateRequest")) {
                tile2 = w.func_147438_o(target.x, target.y, target.z);
                if (tile2 instanceof TileStargateBase) {
                    TileStargateBase base = (TileStargateBase)tile2;
                    base.func_145844_m();
                }
            } else if (spacket.getType().equals("LanteaPacket.DialRequest") && (tile2 = w.func_147438_o(target.x, target.y, target.z)) instanceof TileStargateBase) {
                String address = (String)spacket.getValue("Address");
                TileStargateBase base = (TileStargateBase)tile2;
                base.connectOrDisconnect(address);
            }
        }
        if ((tile = w.func_147438_o(target.x, target.y, target.z)) instanceof IPacketHandler) {
            IPacketHandler handler = (IPacketHandler)tile;
            handler.handlePacket(modPacket, player);
        }
    }
}

