/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;
import pcl.lc.base.network.packet.ModPacket;

public class PacketLogger {
    private final File file;
    private FileOutputStream outstream;
    private DataOutputStream datastream;
    private long packetcount = 0L;

    public PacketLogger(File file) {
        this.file = file;
    }

    public void open() {
        try {
            if (this.outstream != null) {
                throw new IOException("Can't reopen an existing PacketLogger.");
            }
            this.outstream = new FileOutputStream(this.file, true);
            this.datastream = new DataOutputStream(this.outstream);
        }
        catch (IOException ioex) {
            LanteaCraft.getLogger().log(Level.WARN, "Could not create PacketLogger, an error occured.", (Throwable)ioex);
        }
    }

    public void close() {
        try {
            this.datastream.flush();
            this.datastream.close();
            this.outstream.flush();
            this.outstream.close();
        }
        catch (IOException ioex) {
            LanteaCraft.getLogger().log(Level.WARN, "Could not close PacketLogger, an error occured.", (Throwable)ioex);
        }
    }

    public void logPacket(ModPacket packet) {
        if (this.datastream == null) {
            return;
        }
        try {
            ByteBuf virt_buff = Unpooled.buffer();
            packet.encodeInto(null, virt_buff);
            this.datastream.writeLong(this.packetcount++);
            this.datastream.writeLong(virt_buff.array().length);
            this.datastream.write(virt_buff.array());
            if (this.packetcount >= 0x7FFFFFFFFFFFFFFEL) {
                this.packetcount %= 0x7FFFFFFFFFFFFFFEL;
            }
        }
        catch (IOException ioex) {
            LanteaCraft.getLogger().log(Level.WARN, "Could not pack ModPacket into PacketLogger stream.", (Throwable)ioex);
        }
    }
}

