/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.io.IOException;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.common.network.ForgeMessage;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.base.network.packet.StandardModPacket;
import pcl.lc.base.network.packet.TinyModPacket;
import pcl.lc.base.network.packet.WatchedListContainerPacket;
import pcl.lc.base.network.packet.WatchedListRequestPacket;
import pcl.lc.base.network.packet.WatchedListSyncPacket;
import pcl.lc.util.WorldLocation;

@ChannelHandler.Sharable
public class PCLPacketPipeline
extends MessageToMessageCodec<FMLProxyPacket, ModPacket> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private LinkedList<Class<? extends ModPacket>> packets = new LinkedList();

    public boolean registerPacket(Class<? extends ModPacket> clazz) {
        if (this.packets.size() > 256 || this.packets.contains(clazz)) {
            return false;
        }
        this.packets.add(clazz);
        return true;
    }

    public void init(String channelName) {
        this.channels = NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{this});
        this.registerPacket(TinyModPacket.class);
        this.registerPacket(StandardModPacket.class);
        this.registerPacket(WatchedListContainerPacket.class);
        this.registerPacket(WatchedListRequestPacket.class);
        this.registerPacket(WatchedListSyncPacket.class);
    }

    protected void encode(ChannelHandlerContext ctx, ModPacket msg, List<Object> out) throws Exception {
        Class<?> clazz = msg.getClass();
        if (!this.packets.contains(msg.getClass())) {
            LanteaCraft.getLogger().log(Level.FATAL, String.format("Attempt to send unregistered packet class %s!", msg.getClass().getCanonicalName()));
        }
        ByteBuf buffer = Unpooled.buffer();
        byte discriminator = (byte)this.packets.indexOf(clazz);
        buffer.writeByte((int)discriminator);
        msg.encodeInto(ctx, buffer);
        FMLProxyPacket proxyPacket = new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        out.add(proxyPacket);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        EntityPlayer player;
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        Class<? extends ModPacket> clazz = this.packets.get(discriminator);
        if (clazz == null) {
            LanteaCraft.getLogger().log(Level.FATAL, String.format("Attempt to handlle unregistered packet class %s!", discriminator));
        }
        ModPacket pkt = clazz.newInstance();
        pkt.decodeFrom(ctx, payload.slice());
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                player = this.getClientPlayer();
                break;
            }
            case SERVER: {
                INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                player = ((NetHandlerPlayServer)netHandler).field_147369_b;
                break;
            }
            default: {
                throw new IOException("Instance is not client or server. Cannot continue!");
            }
        }
        LanteaCraft.getProxy().handlePacket(pkt, player);
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAll(ModPacket message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendTo(ModPacket message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendForgeMessageTo(ForgeMessage message, EntityPlayerMP player) {
        FMLEmbeddedChannel channel = NetworkRegistry.INSTANCE.getChannel("FORGE", Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channel.writeAndFlush((Object)message);
    }

    public void sendToAllAround(ModPacket message, WorldLocation location, double range) {
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(location.dimension, (double)location.x, (double)location.y, (double)location.z, range);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToDimension(ModPacket message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToServer(ModPacket message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message);
    }
}

