/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;
import pcl.lc.LanteaCraftClientProxy;
import pcl.lc.base.network.IPacketHandler;
import pcl.lc.base.network.PacketLogger;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.base.network.packet.StandardModPacket;
import pcl.lc.base.render.gfx.EffectBeam;
import pcl.lc.util.WorldLocation;

public class ClientPacketHandler {
    private PacketLogger logger;

    public ClientPacketHandler(PacketLogger logger) {
        this.logger = logger;
    }

    public void handlePacket(ModPacket packet, EntityPlayer player) {
        WorldLocation target;
        if (this.logger != null) {
            this.logger.logPacket(packet);
        }
        if ((target = packet.getOriginLocation()) == null) {
            LanteaCraft.getLogger().log(Level.WARN, String.format("ModPacket type %s sent without OriginLocation, much bad!", packet.getClass()));
        }
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71441_e.field_73011_w == null) {
            return;
        }
        int currentWorld = Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g;
        if (currentWorld == target.dimension) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (packet.getType().equals("LanteaPacket.EntityFX")) {
                StandardModPacket payload = (StandardModPacket)packet;
                String name = (String)payload.getValue("FXType");
                EntityFX effect = null;
                if (name.equals("EffectBeam")) {
                    effect = EffectBeam.fromPacket(payload);
                }
                if (effect != null) {
                    ((LanteaCraftClientProxy)LanteaCraft.getProxy()).spawnEffect(effect);
                }
            } else {
                TileEntity tile = world.func_147438_o(target.x, target.y, target.z);
                if (tile instanceof IPacketHandler) {
                    IPacketHandler handler = (IPacketHandler)tile;
                    handler.handlePacket(packet, player);
                }
            }
        }
    }
}

