/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.multiblock;

import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import pcl.lc.LanteaCraft;
import pcl.lc.base.multiblock.EnumOrientations;
import pcl.lc.base.multiblock.MultiblockPart;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.util.Vector3;

public abstract class GenericMultiblock {
    protected EnumOrientations structureOrientation;
    protected HashMap<Object, MultiblockPart> structureParts = new HashMap();
    protected HashMap<String, Object> metadata = new HashMap();
    protected boolean wasInvalidated = false;
    protected boolean isValid = false;
    protected boolean isClient = false;
    protected boolean hasUpdate = false;
    protected TileEntity host;
    protected int xCoord;
    protected int yCoord;
    protected int zCoord;

    public GenericMultiblock(TileEntity host) {
        this.host = host;
    }

    public void tick() {
        if (this.host.func_145831_w() != null) {
            this.isClient = this.host.func_145831_w().field_72995_K;
        }
        if (this.isClient && !this.hasUpdate) {
            ModPacket packet = this.pollForUpdate();
            LanteaCraft.getNetPipeline().sendToServer(packet);
            this.hasUpdate = true;
        }
        if (this.wasInvalidated() && !this.isClient) {
            this.validate(this.host.func_145831_w(), this.host.field_145851_c, this.host.field_145848_d, this.host.field_145849_e);
        }
    }

    public abstract boolean isValidStructure(World var1, int var2, int var3, int var4);

    public abstract boolean collectStructure(World var1, int var2, int var3, int var4);

    public abstract void freeStructure();

    public abstract MultiblockPart getPart(Object var1);

    public abstract MultiblockPart[] getAllParts();

    public abstract void validated(boolean var1, boolean var2);

    public abstract void disband();

    public abstract ModPacket pack();

    public abstract void unpack(ModPacket var1);

    public abstract ModPacket pollForUpdate();

    protected void setLocation(int x, int y, int z) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
    }

    public Vector3 getLocation() {
        return new Vector3(this.xCoord, this.yCoord, this.zCoord);
    }

    public void validate(World world, int baseX, int baseY, int baseZ) {
        this.wasInvalidated = false;
        if (this.isValidStructure(world, baseX, baseY, baseZ)) {
            boolean wasValid = this.isValid();
            this.isValid = this.collectStructure(world, baseX, baseY, baseZ);
            if (this.isValid) {
                this.setLocation(baseX, baseY, baseZ);
            }
            this.validated(wasValid, this.isValid);
        } else if (this.isValid()) {
            this.freeStructure();
            this.isValid = false;
            this.validated(this.isValid(), false);
        }
    }

    public void invalidate() {
        this.wasInvalidated = true;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(World world, boolean b) {
        if (!this.isClient) {
            return;
        }
        this.isValid = b;
    }

    public boolean wasInvalidated() {
        return this.wasInvalidated;
    }

    public EnumOrientations getOrientation() {
        return this.structureOrientation;
    }

    public void setOrientation(EnumOrientations orientation) {
        if (!this.isClient) {
            return;
        }
        this.structureOrientation = orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetadata(String name, Object o) {
        HashMap<String, Object> hashMap = this.metadata;
        synchronized (hashMap) {
            this.metadata.put(name, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getMetadata(String name) {
        HashMap<String, Object> hashMap = this.metadata;
        synchronized (hashMap) {
            return this.metadata.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetadata(String name) {
        HashMap<String, Object> hashMap = this.metadata;
        synchronized (hashMap) {
            this.metadata.remove(name);
        }
    }

    public TileEntity getTileEntity() {
        return this.host;
    }
}

