/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.energy;

import java.util.LinkedHashSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import pcl.lc.base.energy.IEnergyGridNode;
import pcl.lc.base.energy.IEnergyStore;

public class EnergyGrid {
    protected World world;
    protected IEnergyGridNode masterTile;
    protected LinkedHashSet<IEnergyGridNode> childTiles;
    protected GridStorage storage;

    public EnergyGrid(World w) {
        this.world = w;
        this.storage = new GridStorage(64.0);
    }

    public void save(IEnergyGridNode tile, NBTTagCompound compound) {
        if (tile != this.masterTile) {
            throw new RuntimeException("save called from wrong node!");
        }
        NBTTagCompound subCompound = new NBTTagCompound();
        this.storage.saveEnergyStore(subCompound);
        compound.func_74782_a("storage", (NBTBase)subCompound);
    }

    public void load(IEnergyGridNode tile, NBTTagCompound compound) {
        if (tile != this.masterTile) {
            throw new RuntimeException("load called from wrong node!");
        }
        this.storage.loadEnergyStore(compound.func_74775_l("storage"));
    }

    public void advance(IEnergyGridNode tile) {
        if (tile != this.masterTile) {
            throw new RuntimeException("advance called from wrong node!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTile(IEnergyGridNode tile) {
        LinkedHashSet<IEnergyGridNode> linkedHashSet = this.childTiles;
        synchronized (linkedHashSet) {
            if (!this.childTiles.contains(tile)) {
                this.childTiles.add(tile);
                tile.setGrid(this);
                this.tagTile(tile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTile(IEnergyGridNode tile) {
        LinkedHashSet<IEnergyGridNode> linkedHashSet = this.childTiles;
        synchronized (linkedHashSet) {
            this.childTiles.remove(tile);
        }
        if (this.masterTile == tile) {
            this.findMasterTile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(EnergyGrid that) {
        LinkedHashSet<IEnergyGridNode> linkedHashSet = that.childTiles;
        synchronized (linkedHashSet) {
            LinkedHashSet<IEnergyGridNode> linkedHashSet2 = this.childTiles;
            synchronized (linkedHashSet2) {
                for (IEnergyGridNode tile : that.childTiles) {
                    if (this.childTiles.contains(tile)) continue;
                    this.childTiles.add(tile);
                    tile.setGrid(this);
                    this.tagTile(tile);
                }
            }
        }
        this.storage.receiveEnergy(that.storage.getEnergyStored(), false);
        that.storage.extractEnergy(that.storage.getEnergyStored(), false);
        that.disband();
    }

    public void disband() {
        this.masterTile = null;
        this.childTiles.clear();
    }

    private void findMasterTile() {
        if (this.masterTile != null) {
            this.masterTile.doesTick(false);
        }
        if (this.childTiles.size() > 0) {
            this.tagTile((IEnergyGridNode)this.childTiles.iterator().next());
        }
    }

    private void tagTile(IEnergyGridNode tile) {
        if (this.masterTile == null || this.masterTile == tile) {
            this.masterTile = tile;
            tile.doesTick(true);
        } else {
            tile.doesTick(false);
        }
    }

    public boolean isMaster(IEnergyGridNode tile) {
        return tile == this.masterTile;
    }

    private class GridStorage
    implements IEnergyStore {
        private double quantity;
        private double maximum;

        public GridStorage(double max) {
            this.maximum = max;
        }

        @Override
        public double receiveEnergy(double quantity, boolean isSimulated) {
            double maxima = Math.min(quantity, Math.max(this.maximum - this.quantity, 0.0));
            if (!isSimulated) {
                this.quantity += maxima;
            }
            return quantity;
        }

        @Override
        public double extractEnergy(double quantity, boolean isSimulated) {
            double maxima = Math.min(quantity, this.quantity);
            if (!isSimulated) {
                this.quantity -= maxima;
            }
            return maxima;
        }

        @Override
        public double getEnergyStored() {
            return this.quantity;
        }

        @Override
        public double getMaxEnergyStored() {
            return this.maximum;
        }

        @Override
        public void saveEnergyStore(NBTTagCompound compound) {
            compound.func_74780_a("stored-energy", this.quantity);
        }

        @Override
        public void loadEnergyStore(NBTTagCompound compound) {
            this.quantity = compound.func_74769_h("stored-energy");
        }
    }
}

