/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import pcl.lc.base.data.Observable;
import pcl.lc.base.data.ObserverContext;

public class WatchedList<A, B>
extends Observable {
    private HashMap<A, B> values = new HashMap();
    private ArrayList<A> key_add = new ArrayList();
    private ArrayList<A> key_remove = new ArrayList();
    private ArrayList<A> key_modified = new ArrayList();

    public WatchedList() {
        super(null);
    }

    public WatchedList(Observable parent) {
        super(parent);
    }

    @Override
    public void clearModified(ObserverContext context) {
        super.clearModified(context);
        this.key_add.clear();
        this.key_remove.clear();
        this.key_modified.clear();
    }

    public B get(A key) {
        return this.values.get(key);
    }

    public Set<Map.Entry<A, B>> entrySet() {
        return this.values.entrySet();
    }

    public Iterator<B> values() {
        return this.values.values().iterator();
    }

    public Iterator<A> keys() {
        return this.values.keySet().iterator();
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    public B set(A key, B value) {
        if (this.key_remove.contains(key)) {
            this.key_remove.remove(key);
            this.modify();
        }
        if (!this.values.containsKey(key) && !this.key_add.contains(key)) {
            this.key_add.add(key);
            this.modify();
        }
        if (this.values.containsKey(key) && !this.key_modified.contains(key) && !this.values.get(key).equals(value)) {
            this.key_modified.add(key);
            this.modify();
        }
        return this.values.put(key, value);
    }

    public int size() {
        return this.values.size();
    }

    public B remove(A key) {
        this.modify();
        if (this.key_add.contains(key)) {
            this.key_add.remove(key);
        }
        if (this.values.containsKey(key) && !this.key_remove.contains(key)) {
            this.key_remove.add(key);
        }
        return this.values.remove(key);
    }

    public void clear() {
        this.modify();
        for (A next : this.values.keySet()) {
            if (this.key_add.contains(next)) {
                this.key_add.remove(next);
            }
            if (this.key_remove.contains(next)) continue;
            this.key_remove.add(next);
        }
        this.values.clear();
    }

    public ArrayList<A> added() {
        return this.key_add;
    }

    public ArrayList<A> removed() {
        return this.key_remove;
    }

    public ArrayList<A> modified() {
        return this.key_modified;
    }

    public boolean equals(Object o) {
        return this.values.equals(o);
    }
}

