/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import java.lang.reflect.Constructor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Level;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumUnits;
import pcl.lc.base.TileManaged;
import pcl.lc.coremod.RuntimeAnnotation;

public abstract class PoweredTileEntity
extends TileManaged {
    protected Object receiverBuffer;
    protected boolean addedToEnergyNet;

    public PoweredTileEntity() {
        if (Loader.isModLoaded((String)"BuildCraft|Core")) {
            PowerHandler b = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.MACHINE);
            float maxRecieveQuantity = (float)EnumUnits.convertFromNaquadahUnit(EnumUnits.MinecraftJoules, this.getMaximumReceiveEnergy());
            b.configure(0.0, (double)maxRecieveQuantity, maxRecieveQuantity == 0.0f ? 99999.0 : 1.0, maxRecieveQuantity == 0.0f ? 0.0 : 1000.0);
            b.configurePowerPerdition(0, 0);
            this.receiverBuffer = b;
        }
    }

    public abstract boolean canReceiveEnergy();

    public abstract boolean canExportEnergy();

    public abstract double getMaximumReceiveEnergy();

    public abstract double getMaximumExportEnergy();

    public abstract double getAvailableExportEnergy();

    public abstract void receiveEnergy(double var1);

    public abstract double exportEnergy(double var1);

    public abstract boolean canEnergyFormatConnectToSide(EnumUnits var1, ForgeDirection var2);

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.canExportEnergy() && !this.field_145850_b.field_72995_K && this.receiverBuffer != null) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                this.emitEnergy(direction);
            }
        }
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergyEmitter")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.canEnergyFormatConnectToSide(EnumUnits.EnergyUnit, direction) && this.canExportEnergy();
    }

    @RuntimeAnnotation.RuntimeInterface(modid="BuildCraft|Core", clazz="buildcraft.api.power.IPowerEmitter")
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return this.canEnergyFormatConnectToSide(EnumUnits.MinecraftJoules, side) && this.canExportEnergy();
    }

    @RuntimeAnnotation.RuntimeInterface(modid="BuildCraft|Core", clazz="buildcraft.api.power.IPowerReceptor")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return ((PowerHandler)this.receiverBuffer).getPowerReceiver();
    }

    @RuntimeAnnotation.RuntimeInterface(modid="BuildCraft|Core", clazz="buildcraft.api.power.IPowerReceptor")
    public void doWork(PowerHandler workProvider) {
        float quantity = (float)workProvider.useEnergy(0.0, 100.0, true);
        double naqQuantity = EnumUnits.convertToNaquadahUnit(EnumUnits.MinecraftJoules, quantity);
        this.receiveEnergy(naqQuantity);
    }

    @RuntimeAnnotation.RuntimeInterface(modid="BuildCraft|Core", clazz="buildcraft.api.power.IPowerReceptor")
    public World getWorld() {
        return this.field_145850_b;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergyAcceptor")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.canEnergyFormatConnectToSide(EnumUnits.EnergyUnit, direction) && this.canReceiveEnergy();
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergySource")
    public double getOfferedEnergy() {
        double naqAvailable = this.getAvailableExportEnergy();
        return EnumUnits.convertFromNaquadahUnit(EnumUnits.EnergyUnit, naqAvailable);
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergySource")
    public void drawEnergy(double amount) {
        double naqQuantity = EnumUnits.convertToNaquadahUnit(EnumUnits.EnergyUnit, amount);
        this.exportEnergy(naqQuantity);
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergySink")
    public double demandedEnergyUnits() {
        if (!this.canReceiveEnergy()) {
            return 0.0;
        }
        return EnumUnits.convertFromNaquadahUnit(EnumUnits.EnergyUnit, this.getMaximumReceiveEnergy());
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergySink")
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (!this.canReceiveEnergy()) {
            return 0.0;
        }
        double quantity = EnumUnits.convertToNaquadahUnit(EnumUnits.EnergyUnit, amount);
        this.receiveEnergy(quantity);
        return amount;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergySink")
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    protected void postIC2Update(boolean actionIsLoad) {
        LanteaCraft.getLogger().log(Level.INFO, String.format("Sending IC2 state.", new Object[0]));
        try {
            Class<?> clazz_ic2energytile = Class.forName("ic2.api.energy.tile.IEnergyTile", false, this.getClass().getClassLoader());
            if (actionIsLoad) {
                Class<?> clazz_loadevent = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent", false, this.getClass().getClassLoader());
                Constructor<?> c_loadevent = clazz_loadevent.getConstructor(clazz_ic2energytile);
                WorldEvent event = (WorldEvent)c_loadevent.newInstance(clazz_ic2energytile.cast(this));
                LanteaCraft.getLogger().log(Level.INFO, String.format("Sending IC2 event class %s", event.getClass().getName()));
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.addedToEnergyNet = true;
            } else {
                Class<?> clazz_loadevent = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent", false, this.getClass().getClassLoader());
                Constructor<?> c_unloadevent = clazz_loadevent.getConstructor(clazz_ic2energytile);
                WorldEvent event = (WorldEvent)c_unloadevent.newInstance(clazz_ic2energytile.cast(this));
                LanteaCraft.getLogger().log(Level.INFO, String.format("Sending IC2 event class %s", event.getClass().getName()));
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.addedToEnergyNet = false;
            }
        }
        catch (Throwable t) {
            LanteaCraft.getLogger().log(Level.WARN, "Could not push IC2 energy event.", t);
        }
    }

    private void emitEnergy(ForgeDirection direction) {
        int x = direction.offsetX + this.field_145851_c;
        int y = direction.offsetY + this.field_145848_d;
        int z = direction.offsetZ + this.field_145849_e;
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        if (tile != null && tile instanceof IPowerReceptor && ((IPowerReceptor)tile).getPowerReceiver(direction.getOpposite()) != null) {
            PowerHandler.PowerReceiver receptor = ((IPowerReceptor)tile).getPowerReceiver(direction.getOpposite());
            float maxQuantity = (float)receptor.getMaxEnergyReceived();
            float maxAvailQuantity = (float)EnumUnits.convertFromNaquadahUnit(EnumUnits.MinecraftJoules, this.getAvailableExportEnergy());
            float send = Math.min(maxQuantity, maxAvailQuantity);
            float quantityUsed = (float)receptor.receiveEnergy(PowerHandler.Type.MACHINE, (double)send, direction.getOpposite());
            this.exportEnergy(EnumUnits.convertToNaquadahUnit(EnumUnits.MinecraftJoules, quantityUsed));
        }
    }

    @RuntimeAnnotation.RuntimeInterface(modid="CoFHCore", clazz="cofh.api.energy.IEnergyHandler")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.canReceiveEnergy()) {
            return 0;
        }
        int quantity = (int)Math.floor(EnumUnits.convertToNaquadahUnit(EnumUnits.RedstoneFlux, maxReceive));
        if (!simulate) {
            this.receiveEnergy(quantity);
        }
        return quantity;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="CoFHCore", clazz="cofh.api.energy.IEnergyHandler")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.canExportEnergy()) {
            return 0;
        }
        int maxAvailQuantity = (int)EnumUnits.convertFromNaquadahUnit(EnumUnits.RedstoneFlux, this.getAvailableExportEnergy());
        int send = Math.min(maxExtract, maxAvailQuantity);
        if (!simulate) {
            this.exportEnergy(send);
        }
        return send;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="CoFHCore", clazz="cofh.api.energy.IEnergyHandler")
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="CoFHCore", clazz="cofh.api.energy.IEnergyHandler")
    public int getEnergyStored(ForgeDirection from) {
        return (int)EnumUnits.convertFromNaquadahUnit(EnumUnits.RedstoneFlux, this.getAvailableExportEnergy());
    }

    @RuntimeAnnotation.RuntimeInterface(modid="CoFHCore", clazz="cofh.api.energy.IEnergyHandler")
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)EnumUnits.convertFromNaquadahUnit(EnumUnits.RedstoneFlux, this.getMaximumExportEnergy());
    }
}

