/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.base;

import java.util.HashMap;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.Rectangle;
import pcl.lc.base.GenericContainerGUI;

public abstract class GenericTabbedContainer
extends GenericContainerGUI {
    private HashMap<Integer, ContainerTab> tabList = this.getTabs();
    private ContainerTab activeTab;

    public GenericTabbedContainer(Container container, int width, int height) {
        super(container, width, height);
        this.switchTab(0);
    }

    protected abstract HashMap<Integer, ContainerTab> getTabs();

    public void switchTab(int to) {
        ContainerTab nextTab = this.tabList.get(to);
        if (nextTab == null) {
            nextTab = this.tabList.get(0);
        }
        if (this.activeTab != null) {
            this.activeTab.onTabClosed(this);
        }
        this.activeTab = nextTab;
        this.activeTab.onTabOpened(this);
    }

    @Override
    protected void drawBackgroundLayer(float partialTickCount, int mouseX, int mouseY) {
        if (this.activeTab != null) {
            this.activeTab.drawBackgroundLayer(partialTickCount, mouseX, mouseY);
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        if (this.activeTab != null) {
            this.activeTab.drawForegroundLayer(mouseX, mouseY);
        }
    }

    protected void func_73869_a(char c, int key) {
        if (this.activeTab != null) {
            this.activeTab.keyTyped(c, key);
        }
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        if (this.activeTab != null) {
            this.activeTab.mouseClicked(x, y, mouseButton);
        }
    }

    protected void func_146286_b(int x, int y, int mouseButton) {
        if (this.activeTab != null) {
            this.activeTab.mouseMovedOrUp(x, y, mouseButton);
        }
    }

    public abstract class ContainerTab {
        protected abstract void onTabOpened(GenericTabbedContainer var1);

        protected abstract void onTabClosed(GenericTabbedContainer var1);

        protected abstract String getTabName();

        protected abstract ResourceLocation getTabIcon();

        protected abstract Rectangle getTabDimensions();

        protected abstract void drawBackgroundLayer(float var1, int var2, int var3);

        protected abstract void drawForegroundLayer(int var1, int var2);

        protected abstract void mouseClicked(int var1, int var2, int var3);

        protected abstract void mouseMovedOrUp(int var1, int var2, int var3);

        protected abstract void keyTyped(char var1, int var2);
    }
}

