/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import org.apache.logging.log4j.Level;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.base.network.ClientPacketHandler;
import pcl.lc.base.network.PacketLogger;
import pcl.lc.base.network.ServerPacketHandler;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.base.worldgen.NaquadahOreWorldGen;
import pcl.lc.cfg.ModuleList;
import pcl.lc.cfg.XMLParser;
import pcl.lc.cfg.XMLSaver;
import pcl.lc.client.audio.AudioEngine;
import pcl.lc.core.GUIHandler;
import pcl.lc.core.ModuleManager;
import pcl.lc.core.RemoteChunkLoading;
import pcl.lc.core.ServerTickHandler;
import pcl.lc.core.WorldLog;
import pcl.lc.module.ModuleWorldGenerator;
import pcl.lc.module.compat.UpgradeHelper;
import pcl.lc.module.stargate.StargateConnectionManager;
import pcl.lc.util.AnalyticsHelper;
import pcl.lc.util.NetworkHelpers;
import pcl.lc.util.RegistrationHelper;
import pcl.lc.util.VersionHelper;

public class LanteaCraftCommonProxy {
    protected File configFile;
    protected ModuleList moduleConfig;
    protected AnalyticsHelper analyticsHelper = new AnalyticsHelper(false, null);
    private VersionHelper versionHelper = new VersionHelper();
    protected ClientPacketHandler clientPacketHandler;
    protected PacketLogger clientPacketLogger;
    protected ServerPacketHandler serverPacketHandler;
    protected PacketLogger serverPacketLogger;
    protected GUIHandler guiHandler;
    private NetworkHelpers networkHelpers;
    private UpgradeHelper upgradeHelper;
    protected RemoteChunkLoading remoteChunkManager;
    protected StargateConnectionManager stargateConnectionManager;
    protected AudioEngine audioContext;
    protected WorldLog worldLogger;
    private ServerTickHandler serverTickHandler = new ServerTickHandler(this.versionHelper);
    public int tokraVillagerID;
    protected ModuleManager moduleManager;

    public LanteaCraftCommonProxy() {
        if (BuildInfo.NET_DEBUGGING) {
            this.serverPacketLogger = new PacketLogger(new File("lc-network-server.dat"));
        }
        this.serverPacketHandler = new ServerPacketHandler(this.serverPacketLogger);
        this.networkHelpers = new NetworkHelpers();
    }

    public void preInit(FMLPreInitializationEvent e) {
        if (BuildInfo.isDevelopmentEnvironment()) {
            LanteaCraft.getLogger().log(Level.WARN, "This doesn't appear to be an official build of LanteaCraft, or you are in a development context; please do not report bugs to us. We do not support external builds.");
        } else {
            LanteaCraft.getLogger().log(Level.INFO, "Hello there, I'm LanteaCraft RC2-" + BuildInfo.getBuildNumber() + "!");
        }
        try {
            File configDir = new File(e.getModConfigurationDirectory(), "LanteaCraft/");
            if (!configDir.exists()) {
                configDir.mkdir();
            }
            this.configFile = new File(configDir, "config.xml");
            if (this.configFile.exists()) {
                XMLParser parser = new XMLParser();
                FileInputStream test = new FileInputStream(this.configFile);
                this.moduleConfig = parser.read(test);
            } else {
                this.moduleConfig = new ModuleList();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error configuring LanteaCraft!", t);
        }
        this.configure();
        this.moduleManager = new ModuleManager(this.moduleConfig);
        this.moduleManager.preInit(e);
    }

    public void init(FMLInitializationEvent e) {
        LanteaCraft.getLogger().log(Level.INFO, "LanteaCraft setting up...");
        MinecraftForge.EVENT_BUS.register((Object)LanteaCraft.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)LanteaCraft.getSpecialBucketHandler());
        this.remoteChunkManager = new RemoteChunkLoading();
        this.stargateConnectionManager = new StargateConnectionManager();
        this.serverTickHandler.registerTickHost(this.remoteChunkManager);
        this.serverTickHandler.registerTickHost(this.stargateConnectionManager);
        this.audioContext = new AudioEngine();
        this.guiHandler = new GUIHandler();
        FMLCommonHandler.instance().bus().register((Object)this.serverTickHandler);
        this.networkHelpers.init();
        this.moduleManager.init(e);
    }

    public void postInit(FMLPostInitializationEvent e) {
        RegistrationHelper.flagLateRegistrationZone();
        if (this.moduleConfig.modified()) {
            try {
                XMLSaver saver = new XMLSaver();
                saver.save(this.moduleConfig, new FileOutputStream(this.configFile));
            }
            catch (Throwable t) {
                LanteaCraft.getLogger().log(Level.WARN, "Failed updating configuration!", t);
            }
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)LanteaCraft.getInstance(), (IGuiHandler)this.guiHandler);
        LanteaCraft.getLogger().log(Level.INFO, "LanteaCraft done setting up!");
        LanteaCraft.getLogger().log(Level.INFO, "[COMPAT] LanteaCraft looking for other versions of SGCraft...");
        if (UpgradeHelper.detectSGCraftInstall()) {
            this.upgradeHelper = new UpgradeHelper();
            this.upgradeHelper.hookSGCraft();
        }
        LanteaCraft.getLogger().log(Level.INFO, "[COMPAT] LanteaCraft done looking for other versions.");
        this.moduleManager.postInit(e);
    }

    public NaquadahOreWorldGen getOreGenerator() {
        if (!ModuleManager.Module.WORLDGEN.isLoaded()) {
            return null;
        }
        return ((ModuleWorldGenerator)ModuleManager.Module.WORLDGEN.moduleOf()).getNaquadahOreGenerator();
    }

    public VersionHelper getVersionHelper() {
        return this.versionHelper;
    }

    public AudioEngine getAudioEngine() {
        return this.audioContext;
    }

    public void onInitMapGen(InitMapGenEvent e) {
        LanteaCraft.getLogger().log(Level.DEBUG, "InitMapGenEvent fired");
    }

    void configure() {
        this.versionHelper.start();
    }

    public void handlePacket(ModPacket modPacket, EntityPlayer player) {
        if (!modPacket.getPacketIsForServer()) {
            return;
        }
        this.serverPacketHandler.handlePacket(modPacket, player);
    }

    public void onServerStarting(FMLServerStartingEvent e) {
        if (this.worldLogger != null) {
            this.worldLogger.close();
            this.worldLogger = null;
        }
        try {
            File base = new File(new File(".").getCanonicalPath());
            File datadir = new File(base, "saves/" + e.getServer().func_71270_I() + "/data").getAbsoluteFile();
            File logfile = new File(datadir, "LanteaCraft.log");
            this.worldLogger = new WorldLog(logfile);
            LanteaCraft.getLogger().log(Level.INFO, String.format("WorldLog starting: %s", logfile.toString()));
            this.worldLogger.open();
        }
        catch (IOException ioex) {
            LanteaCraft.getLogger().log(Level.WARN, "Failed to resolve paths for WorldLog.", (Throwable)ioex);
        }
    }

    public void onServerStopping(FMLServerStoppingEvent e) {
        if (this.worldLogger != null) {
            LanteaCraft.getLogger().log(Level.INFO, "WorldLog shutting down...");
            this.worldLogger.close();
            this.worldLogger = null;
        }
    }

    public WorldLog getWorldLog() {
        return this.worldLogger;
    }

    public RemoteChunkLoading getRemoteChunkManager() {
        return this.remoteChunkManager;
    }

    public StargateConnectionManager getConnectionManager() {
        return this.stargateConnectionManager;
    }
}

