/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.LanteaCraftCommonProxy;
import pcl.lc.base.network.ClientPacketHandler;
import pcl.lc.base.network.PacketLogger;
import pcl.lc.base.network.packet.ModPacket;
import pcl.lc.client.GUIHandlerClient;
import pcl.lc.client.audio.ClientAudioEngine;
import pcl.lc.core.ClientTickHandler;
import pcl.lc.module.machine.gui.ScreenCrystalInfuser;
import pcl.lc.module.power.gui.ScreenNaquadahGenerator;
import pcl.lc.module.stargate.gui.ScreenStargateBase;
import pcl.lc.module.stargate.gui.ScreenStargateDHDEnergy;
import pcl.lc.util.CloakHandler;
import pcl.lc.util.RegistrationHelper;

public class LanteaCraftClientProxy
extends LanteaCraftCommonProxy {
    private ClientTickHandler clientTickHandler = new ClientTickHandler();
    private CloakHandler cloakHandler = new CloakHandler("http://lanteacraft.com/api/cloaks");

    public LanteaCraftClientProxy() {
        if (BuildInfo.NET_DEBUGGING) {
            this.clientPacketLogger = new PacketLogger(new File("lc-network-client.dat"));
        }
        this.clientPacketHandler = new ClientPacketHandler(this.clientPacketLogger);
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        this.cloakHandler.buildDatabase();
        FMLCommonHandler.instance().bus().register((Object)this.cloakHandler);
        FMLCommonHandler.instance().bus().register((Object)this.clientTickHandler);
        this.audioContext = new ClientAudioEngine();
        this.audioContext.initialize();
        this.guiHandler = new GUIHandlerClient();
        MinecraftForge.EVENT_BUS.register((Object)this.audioContext);
        this.clientTickHandler.registerTickHost(this.audioContext);
        this.registerScreens();
    }

    public void registerScreens() {
        RegistrationHelper.registerGui(LanteaCraft.EnumGUIs.StargateBase.ordinal(), ScreenStargateBase.class);
        RegistrationHelper.registerGui(LanteaCraft.EnumGUIs.StargateDHDEnergy.ordinal(), ScreenStargateDHDEnergy.class);
        RegistrationHelper.registerGui(LanteaCraft.EnumGUIs.NaquadahGenerator.ordinal(), ScreenNaquadahGenerator.class);
        RegistrationHelper.registerGui(LanteaCraft.EnumGUIs.CrystalInfuser.ordinal(), ScreenCrystalInfuser.class);
    }

    public void spawnEffect(EntityFX effect) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(effect);
    }

    @Override
    public void handlePacket(ModPacket packet, EntityPlayer player) {
        if (packet.getPacketIsForServer()) {
            this.serverPacketHandler.handlePacket(packet, player);
        } else {
            this.clientPacketHandler.handlePacket(packet, player);
        }
    }

    private void movePlayerToServer(String address, int port) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71441_e.func_72882_A();
        mc.func_71367_a(address, port);
    }
}

