/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import pcl.lc.LanteaCraftCommonProxy;
import pcl.lc.base.network.PCLPacketPipeline;
import pcl.lc.module.ModuleCore;
import pcl.lc.util.CreativeTabHelper;
import pcl.lc.util.SpecialBucketHandler;

@Mod(modid="LanteaCraft", name="LanteaCraft", version="RC2-41", dependencies="after:ComputerCraft;after:OpenComputers;after:BuildCraft|Core;after:IC2;after:SGCraft")
public class LanteaCraft {
    private static LanteaCraft mod;
    @SidedProxy(clientSide="pcl.lc.LanteaCraftClientProxy", serverSide="pcl.lc.LanteaCraftCommonProxy")
    public static LanteaCraftCommonProxy proxy;
    private static CreativeTabHelper lanteaCraftTab;
    private static Logger logger;
    private static final PCLPacketPipeline pipeline;
    private SpecialBucketHandler bucketHandler = new SpecialBucketHandler();

    public static LanteaCraft getInstance() {
        return mod;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static PCLPacketPipeline getNetPipeline() {
        return pipeline;
    }

    public static LanteaCraftCommonProxy getProxy() {
        return proxy;
    }

    public static CreativeTabs getCreativeTab() {
        LanteaCraft.getInstance();
        return lanteaCraftTab;
    }

    public static SpecialBucketHandler getSpecialBucketHandler() {
        return LanteaCraft.getInstance().bucketHandler;
    }

    public LanteaCraft() {
        mod = this;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
        proxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        pipeline.init("LanteaCraft");
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    @SubscribeEvent
    public void onInitMapGen(InitMapGenEvent e) {
        proxy.onInitMapGen(e);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent e) {
        proxy.onServerStarting(e);
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent e) {
        proxy.onServerStopping(e);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload evt) {
        LanteaCraft.getLogger().log(Level.INFO, String.format("World unloading: %s", evt.world.field_73011_w.field_76574_g));
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load evt) {
        LanteaCraft.getLogger().log(Level.INFO, String.format("World loading: %s", evt.world.field_73011_w.field_76574_g));
    }

    static {
        lanteaCraftTab = new CreativeTabHelper(CreativeTabs.getNextID(), "LanteaCraft"){

            public Item func_78016_d() {
                return ModuleCore.Items.debugger;
            }
        };
        pipeline = new PCLPacketPipeline();
    }

    public static enum EnumGUIs {
        StargateBase,
        StargateDHDEnergy,
        NaquadahGenerator,
        CrystalInfuser;

    }
}

