/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.EnumSet;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import pcl.common.helpers.ConfigurationHelper;
import pcl.lc.LanteaCraft;
import pcl.lc.core.OreTypes;
import pcl.lc.worldgen.ChunkData;

public class NaquadahOreWorldGen
implements IWorldGenerator {
    static int genUnderLavaOdds = 4;
    static int maxNodesUnderLava = 8;
    static int genIsolatedOdds = 8;
    static int maxIsolatedNodes = 4;
    private EnumSet<OreTypes> enabledOreSpawns = EnumSet.of(OreTypes.NAQUADAH, OreTypes.TRINIUM);

    public static void configure(ConfigurationHelper cfg) {
        genUnderLavaOdds = cfg.getInteger("naquadah", "genUnderLavaOdds", genUnderLavaOdds);
        maxNodesUnderLava = cfg.getInteger("naquadah", "maxNodesUnderLava", maxNodesUnderLava);
        genIsolatedOdds = cfg.getInteger("naquadah", "genIsolatedOdds", genIsolatedOdds);
        maxIsolatedNodes = cfg.getInteger("naquadah", "maxIsolatedNodes", maxIsolatedNodes);
    }

    public void readChunk(ChunkData data, Chunk chunk) {
        for (OreTypes typeof : this.enabledOreSpawns) {
            if (data.getOreGenerated(typeof)) continue;
            this.generateChunk(typeof, chunk.field_76637_e, chunk);
        }
    }

    private Random requestRandomFor(int x, int z, World world, int oreTypeof) {
        return new Random((long)((1 + oreTypeof) * (x + z)) ^ world.func_72905_C());
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        Chunk target = world.func_72964_e(chunkX, chunkZ);
        ChunkData data = ChunkData.forChunk(target);
        for (OreTypes typeof : this.enabledOreSpawns) {
            if (data.getOreGenerated(typeof)) continue;
            this.generateChunk(typeof, world, target);
        }
    }

    public void regenerate(Chunk chunk) {
        ChunkData data = ChunkData.forChunk(chunk);
        for (OreTypes typeof : this.enabledOreSpawns) {
            if (data.getOreGenerated(typeof)) continue;
            this.generateChunk(typeof, chunk.field_76637_e, chunk);
        }
    }

    private int getBlock(Chunk chunk, int x, int y, int z) {
        return chunk.func_76610_a(x, y, z);
    }

    private void setBlock(Chunk chunk, int x, int y, int z, int id, int metadata) {
        chunk.func_76592_a(x, y, z, id, metadata);
    }

    void generateNode(Chunk chunk, World world, Random random, int id, int metadata, int cx, int cy, int cz, int density) {
        LanteaCraft.getLogger().log(Level.FINEST, String.format("Node generator building node around %s %s %s with density %s typeof %s", cx + 16 * chunk.func_76632_l().field_77276_a, cy, cz + 16 * chunk.func_76632_l().field_77275_b, density, metadata));
        int tries = 0;
        block8: while (density > 0) {
            int tx = cx;
            int ty = cy;
            int tz = cz;
            do {
                int trans = random.nextInt(6);
                switch (trans) {
                    case 0: {
                        ++tx;
                        break;
                    }
                    case 1: {
                        --tx;
                        break;
                    }
                    case 2: {
                        ++ty;
                        break;
                    }
                    case 3: {
                        --ty;
                        break;
                    }
                    case 4: {
                        ++tz;
                        break;
                    }
                    case 5: {
                        --tz;
                    }
                }
                if (tx > 15 || tz > 15 || 0 > tx || 0 > ty || 0 > tz) continue block8;
            } while (this.getBlock(chunk, tx, ty, tz) == id);
            if (this.getBlock(chunk, tx, ty, tz) != Block.field_71981_t.field_71990_ca) break;
            if (this.getBlock(chunk, tx, ty, tz) == Block.field_71981_t.field_71990_ca) {
                this.setBlock(chunk, tx, ty, tz, id, metadata);
                --density;
                tries = 0;
                continue;
            }
            if (tries++ <= 5) continue;
            break;
        }
    }

    private boolean odds(Random random, int n) {
        return random.nextInt(n) == 0;
    }

    void generateChunk(OreTypes typeof, World world, Chunk chunk) {
        Random random = this.requestRandomFor(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, world, typeof.ordinal());
        if (!this.odds(random, genIsolatedOdds)) {
            // empty if block
        }
        int n = random.nextInt(maxIsolatedNodes) + 1;
        for (int i = 0; i < n; ++i) {
            int z;
            int y;
            int x = random.nextInt(16);
            if (this.getBlock(chunk, x, y = random.nextInt(64), z = random.nextInt(16)) != Block.field_71981_t.field_71990_ca) continue;
            LanteaCraft.getLogger().log(Level.FINEST, String.format("Attempting to place Naquadah node at %s %s %s", x, y, z));
            this.generateNode(chunk, world, random, LanteaCraft.Blocks.lanteaOre.field_71990_ca, typeof.ordinal(), x, y, z, 6);
        }
        ChunkData.forChunk(chunk).markOreGenerated(OreTypes.NAQUADAH);
    }
}

