/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.tileentity;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import pcl.common.api.energy.IEnergyStore;
import pcl.common.api.energy.IItemEnergyStore;
import pcl.common.base.PoweredTileEntity;
import pcl.common.helpers.ConfigurationHelper;
import pcl.common.inventory.FilterRule;
import pcl.common.inventory.FilteredInventory;
import pcl.common.network.IPacketHandler;
import pcl.common.network.ModPacket;
import pcl.common.network.StandardModPacket;
import pcl.common.util.Trans3;
import pcl.common.util.Vector3;
import pcl.common.util.WorldLocation;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumUnits;
import pcl.lc.blocks.BlockStargateController;
import pcl.lc.tileentity.TileEntityStargateBase;

public class TileEntityStargateController
extends PoweredTileEntity
implements IPacketHandler,
IEnergyStore {
    public static int linkRangeX = 10;
    public static int linkRangeY = 10;
    public static int linkRangeZ = 10;
    public boolean isLinkedToStargate;
    public int linkedX;
    public int linkedY;
    public int linkedZ;
    private double energy = 0.0;
    private FilteredInventory inventory = new FilteredInventory(1){

        public void func_70296_d() {
        }

        public boolean func_94042_c() {
            return false;
        }

        public String func_70303_b() {
            return "stargate_energy";
        }

        public int[] func_94128_d(int var1) {
            return new int[]{0};
        }

        public boolean func_102007_a(int i, ItemStack itemstack, int j) {
            if (0 > i || i > this.items.length) {
                return false;
            }
            return this.items[i] == null || ItemStack.func_77989_b((ItemStack)this.items[i], (ItemStack)itemstack);
        }

        public boolean func_102008_b(int i, ItemStack itemstack, int j) {
            return 0 <= i && i <= this.items.length;
        }
    };

    public static void configure(ConfigurationHelper cfg) {
        linkRangeX = cfg.getInteger("dhd", "linkRangeX", linkRangeX);
        linkRangeY = cfg.getInteger("dhd", "linkRangeY", linkRangeY);
        linkRangeZ = cfg.getInteger("dhd", "linkRangeZ", linkRangeZ);
    }

    public TileEntityStargateController() {
        this.inventory.setFilterRule(0, new FilterRule(new ItemStack[]{new ItemStack((Item)LanteaCraft.Items.energyCrystal, 1), new ItemStack((Item)LanteaCraft.Items.zpm, 1)}, null, true, false));
    }

    @Override
    public String func_70303_b() {
        return "dhd";
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    public BlockStargateController getBlock() {
        return (BlockStargateController)this.func_70311_o();
    }

    public Trans3 localToGlobalTransformation() {
        return this.getBlock().localToGlobalTransformation(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70322_n(), this);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        NBTTagCompound energyCompound;
        super.func_70307_a(nbt);
        this.isLinkedToStargate = nbt.func_74767_n("isLinkedToStargate");
        this.linkedX = nbt.func_74762_e("linkedX");
        this.linkedY = nbt.func_74762_e("linkedY");
        this.linkedZ = nbt.func_74762_e("linkedZ");
        NBTTagCompound nBTTagCompound = energyCompound = nbt.func_74764_b("energyStore") ? nbt.func_74775_l("energyStore") : null;
        if (energyCompound != null) {
            this.loadEnergyStore(energyCompound);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("isLinkedToStargate", this.isLinkedToStargate);
        nbt.func_74768_a("linkedX", this.linkedX);
        nbt.func_74768_a("linkedY", this.linkedY);
        nbt.func_74768_a("linkedZ", this.linkedZ);
        NBTTagCompound energyCompound = new NBTTagCompound("energyStore");
        this.saveEnergyStore(energyCompound);
        nbt.func_74766_a("energyStore", energyCompound);
    }

    public TileEntityStargateBase getLinkedStargateTE() {
        TileEntity gte;
        if (this.isLinkedToStargate && (gte = this.field_70331_k.func_72796_p(this.linkedX, this.linkedY, this.linkedZ)) instanceof TileEntityStargateBase) {
            return (TileEntityStargateBase)gte;
        }
        return null;
    }

    public void checkForLink() {
        if (!this.isLinkedToStargate) {
            Trans3 t = this.localToGlobalTransformation();
            for (int i = -linkRangeX; i <= linkRangeX; ++i) {
                for (int j = -linkRangeY; j <= linkRangeY; ++j) {
                    for (int k = 1; k <= linkRangeZ; ++k) {
                        Vector3 p = t.p(i, j, -k);
                        TileEntity te = this.field_70331_k.func_72796_p(p.floorX(), p.floorY(), p.floorZ());
                        if (!(te instanceof TileEntityStargateBase) || !this.linkToStargate((TileEntityStargateBase)te)) continue;
                        return;
                    }
                }
            }
        }
    }

    boolean linkToStargate(TileEntityStargateBase gte) {
        if (!this.isLinkedToStargate && gte.getAsStructure().isValid()) {
            this.linkedX = gte.field_70329_l;
            this.linkedY = gte.field_70330_m;
            this.linkedZ = gte.field_70327_n;
            this.isLinkedToStargate = true;
            this.markBlockForUpdate();
            gte.markBlockForUpdate();
            return true;
        }
        return false;
    }

    public void clearLinkToStargate() {
        this.isLinkedToStargate = false;
        this.markBlockForUpdate();
    }

    @Override
    public void func_70316_g() {
        ItemStack stackOf;
        if (!this.field_70331_k.field_72995_K && this.getEnergyStored() < this.getMaxEnergyStored() && (stackOf = this.inventory.func_70301_a(0)) != null && stackOf.func_77973_b() instanceof IItemEnergyStore) {
            IItemEnergyStore store = (IItemEnergyStore)stackOf.func_77973_b();
            double receive = store.extractEnergy(stackOf, Math.min(store.getMaximumIOPayload(), this.getMaxEnergyStored() - this.getEnergyStored()), false);
            this.energy += receive;
        }
    }

    public void getStateFromPacket(ModPacket packet) {
        StandardModPacket packetOf = (StandardModPacket)packet;
        this.energy = (Double)packetOf.getValue("energy");
        this.isLinkedToStargate = (Boolean)packetOf.getValue("isLinkedToStargate");
        this.linkedX = (Integer)packetOf.getValue("linkedX");
        this.linkedY = (Integer)packetOf.getValue("linkedY");
        this.linkedZ = (Integer)packetOf.getValue("linkedZ");
    }

    public ModPacket getPacketFromState() {
        StandardModPacket packet = new StandardModPacket(new WorldLocation(this));
        packet.setIsForServer(false);
        packet.setType("LanteaPacket.TileUpdate");
        packet.setValue("energy", this.energy);
        packet.setValue("isLinkedToStargate", this.isLinkedToStargate);
        packet.setValue("linkedX", this.linkedX);
        packet.setValue("linkedY", this.linkedY);
        packet.setValue("linkedZ", this.linkedZ);
        return packet;
    }

    @Override
    public Packet func_70319_e() {
        LanteaCraft.getProxy().sendToAllPlayers(this.getPacketFromState());
        return null;
    }

    @Override
    public double receiveEnergy(double quantity, boolean isSimulated) {
        double actualPayload = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), quantity);
        if (!isSimulated) {
            this.energy += actualPayload;
            this.func_70296_d();
            this.func_70319_e();
        }
        return actualPayload;
    }

    @Override
    public double extractEnergy(double quantity, boolean isSimulated) {
        double actualPayload = Math.min(this.getEnergyStored(), quantity);
        if (!isSimulated) {
            this.energy -= actualPayload;
            this.func_70296_d();
            this.func_70319_e();
        }
        return actualPayload;
    }

    @Override
    public double getEnergyStored() {
        return this.energy;
    }

    @Override
    public double getMaxEnergyStored() {
        return 50.0;
    }

    @Override
    public void saveEnergyStore(NBTTagCompound compound) {
        compound.func_74780_a("energy", this.energy);
    }

    @Override
    public void loadEnergyStore(NBTTagCompound compound) {
        if (compound.func_74764_b("energy")) {
            this.energy = compound.func_74769_h("energy");
        }
    }

    @Override
    public void handlePacket(ModPacket packetOf) {
        this.getStateFromPacket(packetOf);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean canReceiveEnergy() {
        return true;
    }

    @Override
    public boolean canExportEnergy() {
        return false;
    }

    @Override
    public double getMaximumReceiveEnergy() {
        return 1.0;
    }

    @Override
    public double getMaximumExportEnergy() {
        return 0.0;
    }

    @Override
    public double getAvailableExportEnergy() {
        return 0.0;
    }

    @Override
    public void receiveEnergy(double units) {
    }

    @Override
    public double exportEnergy(double units) {
        return 0.0;
    }

    @Override
    public boolean canEnergyFormatConnectToSide(EnumUnits typeof, ForgeDirection direction) {
        return direction != ForgeDirection.DOWN;
    }
}

