/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import net.afterlifelochie.sandbox.ObserverContext;
import net.afterlifelochie.sandbox.WatchedValue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.network.packet.Packet41EntityEffect;
import net.minecraft.network.packet.Packet43Experience;
import net.minecraft.network.packet.Packet9Respawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.network.ForgePacket;
import net.minecraftforge.common.network.packet.DimensionRegisterPacket;
import pcl.common.audio.AudioPosition;
import pcl.common.audio.SoundHost;
import pcl.common.base.GenericTileEntity;
import pcl.common.helpers.ConfigurationHelper;
import pcl.common.inventory.FilterRule;
import pcl.common.inventory.FilteredInventory;
import pcl.common.network.IPacketHandler;
import pcl.common.network.ModPacket;
import pcl.common.network.StandardModPacket;
import pcl.common.util.ChunkLocation;
import pcl.common.util.MathUtils;
import pcl.common.util.Trans3;
import pcl.common.util.Vector3;
import pcl.common.util.WorldLocation;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumIrisState;
import pcl.lc.api.EnumStargateState;
import pcl.lc.api.IStargateAccess;
import pcl.lc.blocks.BlockStargateBase;
import pcl.lc.core.AddressingError;
import pcl.lc.core.GateAddressHelper;
import pcl.lc.core.StargateConnectionManager;
import pcl.lc.multiblock.StargateMultiblock;
import pcl.lc.render.stargate.StargateRenderConstants;

public class TileEntityStargateBase
extends GenericTileEntity
implements IStargateAccess,
IPacketHandler,
ISidedInventory {
    public static final Random random = new Random();
    public static final TransientDamageSource transientDamage = new TransientDamageSource();
    public static final IrisDamageSource irisDamage = new IrisDamageSource();
    public static int secondsToStayOpen = 300;
    public static boolean oneWayTravel = true;
    public static boolean closeFromEitherEnd = true;
    public static int ticksToStayOpen;
    private final ObserverContext observerContext = new ObserverContext();
    private StargateMultiblock multiblock = new StargateMultiblock(this);
    private FilteredInventory inventory;
    private List<TrackedEntity> trackedEntities = new ArrayList<TrackedEntity>();
    private StargateConnectionManager.ConnectionRequest connection;
    private ClientConnectionRequest connection_cli;
    private double ring_angle;
    private double ring_last_angle;
    private double ring_dest_angle;
    private SoundHost soundHost;
    private double[][][] ehGrid;

    public static void configure(ConfigurationHelper cfg) {
        secondsToStayOpen = cfg.getInteger("stargate", "secondsToStayOpen", secondsToStayOpen);
        oneWayTravel = cfg.getBoolean("stargate", "oneWayTravel", oneWayTravel);
        closeFromEitherEnd = cfg.getBoolean("stargate", "closeFromEitherEnd", closeFromEitherEnd);
        ticksToStayOpen = 20 * secondsToStayOpen;
    }

    public TileEntityStargateBase() {
        this.inventory = new FilteredInventory(1){

            public void func_70296_d() {
            }

            public boolean func_94042_c() {
                return false;
            }

            public String func_70303_b() {
                return "stargate";
            }

            public int[] func_94128_d(int var1) {
                return new int[]{0};
            }

            public boolean func_102007_a(int i, ItemStack itemstack, int j) {
                if (0 > i || i > this.items.length) {
                    return false;
                }
                return this.items[i] == null || ItemStack.func_77989_b((ItemStack)this.items[i], (ItemStack)itemstack);
            }

            public boolean func_102008_b(int i, ItemStack itemstack, int j) {
                return 0 <= i && i <= this.items.length;
            }
        };
        this.inventory.setFilterRule(0, new FilterRule(new ItemStack[]{new ItemStack((Item)LanteaCraft.Items.iris, 1)}, null, true, false));
        this.getAsStructure().invalidate();
    }

    public void serverThink() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        this.checkForEntitiesInPortal();
        if (this.connection != null && (this.connection.running.modified(this.observerContext) || this.connection.chevrons.modified(this.observerContext) || this.connection.state.modified(this.observerContext) || this.connection.symbol.modified(this.observerContext))) {
            if (BuildInfo.DEBUG) {
                LanteaCraft.getLogger().log(Level.INFO, "Update detected, sending update packet.");
            }
            StandardModPacket update = new StandardModPacket(new WorldLocation(this));
            update.setType("LanteaPacket.ConnectionUpdate");
            update.setIsForServer(false);
            if (this.connection.running.modified(this.observerContext)) {
                this.connection.running.clearModified(this.observerContext);
                update.setValue("running", this.connection.running.get());
            }
            if (this.connection.chevrons.modified(this.observerContext)) {
                this.connection.chevrons.clearModified(this.observerContext);
                update.setValue("chevrons", this.connection.chevrons.get());
            }
            if (this.connection.state.modified(this.observerContext)) {
                this.connection.state.clearModified(this.observerContext);
                update.setValue("state", (Object)this.connection.state.get());
            }
            if (this.connection.symbol.modified(this.observerContext)) {
                this.connection.symbol.clearModified(this.observerContext);
                update.setValue("symbol", this.connection.symbol.get());
            }
            LanteaCraft.getProxy().sendToAllPlayers(update);
        }
    }

    private void clientThink() {
        int j;
        int j2;
        int i;
        if (!this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.soundHost == null) {
            this.soundHost = new SoundHost(this);
        }
        if (this.connection_cli != null && this.connection_cli.state.modified(this.observerContext)) {
            this.connection_cli.state.clearModified(this.observerContext);
            if (this.connection_cli.state.get() == EnumStargateState.Dialling) {
                char symbol = this.getDialledAddress().charAt(this.connection_cli.chevrons.get());
                int symbolIndex = GateAddressHelper.singleton().index(symbol);
                double chevronIndex = this.connection_cli.chevrons.get().intValue();
                double symbolRotation = (double)symbolIndex * StargateRenderConstants.ringSymbolAngle;
                double chevronRotation = 40.0 * chevronIndex - -90.0;
                this.ring_dest_angle = MathUtils.normaliseAngle(chevronRotation - symbolRotation);
            }
            switch (this.getState()) {
                case Dialling: {
                    this.soundHost.playChannel("stargate_spin");
                    break;
                }
                case InterDialling: {
                    this.soundHost.pauseChannel("stargate_spin");
                    this.soundHost.playChannel("stargate_chevron");
                    break;
                }
                case Transient: {
                    this.soundHost.stopChannel("stargate_spin");
                    this.soundHost.playChannel("stargate_transient");
                    this.initiateOpeningTransient();
                    break;
                }
                case Disconnecting: {
                    this.soundHost.playChannel("stargate_close");
                    this.ring_dest_angle = 0.0;
                    this.initiateClosingTransient();
                    break;
                }
                case Connected: {
                    break;
                }
                case Idle: {
                    this.soundHost.shutdown(false);
                }
            }
            this.ring_last_angle = this.ring_angle;
            if (this.getState() == EnumStargateState.Dialling || this.getState() == EnumStargateState.Disconnecting && this.connection_cli.ticksRemaining > 0) {
                if (this.connection_cli.ticksRemaining > 0) {
                    double da = MathUtils.diffAngle(this.ring_angle, this.ring_dest_angle) / (double)this.connection_cli.ticksRemaining;
                    this.ring_angle = MathUtils.addAngle(this.ring_angle, da);
                    --this.connection_cli.ticksRemaining;
                } else {
                    this.ring_angle = this.ring_dest_angle;
                }
            }
        }
        this.soundHost.tick();
        double[][][] grid = this.getEventHorizonGrid();
        int m = 10;
        int n = 38;
        double[][] u = grid[0];
        double[][] v = grid[1];
        double dt = 1.0;
        double asq = 0.03;
        double d = 0.95;
        int r = random.nextInt(9) + 1;
        int t = random.nextInt(38) + 1;
        double[] dArray = v[t];
        int n2 = r;
        dArray[n2] = dArray[n2] + 0.05 * random.nextGaussian();
        for (i = 1; i < 10; ++i) {
            for (j2 = 1; j2 <= 38; ++j2) {
                double du_dr = 0.5 * (u[j2][i + 1] - u[j2][i - 1]);
                double d2u_drsq = u[j2][i + 1] - 2.0 * u[j2][i] + u[j2][i - 1];
                double d2u_dthsq = u[j2 + 1][i] - 2.0 * u[j2][i] + u[j2 - 1][i];
                v[j2][i] = d * v[j2][i] + asq * dt * (d2u_drsq + du_dr / (double)i + d2u_dthsq / (double)(i * i));
            }
        }
        for (i = 1; i < 10; ++i) {
            for (j2 = 1; j2 <= 38; ++j2) {
                double[] dArray2 = u[j2];
                int n3 = i;
                dArray2[n3] = dArray2[n3] + v[j2][i] * dt;
            }
        }
        double u0 = 0.0;
        double v0 = 0.0;
        for (j = 1; j <= 38; ++j) {
            u0 += u[j][1];
            v0 += v[j][1];
        }
        u0 /= 38.0;
        v0 /= 38.0;
        for (j = 1; j <= 38; ++j) {
            u[j][0] = u0;
            v[j][0] = v0;
        }
    }

    private boolean canTravelFromThisEnd() {
        return !oneWayTravel || this.connection.isHost(this);
    }

    private boolean canCloseFromThisEnd() {
        return closeFromEitherEnd || this.connection.isHost(this);
    }

    public int getTicks() {
        if (this.field_70331_k.field_72995_K || this.connection == null) {
            return 0;
        }
        return this.connection.ticks;
    }

    public boolean canUpdate() {
        return true;
    }

    private void checkForEntitiesInPortal() {
        if (this.getState() == EnumStargateState.Connected) {
            for (TrackedEntity trk : this.trackedEntities) {
                this.entityInPortal(trk.entity, trk.lastPos);
            }
            this.trackedEntities.clear();
            Vector3 p0 = new Vector3(-2.5, 0.5, -3.5);
            Vector3 p1 = new Vector3(2.5, 5.5, 3.5);
            Trans3 t = this.localToGlobalTransformation();
            AxisAlignedBB box = t.box(p0, p1);
            List ents = this.field_70331_k.func_72872_a(Entity.class, box);
            for (Entity entity : ents) {
                if (entity.field_70128_L || entity.field_70154_o != null) continue;
                this.trackedEntities.add(new TrackedEntity(entity));
            }
        }
    }

    @Override
    public boolean connect(String address) {
        try {
            String localAddress = address.length() == 7 ? this.getLocalAddress().substring(0, 7) : this.getLocalAddress();
            ChunkLocation hostLocation = this.getLocation();
            ChunkLocation remoteLocation = GateAddressHelper.locationForAddress(address);
            if (!remoteLocation.isStrongLocation) {
                if (hostLocation.isStrongLocation) {
                    remoteLocation.setDimension(hostLocation.dimension);
                } else {
                    return false;
                }
            }
            StargateConnectionManager manager = LanteaCraft.getProxy().getConnectionManager();
            manager.create(localAddress, address, hostLocation.toWorldLocation(), remoteLocation.toWorldLocation(), this, address);
            return true;
        }
        catch (AddressingError error) {
            return false;
        }
    }

    public void connectOrDisconnect(String address) {
        if (this.connection == null || this.connection.state.get() == EnumStargateState.Idle) {
            this.connect(address);
        } else if (this.connection.state.get() != EnumStargateState.Disconnecting && this.canCloseFromThisEnd()) {
            this.connection.requestDisconnect();
        }
    }

    private void createChannel(String name, String file, AudioPosition position, float volume, int age) {
        if (this.soundHost != null) {
            this.soundHost.addChannel(name, String.format("stargate/milkyway/milkyway_%s.ogg", file), position, volume, age);
        }
    }

    @Override
    public boolean disconnect() {
        if (this.connection.isHost(this) || closeFromEitherEnd) {
            this.connection.requestDisconnect();
            return true;
        }
        return false;
    }

    private void entityInPortal(Entity entity, Vector3 prevPos) {
        if (!entity.field_70128_L && this.getState() == EnumStargateState.Connected && this.canTravelFromThisEnd()) {
            Trans3 t = this.localToGlobalTransformation();
            double vx = entity.field_70165_t - prevPos.x;
            double vy = entity.field_70163_u - prevPos.y;
            double vz = entity.field_70161_v - prevPos.z;
            Vector3 p1 = t.ip(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            Vector3 p0 = t.ip(2.0 * prevPos.x - entity.field_70165_t, 2.0 * prevPos.y - entity.field_70163_u, 2.0 * prevPos.z - entity.field_70161_v);
            double z0 = 0.0;
            if (p0.z >= z0 && p1.z < z0) {
                entity.field_70159_w = vx;
                entity.field_70181_x = vy;
                entity.field_70179_y = vz;
                TileEntityStargateBase dte = this.getConnectedStargateTE();
                if (dte != null) {
                    Trans3 dt = dte.localToGlobalTransformation();
                    while (entity.field_70154_o != null) {
                        entity = entity.field_70154_o;
                    }
                    if (this.connection.isHost(this)) {
                        this.teleportEntityAndRider(entity, t, dt, this.connection.clientLocation.dimension);
                        dte.acceptEntity(entity);
                    } else {
                        this.teleportEntityAndRider(entity, t, dt, this.connection.hostLocation.dimension);
                        dte.acceptEntity(entity);
                    }
                }
            }
        }
    }

    private void acceptEntity(Entity entity) {
        if (this.getIrisState() == EnumIrisState.Closed || this.getIrisState() == EnumIrisState.Closing || this.getIrisState() == EnumIrisState.Opening) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                player.func_70097_a((DamageSource)irisDamage, 9999999.0f);
            } else if (entity instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)entity;
                living.func_70097_a((DamageSource)irisDamage, 9999999.0f);
            } else {
                entity.func_70106_y();
            }
        }
    }

    private void extractEntityFromWorld(World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            world.field_73010_i.remove(entity);
            world.func_72854_c();
        }
        int i = entity.field_70176_ah;
        int j = entity.field_70164_aj;
        if (entity.field_70175_ag && world.func_72863_F().func_73149_a(i, j)) {
            world.func_72964_e(i, j).func_76622_b(entity);
        }
        world.field_72996_f.remove(entity);
        world.func_72847_b(entity);
    }

    public StargateMultiblock getAsStructure() {
        return this.multiblock;
    }

    @Override
    public double getAvailableEnergy() {
        return 99999.0;
    }

    public BlockStargateBase getBlock() {
        return (BlockStargateBase)this.func_70311_o();
    }

    private TileEntityStargateBase getConnectedStargateTE() {
        if (this.connection != null) {
            if (this.connection.isHost(this)) {
                return (TileEntityStargateBase)this.connection.clientTile.get();
            }
            return (TileEntityStargateBase)this.connection.hostTile.get();
        }
        return null;
    }

    public String getDialledAddress() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.connection != null) {
                if (this.connection.isHost(this)) {
                    return this.connection.clientAddress;
                }
                return this.connection.hostAddress;
            }
            return null;
        }
        if (this.connection_cli != null) {
            if (this.connection_cli.isHost) {
                return this.connection_cli.clientAddress;
            }
            return this.connection_cli.hostAddress;
        }
        return null;
    }

    @Override
    public String getConnectionAddress() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.connection == null || !this.connection.running.get().booleanValue()) {
                return null;
            }
            if (this.connection.isHost(this)) {
                return this.connection.clientAddress;
            }
            return this.connection.hostAddress;
        }
        if (this.connection_cli == null || !this.connection_cli.running.get().booleanValue()) {
            return null;
        }
        if (this.connection_cli.isHost) {
            return this.connection_cli.clientAddress;
        }
        return this.connection_cli.hostAddress;
    }

    @Override
    public Packet func_70319_e() {
        LanteaCraft.getProxy().sendToAllPlayers(this.getAsStructure().pack());
        if (this.connection != null) {
            StandardModPacket update = new StandardModPacket(new WorldLocation(this));
            update.setType("LanteaPacket.ConnectionSet");
            update.setIsForServer(false);
            update.setValue("running", this.connection.running.get());
            update.setValue("chevrons", this.connection.chevrons.get());
            update.setValue("state", (Object)this.connection.state.get());
            update.setValue("symbol", this.connection.symbol.get());
            update.setValue("name", this.connection.name);
            update.setValue("hostName", this.connection.hostName);
            update.setValue("clientName", this.connection.clientName);
            update.setValue("hostAddress", this.connection.hostAddress);
            update.setValue("clientAddress", this.connection.clientAddress);
            update.setValue("isHost", this.connection.isHost(this));
            LanteaCraft.getProxy().sendToAllPlayers(update);
        }
        return null;
    }

    @Override
    public int getEncodedChevrons() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.connection == null || !this.connection.running.get().booleanValue()) {
                return -1;
            }
            return this.connection.chevrons.get();
        }
        if (this.connection_cli == null || !this.connection_cli.running.get().booleanValue()) {
            return -1;
        }
        return this.connection_cli.chevrons.get();
    }

    public double[][][] getEventHorizonGrid() {
        if (this.ehGrid == null) {
            int m = 10;
            int n = 38;
            this.ehGrid = new double[2][n + 2][m + 1];
            for (int i = 0; i < 2; ++i) {
                this.ehGrid[i][0] = this.ehGrid[i][n];
                this.ehGrid[i][n + 1] = this.ehGrid[i][1];
            }
        }
        return this.ehGrid;
    }

    public String getHomeAddress() throws AddressingError {
        return GateAddressHelper.addressForLocation(new WorldLocation(this));
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public String func_70303_b() {
        return "stargate";
    }

    @Override
    public EnumIrisState getIrisState() {
        return EnumIrisState.None;
    }

    @Override
    public String getLocalAddress() {
        try {
            return this.getHomeAddress();
        }
        catch (AddressingError e) {
            return "";
        }
    }

    @Override
    public ChunkLocation getLocation() {
        return new ChunkLocation(this);
    }

    @Override
    public double getRemainingConnectionTime() {
        return 99999.0;
    }

    @Override
    public double getRemainingDials() {
        return 1.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)(this.field_70329_l - 3), (double)this.field_70330_m, (double)(this.field_70327_n - 3), (double)(this.field_70329_l + 5), (double)(this.field_70330_m + 7), (double)(this.field_70327_n + 5));
    }

    public int getRotation() {
        return this.getBlock().rotationInWorld(this.func_70322_n(), this);
    }

    @Override
    public EnumStargateState getState() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.connection == null || !this.connection.running.get().booleanValue()) {
                return EnumStargateState.Idle;
            }
            return this.connection.state.get();
        }
        if (this.connection_cli == null || !this.connection_cli.running.get().booleanValue()) {
            return EnumStargateState.Idle;
        }
        return this.connection_cli.state.get();
    }

    @Override
    public void handlePacket(ModPacket packetOf) {
        if (BuildInfo.DEBUG) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Handling packet type %s.", packetOf.getType()));
        }
        if (packetOf.getType().equals("LanteaPacket.MultiblockUpdate")) {
            this.getAsStructure().unpack(packetOf);
        } else if (packetOf.getType().equals("LanteaPacket.ConnectionUpdate")) {
            StandardModPacket payload;
            if (BuildInfo.DEBUG) {
                LanteaCraft.getLogger().log(Level.INFO, "Accepted connection status update.");
            }
            if (this.connection_cli == null) {
                // empty if block
            }
            if ((payload = (StandardModPacket)packetOf).hasFieldWithValue("running")) {
                this.connection_cli.running.set((Boolean)payload.getValue("running"));
            }
            if (payload.hasFieldWithValue("chevrons")) {
                this.connection_cli.chevrons.set((Integer)payload.getValue("chevrons"));
            }
            if (payload.hasFieldWithValue("state")) {
                this.connection_cli.state.set((EnumStargateState)((Object)payload.getValue("state")));
            }
            if (payload.hasFieldWithValue("symbol")) {
                this.connection_cli.symbol.set((Character)payload.getValue("symbol"));
            }
        } else if (packetOf.getType().equals("LanteaPacket.ConnectionSet")) {
            StandardModPacket payload = (StandardModPacket)packetOf;
            ClientConnectionRequest req = new ClientConnectionRequest((String)payload.getValue("name"), (String)payload.getValue("hostName"), (String)payload.getValue("clientName"), (String)payload.getValue("hostAddress"), (String)payload.getValue("clientAddress"), (Boolean)payload.getValue("isHost"));
            req.running.set((Boolean)payload.getValue("running"));
            req.chevrons.set((Integer)payload.getValue("chevrons"));
            req.state.set((EnumStargateState)((Object)payload.getValue("state")));
            req.symbol.set((Character)payload.getValue("symbol"));
            this.setClientConnection(req);
        } else {
            LanteaCraft.getLogger().log(Level.WARNING, String.format("Strange packet type %s.", packetOf.getType()));
        }
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void hostBlockDestroyed() {
        if (this.connection != null) {
            this.connection.shutdown();
        }
        if (!this.field_70331_k.field_72995_K) {
            this.getAsStructure().disband();
        }
    }

    public void hostBlockPlaced() {
        if (!this.field_70331_k.field_72995_K) {
            this.getAsStructure().invalidate();
        }
    }

    private void initiateClosingTransient() {
        if (!this.isIrisClosed()) {
            double[][] v = this.getEventHorizonGrid()[1];
            int m = 10;
            int n = 38;
            for (int i = 1; i < m; ++i) {
                for (int j = 1; j <= n; ++j) {
                    double[] dArray = v[j];
                    int n2 = i;
                    dArray[n2] = dArray[n2] + 0.25 * random.nextGaussian();
                }
            }
        }
    }

    private void initiateOpeningTransient() {
        if (!this.isIrisClosed()) {
            double[][] v = this.getEventHorizonGrid()[1];
            int n = 38;
            for (int j = 0; j <= n + 1; ++j) {
                v[j][0] = 1.3;
                v[j][1] = v[j][0] + 0.25 * random.nextGaussian();
            }
        }
    }

    public double interpolatedRingAngle(double t) {
        return MathUtils.interpolateAngle(this.ring_last_angle, this.ring_angle, t);
    }

    @Override
    public boolean isBusy() {
        return this.isDialling() || this.isConnected();
    }

    public boolean isConnected() {
        return this.getState() == EnumStargateState.Transient || this.getState() == EnumStargateState.Connected || this.getState() == EnumStargateState.Disconnecting;
    }

    public boolean isDialling() {
        return this.getState() == EnumStargateState.InterDialling || this.getState() == EnumStargateState.Dialling;
    }

    @Override
    public boolean func_94042_c() {
        return false;
    }

    public boolean isIrisClosed() {
        return false;
    }

    @Override
    public boolean isOutgoingConnection() {
        return this.connection != null && this.connection.isHost(this);
    }

    @Override
    public boolean isValid() {
        return this.getAsStructure().isValid();
    }

    private Trans3 localToGlobalTransformation() {
        return this.getBlock().localToGlobalTransformation(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70322_n(), this);
    }

    public void performTransientDamage() {
        Vector3 p0 = new Vector3(-3.5, 0.0, 0.0);
        Vector3 p1 = new Vector3(3.5, 5.5, 2.5);
        Trans3 t = this.localToGlobalTransformation();
        AxisAlignedBB box = t.box(p0, p1);
        List ents = this.field_70331_k.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase ent : ents) {
            ent.func_70097_a((DamageSource)transientDamage, 9999999.0f);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.getAsStructure().invalidate();
    }

    private void setVelocity(Entity entity, Vector3 v) {
        entity.field_70159_w = v.x;
        entity.field_70181_x = v.y;
        entity.field_70179_y = v.z;
    }

    private Entity teleportEntity(Entity entity, Trans3 t1, Trans3 t2, int dimension) {
        Entity newEntity;
        Vector3 p = t1.ip(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        Vector3 v = t1.iv(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        Vector3 r = t1.iv(this.yawVector(entity));
        Vector3 q = t2.p(-p.x, p.y, -p.z);
        Vector3 u = t2.v(-v.x, v.y, -v.z);
        Vector3 s = t2.v(r.mul(-1.0));
        double a = this.yawAngle(s);
        if (entity.field_71093_bK == dimension) {
            newEntity = this.teleportWithinDimension(entity, q, u, a);
        } else {
            newEntity = this.teleportToOtherDimension(entity, q, u, a, dimension);
            newEntity.field_71093_bK = dimension;
        }
        return newEntity;
    }

    private Entity teleportEntityAndRider(Entity entity, Trans3 t1, Trans3 t2, int dimension) {
        Entity rider = entity.field_70153_n;
        if (rider != null) {
            rider.func_70078_a(null);
        }
        entity = this.teleportEntity(entity, t1, t2, dimension);
        if (rider != null) {
            rider = this.teleportEntityAndRider(rider, t1, t2, dimension);
            rider.func_70078_a(entity);
            entity.field_98038_p = false;
        }
        return entity;
    }

    private Entity teleportEntityToDimension(Entity entity, Vector3 p, Vector3 v, double a, int dimension) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        WorldServer world = server.func_71218_a(dimension);
        return this.teleportEntityToWorld(entity, p, v, a, world);
    }

    private Entity teleportEntityToWorld(Entity oldEntity, Vector3 p, Vector3 v, double a, WorldServer newWorld) {
        WorldServer oldWorld = (WorldServer)oldEntity.field_70170_p;
        NBTTagCompound nbt = new NBTTagCompound();
        oldEntity.func_70039_c(nbt);
        this.extractEntityFromWorld((World)oldWorld, oldEntity);
        Entity newEntity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)newWorld);
        if (newEntity != null) {
            float s;
            if (oldEntity instanceof EntityLiving && (s = ((EntityLiving)oldEntity).func_70689_ay()) != 0.0f) {
                ((EntityLiving)newEntity).func_70659_e(s);
            }
            this.setVelocity(newEntity, v);
            newEntity.func_70012_b(p.x, p.y, p.z, (float)a, oldEntity.field_70125_A);
            newEntity.field_98038_p = true;
            newWorld.func_72838_d(newEntity);
            newEntity.func_70029_a((World)newWorld);
        }
        oldWorld.func_82742_i();
        if (oldWorld != newWorld) {
            newWorld.func_82742_i();
        }
        return newEntity;
    }

    private Entity teleportPlayerWithinDimension(EntityPlayerMP entity, Vector3 p, Vector3 v, double a) {
        entity.field_70177_z = (float)a;
        entity.func_70634_a(p.x, p.y, p.z);
        entity.field_70170_p.func_72866_a((Entity)entity, false);
        return entity;
    }

    private Entity teleportToOtherDimension(Entity entity, Vector3 p, Vector3 v, double a, int dimension) {
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Vector3 q = p.add(this.yawVector(a));
            this.transferPlayerToDimension(player, dimension, q, a);
            return player;
        }
        return this.teleportEntityToDimension(entity, p, v, a, dimension);
    }

    private Entity teleportWithinDimension(Entity entity, Vector3 p, Vector3 v, double a) {
        if (entity instanceof EntityPlayerMP) {
            return this.teleportPlayerWithinDimension((EntityPlayerMP)entity, p, v, a);
        }
        return this.teleportEntityToWorld(entity, p, v, a, (WorldServer)entity.field_70170_p);
    }

    private void transferPlayerToDimension(EntityPlayerMP player, int newDimension, Vector3 p, double a) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        ServerConfigurationManager scm = server.func_71203_ab();
        int oldDimension = player.field_71093_bK;
        player.field_71093_bK = newDimension;
        WorldServer oldWorld = server.func_71218_a(oldDimension);
        WorldServer newWorld = server.func_71218_a(newDimension);
        Packet250CustomPayload spoof = ForgePacket.makePacketSet((ForgePacket)new DimensionRegisterPacket(newDimension, DimensionManager.getProviderType((int)newDimension)))[0];
        player.field_71135_a.func_72567_b((Packet)spoof);
        player.func_71053_j();
        player.field_71135_a.func_72567_b((Packet)new Packet9Respawn(player.field_71093_bK, (byte)player.field_70170_p.field_73013_u, newWorld.func_72912_H().func_76067_t(), newWorld.func_72800_K(), player.field_71134_c.func_73081_b()));
        oldWorld.func_72973_f((Entity)player);
        player.field_70128_L = false;
        player.func_70012_b(p.x, p.y, p.z, (float)a, player.field_70125_A);
        newWorld.func_72838_d((Entity)player);
        player.func_70029_a((World)newWorld);
        scm.func_72375_a(player, oldWorld);
        player.field_71135_a.func_72569_a(p.x, p.y, p.z, (float)a, player.field_70125_A);
        player.field_71134_c.func_73080_a(newWorld);
        scm.func_72354_b(player, newWorld);
        scm.func_72385_f(player);
        for (PotionEffect effect : player.func_70651_bq()) {
            player.field_71135_a.func_72567_b((Packet)new Packet41EntityEffect(player.field_70157_k, effect));
        }
        player.field_71135_a.func_72567_b((Packet)new Packet43Experience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        GameRegistry.onPlayerChangedDimension((EntityPlayer)player);
    }

    public void setConnection(StargateConnectionManager.ConnectionRequest request) {
        if (BuildInfo.DEBUG) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("Setting ConnectionRequest: %s.", request.hashCode()));
        }
        this.connection = request;
        this.func_70319_e();
    }

    public void setClientConnection(ClientConnectionRequest request) {
        this.connection_cli = request;
        this.createChannel("stargate_spin", "roll", new AudioPosition(this.field_70331_k, new Vector3(this)), 1.0f, -1);
        this.createChannel("stargate_chevron", "chevron_lock", new AudioPosition(this.field_70331_k, new Vector3(this)), 1.0f, 1200);
        this.createChannel("stargate_transient", "open", new AudioPosition(this.field_70331_k, new Vector3(this)), 1.0f, 1200);
        this.createChannel("stargate_close", "close", new AudioPosition(this.field_70331_k, new Vector3(this)), 1.0f, 1200);
    }

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            this.serverThink();
        } else {
            this.clientThink();
        }
        this.multiblock.tick();
    }

    public boolean useEnergy(int i) {
        return true;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
    }

    private double yawAngle(Vector3 v) {
        double a = Math.atan2(-v.x, v.z);
        double d = Math.toDegrees(a);
        return d;
    }

    private Vector3 yawVector(double yaw) {
        double a = Math.toRadians(yaw);
        Vector3 v = new Vector3(-Math.sin(a), 0.0, Math.cos(a));
        return v;
    }

    private Vector3 yawVector(Entity entity) {
        return this.yawVector(entity.field_70177_z);
    }

    private static class TransientDamageSource
    extends DamageSource {
        public TransientDamageSource() {
            super("wormhole_transient");
            this.func_76348_h();
        }

        public String getDeathMessage(EntityPlayer player) {
            return player.field_71092_bJ + " was torn apart by an event horizon.";
        }
    }

    private class ClientConnectionRequest {
        public WatchedValue<Boolean> running = new WatchedValue<Boolean>(false);
        public final boolean isHost;
        public WatchedValue<EnumStargateState> state = new WatchedValue<EnumStargateState>(EnumStargateState.Idle);
        public WatchedValue<Character> symbol = new WatchedValue<Character>(Character.valueOf(' '));
        public WatchedValue<Integer> chevrons = new WatchedValue<Integer>(0);
        public int ticksRemaining = 0;
        public final String name;
        public final String hostName;
        public final String clientName;
        public final String hostAddress;
        public final String clientAddress;

        public ClientConnectionRequest(String name, String hostName, String clientName, String hostAddress, String clientAddress, boolean isHost) {
            this.name = name;
            this.hostName = hostName;
            this.clientName = clientName;
            this.hostAddress = hostAddress;
            this.clientAddress = clientAddress;
            this.isHost = isHost;
        }
    }

    private class TrackedEntity {
        public Entity entity;
        public Vector3 lastPos;
        public Vector3 lastVel;

        public TrackedEntity(Entity entity) {
            this.entity = entity;
            this.lastPos = new Vector3(entity);
            this.lastVel = new Vector3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
        }
    }

    private static class IrisDamageSource
    extends DamageSource {
        public IrisDamageSource() {
            super("stargate_iris");
            this.func_76348_h();
            this.func_76359_i();
        }

        public String getDeathMessage(EntityPlayer player) {
            return player.field_71092_bJ + " was obliterated by an iris.";
        }
    }
}

