/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import pcl.common.base.GenericTileEntity;
import pcl.common.helpers.ScanningHelper;
import pcl.common.network.IPacketHandler;
import pcl.common.network.ModPacket;
import pcl.common.network.StandardModPacket;
import pcl.common.util.Vector3;
import pcl.common.util.WorldLocation;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumRingPlatformState;

public class TileEntityRingPlatform
extends GenericTileEntity
implements IPacketHandler {
    private final double ringExtended = 2.5;
    private EnumRingPlatformState state = EnumRingPlatformState.Idle;
    private int timeout;
    private Vector3 connectionTo;
    private double ringPosition;
    private double nextRingPosition;
    private ArrayList<Entity> boundingEntities = new ArrayList();

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            this.updateRendering();
        } else if (this.state != EnumRingPlatformState.Idle || this.timeout != 0) {
            if (this.timeout > 0) {
                --this.timeout;
            } else if (this.state == EnumRingPlatformState.Connecting) {
                this.updateState(EnumRingPlatformState.Transmitting, 2);
                this.buildTeleportingEntityList();
            } else if (this.state == EnumRingPlatformState.Transmitting) {
                this.updateState(EnumRingPlatformState.Connected, 8);
                this.teleportEntitiesInList();
            } else if (this.state == EnumRingPlatformState.Connected) {
                this.updateState(EnumRingPlatformState.Disconnecting, 20);
            } else if (this.state == EnumRingPlatformState.Disconnecting) {
                this.clearConnection();
                this.updateState(EnumRingPlatformState.Idle, 0);
            }
        }
    }

    private void updateRendering() {
        if (0.0 > this.ringPosition) {
            this.ringPosition = 0.0;
        }
        this.ringPosition += this.nextRingPosition;
        if (this.ringPosition > 2.5) {
            this.ringPosition = 2.5;
        }
        if (this.timeout > 0) {
            this.nextRingPosition = this.state == EnumRingPlatformState.Connecting ? 0.125 : (this.state == EnumRingPlatformState.Disconnecting ? -0.125 : 0.0);
        }
    }

    public double getRingPosition(float partialticks) {
        double next = this.ringPosition + (double)partialticks * this.nextRingPosition;
        if (next > 2.5) {
            return 2.5;
        }
        return next;
    }

    public void performConnection(Vector3 slaveObject) {
        this.connectionTo = slaveObject;
        this.updateState(EnumRingPlatformState.Connecting, 20);
    }

    public void clearConnection() {
        this.connectionTo = null;
    }

    public boolean isBusy() {
        return this.state != EnumRingPlatformState.Idle;
    }

    private void updateState(EnumRingPlatformState state, int timeout) {
        this.state = state;
        this.timeout = timeout;
        this.markBlockForUpdate();
    }

    public void getStateFromPacket(ModPacket packet) {
        StandardModPacket packetOf = (StandardModPacket)packet;
        this.timeout = (Integer)packetOf.getValue("timeout");
        this.state = (EnumRingPlatformState)((Object)packetOf.getValue("state"));
    }

    public ModPacket getPacketFromState() {
        StandardModPacket packet = new StandardModPacket(new WorldLocation(this));
        packet.setIsForServer(false);
        packet.setType("LanteaPacket.TileUpdate");
        packet.setValue("timeout", this.timeout);
        packet.setValue("state", (Object)this.state);
        return packet;
    }

    @Override
    public Packet func_70319_e() {
        LanteaCraft.getProxy().sendToAllPlayers(this.getPacketFromState());
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)(this.field_70329_l - 4), (double)this.field_70330_m, (double)(this.field_70327_n - 4), (double)(this.field_70329_l + 4), (double)(this.field_70330_m + 7), (double)(this.field_70327_n + 4));
    }

    public void connect() {
        ArrayList<Vector3> others = ScanningHelper.findAllTileEntitesOf(this.field_70331_k, TileEntityRingPlatform.class, this.field_70329_l, this.field_70330_m, this.field_70327_n, AxisAlignedBB.func_72330_a((double)-10.0, (double)(-this.field_70330_m), (double)-10.0, (double)10.0, (double)this.field_70331_k.func_72800_K(), (double)10.0));
        Vector3 vectorHere = new Vector3(this);
        for (Vector3 other : others) {
            TileEntityRingPlatform that;
            TileEntity at = this.field_70331_k.func_72796_p(this.field_70329_l + (int)Math.floor(other.x), this.field_70330_m + (int)Math.floor(other.y), this.field_70327_n + (int)Math.floor(other.z));
            if (!(at instanceof TileEntityRingPlatform) || at.equals(this) || (that = (TileEntityRingPlatform)at).isBusy()) continue;
            this.performConnection(other.add(vectorHere));
            that.performConnection(vectorHere);
            return;
        }
    }

    private TileEntityRingPlatform getSlave() {
        return (TileEntityRingPlatform)this.field_70331_k.func_72796_p((int)Math.floor(this.connectionTo.x), (int)Math.floor(this.connectionTo.y), (int)Math.floor(this.connectionTo.z));
    }

    public void buildTeleportingEntityList() {
        this.boundingEntities.clear();
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.field_70329_l - 2), (double)this.field_70330_m, (double)(this.field_70327_n - 2), (double)(this.field_70329_l + 2), (double)(this.field_70330_m + 3), (double)(this.field_70327_n + 2));
        List ents = this.field_70331_k.func_72872_a(Entity.class, bounds);
        for (Entity entity : ents) {
            if (entity.field_70128_L || entity.field_70154_o != null) continue;
            this.boundingEntities.add(entity);
        }
    }

    private void teleportEntitiesInList() {
        for (Entity entity : this.boundingEntities) {
            this.entityInPortal(entity);
        }
        this.boundingEntities.clear();
    }

    private void entityInPortal(Entity entity) {
        TileEntityRingPlatform dte = this.getSlave();
        if (dte != null) {
            while (entity.field_70154_o != null) {
                entity = entity.field_70154_o;
            }
            Vector3 host = new Vector3(this);
            Vector3 entPos = new Vector3(entity);
            Vector3 dest = new Vector3(dte);
            Vector3 output = dest.add(entPos.sub(host));
            this.teleportEntityAndRider(entity, output);
        }
    }

    Entity teleportEntityAndRider(Entity entity, Vector3 destination) {
        Entity rider = entity.field_70153_n;
        if (rider != null) {
            rider.func_70078_a(null);
        }
        entity = this.teleportWithinDimension(entity, destination);
        if (rider != null) {
            rider = this.teleportEntityAndRider(rider, destination);
            rider.func_70078_a(entity);
            entity.field_98038_p = false;
        }
        return entity;
    }

    Entity teleportWithinDimension(Entity entity, Vector3 destination) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).func_70634_a(destination.x, destination.y, destination.z);
        } else {
            entity.func_70107_b(destination.x, destination.y, destination.z);
        }
        System.out.println("done!");
        entity.field_70170_p.func_72866_a(entity, false);
        return entity;
    }

    @Override
    public void handlePacket(ModPacket packetOf) {
        this.getStateFromPacket(packetOf);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

