/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.tileentity;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import pcl.common.base.PoweredTileEntity;
import pcl.common.helpers.ReflectionHelper;
import pcl.common.inventory.FilterRule;
import pcl.common.inventory.FilteredInventory;
import pcl.common.network.IPacketHandler;
import pcl.common.network.ModPacket;
import pcl.common.network.StandardModPacket;
import pcl.common.util.WorldLocation;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumUnits;
import pcl.lc.api.INaquadahGeneratorAccess;
import pcl.lc.fluids.SpecialFluidTank;
import pcl.lc.items.ItemEnergyCrystal;

public class TileEntityNaquadahGenerator
extends PoweredTileEntity
implements IPacketHandler,
IFluidHandler,
INaquadahGeneratorAccess {
    public boolean simulate = false;
    public double energy = 0.0;
    public double maxEnergy = 10.0;
    public double displayEnergy = 0.0;
    public double displayTankVolume = 0.0;
    public SpecialFluidTank tank = new SpecialFluidTank(LanteaCraft.Fluids.fluidLiquidNaquadah, 8000, 0, true, true);
    private boolean addedToEnergyNet = false;
    private FilteredInventory inventory = new FilteredInventory(5){

        public void func_70296_d() {
        }

        public boolean func_94042_c() {
            return false;
        }

        public String func_70303_b() {
            return "naquadah_generator";
        }

        public int[] func_94128_d(int var1) {
            return new int[]{0, 1, 2, 3};
        }

        public boolean func_102007_a(int i, ItemStack itemstack, int j) {
            if (0 > i || i > this.items.length) {
                return false;
            }
            return this.items[i] == null || ItemStack.func_77989_b((ItemStack)this.items[i], (ItemStack)itemstack);
        }

        public boolean func_102008_b(int i, ItemStack itemstack, int j) {
            return 0 <= i && i <= this.items.length;
        }
    };

    public TileEntityNaquadahGenerator() {
        FilterRule naquadah = new FilterRule(new ItemStack[]{new ItemStack((Item)LanteaCraft.Items.lanteaOreItem, 1)}, null, true, true);
        FilterRule energyCrystal = new FilterRule(new ItemStack[]{new ItemStack((Item)LanteaCraft.Items.energyCrystal, 1)}, null, true, false);
        for (int i = 0; i < 4; ++i) {
            this.inventory.setFilterRule(i, naquadah);
        }
        this.inventory.setFilterRule(4, energyCrystal);
    }

    @Override
    public IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagCompound tankCompound = nbt.func_74775_l("tank");
        if (tankCompound != null) {
            this.tank.readFromNBT(tankCompound);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        NBTTagCompound tankCompound = new NBTTagCompound();
        this.tank.writeToNBT(tankCompound);
        nbt.func_74766_a("tank", tankCompound);
    }

    @Override
    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            List<String> ifaces;
            if (!this.addedToEnergyNet && (ifaces = ReflectionHelper.getInterfacesOf(this.getClass(), true)).contains("ic2.api.energy.tile.IEnergyTile")) {
                this.postIC2Update(true);
            }
            if (this.tank.hasChanged()) {
                this.stateChanged();
            }
            super.func_70316_g();
            this.refuel();
        }
    }

    private void postIC2Update(boolean actionIsLoad) {
        try {
            Class<?> clazz_ic2energytile = Class.forName("ic2.api.energy.tile.IEnergyTile", false, this.getClass().getClassLoader());
            if (actionIsLoad) {
                Class<?> clazz_loadevent = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent", false, this.getClass().getClassLoader());
                Constructor<?> c_loadevent = clazz_loadevent.getConstructor(clazz_ic2energytile);
                WorldEvent event = (WorldEvent)c_loadevent.newInstance(clazz_ic2energytile.cast(this));
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.addedToEnergyNet = true;
            } else {
                Class<?> clazz_loadevent = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent", false, this.getClass().getClassLoader());
                Constructor<?> c_unloadevent = clazz_loadevent.getConstructor(clazz_ic2energytile);
                WorldEvent event = (WorldEvent)c_unloadevent.newInstance(clazz_ic2energytile.cast(this));
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.addedToEnergyNet = false;
            }
            this.func_70296_d();
            this.stateChanged();
        }
        catch (Throwable t) {
            LanteaCraft.getLogger().log(Level.WARNING, "Could not push IC2 energy event.", t);
        }
    }

    public void stateChanged() {
        this.func_70296_d();
        this.func_70319_e();
    }

    public void getStateFromPacket(ModPacket packet) {
        StandardModPacket packetOf = (StandardModPacket)packet;
        this.simulate = (Boolean)packetOf.getValue("simulate");
        this.energy = (Double)packetOf.getValue("energy");
    }

    public ModPacket getPacketFromState() {
        StandardModPacket packet = new StandardModPacket(new WorldLocation(this));
        packet.setIsForServer(false);
        packet.setType("LanteaPacket.TileUpdate");
        packet.setValue("simulate", this.simulate);
        packet.setValue("energy", this.energy);
        return packet;
    }

    @Override
    public Packet func_70319_e() {
        LanteaCraft.getProxy().sendToAllPlayers(this.getPacketFromState());
        return null;
    }

    public void refuel() {
        ItemStack stack;
        ItemEnergyCrystal crystal;
        if (this.isEnabled() && this.maxEnergy > this.energy + 1.0) {
            for (int i = 0; i < 4; ++i) {
                ItemStack stackOf = this.inventory.func_70301_a(i);
                if (stackOf == null || stackOf.field_77994_a <= 0) continue;
                ItemStack newStack = stackOf.func_77946_l();
                --newStack.field_77994_a;
                if (newStack.field_77994_a > 0) {
                    this.inventory.func_70299_a(i, newStack);
                } else {
                    this.inventory.func_70299_a(i, null);
                }
                this.energy += 1.0;
                this.stateChanged();
                break;
            }
        }
        if (this.isEnabled() && this.maxEnergy > this.energy + 0.1 && this.tank.getFluidAmount() > 100 && this.tank.drain((int)100, (boolean)false).amount == 100) {
            this.tank.drain(100, true);
            this.energy += 0.1;
            this.stateChanged();
        }
        if (this.isEnabled() && this.inventory.func_70301_a(4) != null && (crystal = (ItemEnergyCrystal)(stack = this.inventory.func_70301_a(4)).func_77973_b()).getMaximumEnergy() > crystal.getEnergyStored(stack) && this.energy > 0.01) {
            double used = crystal.receiveEnergy(stack, 0.01, false);
            this.energy -= used;
        }
    }

    public void func_70313_j() {
        List<String> ifaces;
        if (this.addedToEnergyNet && (ifaces = ReflectionHelper.getInterfacesOf(this.getClass(), true)).contains("ic2.api.energy.tile.IEnergyTile")) {
            this.postIC2Update(false);
        }
        super.func_70313_j();
    }

    @Override
    public boolean canReceiveEnergy() {
        return false;
    }

    @Override
    public boolean canExportEnergy() {
        return true;
    }

    @Override
    public double getMaximumReceiveEnergy() {
        return 0.0;
    }

    @Override
    public double getMaximumExportEnergy() {
        return 0.1;
    }

    @Override
    public double getAvailableExportEnergy() {
        if (!this.isActive() || !this.simulate) {
            return 0.0;
        }
        return Math.min(this.energy, this.getMaximumExportEnergy());
    }

    @Override
    public void receiveEnergy(double units) {
    }

    @Override
    public double exportEnergy(double units) {
        if (!this.simulate) {
            return 0.0;
        }
        double reallyExportedUnits = Math.min(units, this.energy);
        this.energy -= reallyExportedUnits;
        return reallyExportedUnits;
    }

    public boolean isActive() {
        return this.simulate && this.energy > 0.0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.getID() == this.tank.getFluid().fluidID && this.tank.canFill();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid.getID() == this.tank.getFluid().fluidID && this.tank.canDrain();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public boolean canEnergyFormatConnectToSide(EnumUnits typeof, ForgeDirection direction) {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.simulate;
    }

    @Override
    public boolean setEnabled(boolean enable) {
        this.simulate = enable;
        if (!this.simulate) {
            // empty if block
        }
        return true;
    }

    @Override
    public double getStoredEnergy() {
        if (!this.simulate) {
            return 0.0;
        }
        return this.energy;
    }

    @Override
    public double getStoredEnergy(EnumUnits unitsOf) {
        if (!this.simulate) {
            return 0.0;
        }
        return EnumUnits.convertFromNaquadahUnit(unitsOf, this.energy);
    }

    @Override
    public double getMaximumStoredEnergy() {
        return this.maxEnergy;
    }

    public void onHostBlockBreak() {
    }

    public void setRedstoneInputSignal(int sig) {
        boolean oldState = this.simulate;
        boolean bl = this.simulate = sig > 0;
        if (oldState != this.simulate) {
            this.func_70319_e();
        }
    }

    @Override
    public void handlePacket(ModPacket packetOf) {
        this.getStateFromPacket(packetOf);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

