/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.tileentity;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import pcl.common.network.IPacketHandler;
import pcl.common.network.ModPacket;
import pcl.common.network.TinyModPacket;
import pcl.common.util.Vector3;
import pcl.common.util.WorldLocation;
import pcl.lc.LanteaCraft;

public class TileEntityLanteaDecorGlass
extends TileEntity
implements IPacketHandler {
    private static final int[][] rotation_matrix = new int[][]{{2, 5, 3, 4}, {2, 4, 3, 5}, {0, 5, 1, 4}, {0, 4, 1, 5}, {0, 3, 1, 2}, {0, 2, 1, 3}};
    private boolean[] state = new boolean[6];
    private boolean[][] edges = new boolean[6][4];
    private int[] edges_count = new int[6];
    private int[] tile_rotation = new int[6];

    public TileEntityLanteaDecorGlass getGlassAt(int x, int y, int z) {
        TileEntity tile;
        if (y >= 0 && this.field_70331_k.func_72800_K() > y && (tile = this.field_70331_k.func_72796_p(x, y, z)) instanceof TileEntityLanteaDecorGlass) {
            return (TileEntityLanteaDecorGlass)tile;
        }
        return null;
    }

    public void neighbourChanged() {
        if (!this.field_70331_k.field_72995_K) {
            int dir;
            Vector3 location = new Vector3(this);
            for (dir = 0; dir < 6; ++dir) {
                Vector3 fd = location.add(new Vector3(ForgeDirection.getOrientation((int)dir)));
                TileEntityLanteaDecorGlass that = this.getGlassAt(fd.floorX(), fd.floorY(), fd.floorZ());
                this.state[dir] = that != null;
            }
            for (dir = 0; dir < 6; ++dir) {
                int[] matrix = rotation_matrix[dir];
                this.edges_count[dir] = 0;
                for (int perp = 0; perp < 4; ++perp) {
                    int vd = matrix[perp];
                    Vector3 fd = location.add(new Vector3(ForgeDirection.getOrientation((int)vd)));
                    TileEntityLanteaDecorGlass that = this.getGlassAt(fd.floorX(), fd.floorY(), fd.floorZ());
                    boolean bl = this.edges[dir][perp] = that != null;
                    if (that != null) continue;
                    int n = dir;
                    this.edges_count[n] = this.edges_count[n] + 1;
                }
            }
            block3: for (dir = 0; dir < 6; ++dir) {
                int i;
                int renderEdges = this.edges_count[dir];
                if (renderEdges == 1) {
                    for (i = 0; i < 4; ++i) {
                        if (this.edges[dir][i]) continue;
                        this.tile_rotation[dir] = i;
                        continue block3;
                    }
                    continue;
                }
                if (renderEdges == 2) {
                    i = -1;
                    int j = -1;
                    for (int k = 0; k < 4; ++k) {
                        for (int l = 0; l < 4; ++l) {
                            if (this.edges[dir][l]) continue;
                            if (i == -1) {
                                i = l;
                                continue;
                            }
                            j = l;
                        }
                    }
                    if (i == 0 && j == 1) {
                        this.tile_rotation[dir] = 0;
                        continue;
                    }
                    if (i == 1 && j == 2) {
                        this.tile_rotation[dir] = 1;
                        continue;
                    }
                    if (i == 2 && j == 3) {
                        this.tile_rotation[dir] = 2;
                        continue;
                    }
                    if (i == 3 && j == 0) {
                        this.tile_rotation[dir] = 3;
                        continue;
                    }
                    if (i == 0 && j == 2) {
                        this.tile_rotation[dir] = 1;
                        this.edges_count[dir] = 5;
                        continue;
                    }
                    if (i == 1 && j == 3) {
                        this.tile_rotation[dir] = 0;
                        this.edges_count[dir] = 5;
                        continue;
                    }
                    LanteaCraft.getLogger().log(Level.INFO, "Don't know how to handle this!");
                    continue;
                }
                if (renderEdges == 3) {
                    for (i = 0; i < 4; ++i) {
                        if (!this.edges[dir][i]) continue;
                        this.tile_rotation[dir] = i;
                        continue block3;
                    }
                    continue;
                }
                if (renderEdges != 4) continue;
                this.tile_rotation[dir] = 0;
            }
            this.func_70319_e();
        }
    }

    public boolean renderSide(int dir) {
        if (0 > dir || dir > 6) {
            return false;
        }
        return !this.state[dir];
    }

    public int sideType(int dir) {
        if (0 > dir || dir > 6) {
            return 0;
        }
        return this.edges_count[dir];
    }

    public int sideRotation(int dir) {
        if (0 > dir || dir > 6) {
            return 0;
        }
        return this.tile_rotation[dir];
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        if (tag.func_74764_b("seamData")) {
            NBTTagCompound root = tag.func_74775_l("seamData");
            for (int i = 0; i < 6; ++i) {
                this.state[i] = root.func_74767_n(String.format("state_%s", i));
                this.edges_count[i] = root.func_74762_e(String.format("edges_count_%s", i));
                this.tile_rotation[i] = root.func_74762_e(String.format("tile_rotation_%s", i));
            }
        }
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        NBTTagCompound root = new NBTTagCompound();
        for (int i = 0; i < 6; ++i) {
            root.func_74757_a(String.format("state_%s", i), this.state[i]);
            root.func_74768_a(String.format("edges_count_%s", i), this.edges_count[i]);
            root.func_74768_a(String.format("tile_rotation_%s", i), this.tile_rotation[i]);
        }
        tag.func_74782_a("seamData", (NBTBase)root);
    }

    public void func_70316_g() {
    }

    public Packet func_70319_e() {
        try {
            TinyModPacket packet = new TinyModPacket(new WorldLocation(this));
            DataOutputStream stream = packet.getOut();
            for (int i = 0; i < 6; ++i) {
                stream.write(this.state[i] ? 1 : 0);
                stream.writeInt(this.edges_count[i]);
                stream.writeInt(this.tile_rotation[i]);
            }
            LanteaCraft.getProxy().sendToAllPlayers(packet);
            return null;
        }
        catch (IOException ioex) {
            LanteaCraft.getLogger().log(Level.WARNING, "Error creating description packet.", ioex);
            return null;
        }
    }

    @Override
    public void handlePacket(ModPacket packetOf) {
        if (this.field_70331_k.field_72995_K && packetOf instanceof TinyModPacket) {
            try {
                TinyModPacket descriptor = (TinyModPacket)packetOf;
                DataInputStream stream = descriptor.getIn();
                for (int i = 0; i < 6; ++i) {
                    this.state[i] = stream.readByte() == 1;
                    this.edges_count[i] = stream.readInt();
                    this.tile_rotation[i] = stream.readInt();
                }
            }
            catch (IOException ioex) {
                LanteaCraft.getLogger().log(Level.WARNING, "Error unpacking description packet.", ioex);
            }
        }
    }
}

