/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.render.stargate;

import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import pcl.lc.LanteaCraft;
import pcl.lc.render.stargate.IStargateRenderer;
import pcl.lc.render.stargate.StargateRenderConstants;
import pcl.lc.render.tileentity.TileEntityStargateBaseRenderer;
import pcl.lc.tileentity.TileEntityStargateBase;

public class StandardStargateRenderer
implements IStargateRenderer {
    private double u0;
    private double v0;
    private TileEntityStargateBaseRenderer caller;
    private ResourceLocation stargateTex = LanteaCraft.getResource("textures/tileentity/stargate_" + LanteaCraft.getProxy().getRenderMode() + ".png");
    private ResourceLocation chevronTex = LanteaCraft.getResource("textures/tileentity/stargate_glyphs_" + LanteaCraft.getProxy().getRenderMode() + ".png");

    @Override
    public void renderStargateAt(TileEntityStargateBaseRenderer renderer, TileEntityStargateBase te, double x, double y, double z, float t) {
        this.caller = renderer;
        GL11.glRotatef((float)(90 * te.getRotation()), (float)0.0f, (float)1.0f, (float)0.0f);
        this.caller.bind(this.stargateTex);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        this.renderRing(te);
        this.renderInnerRing(te, t);
        this.renderChevrons(te);
        if (te.isConnected()) {
            TileEntityStargateBaseRenderer.horizonRenderer.renderStargateAt(renderer, te, x, y, z, t);
        }
    }

    private void renderInnerRing(TileEntityStargateBase te, float t) {
        double radiusMidInner = 3.0921875;
        double radiusMidOuter = 3.3078125;
        double z = 0.1421875;
        GL11.glPushMatrix();
        this.caller.bind(this.chevronTex);
        GL11.glRotatef((float)((float)(85.0 + te.interpolatedRingAngle(t))), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        this.selectTile(32);
        double u = 0.0;
        double du = 0.0;
        double dv = 0.0;
        for (int i = 0; i < 38; ++i) {
            u = (double)i * 0.02631578947368421;
            du = 0.02631578947368421;
            dv = 0.66;
            this.raw_vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i], radiusMidInner * TileEntityStargateBaseRenderer.sin[i], z, u + du, dv);
            this.raw_vertex(radiusMidOuter * TileEntityStargateBaseRenderer.cos[i], radiusMidOuter * TileEntityStargateBaseRenderer.sin[i], z, u + du, 0.0);
            this.raw_vertex(radiusMidOuter * TileEntityStargateBaseRenderer.cos[i + 1], radiusMidOuter * TileEntityStargateBaseRenderer.sin[i + 1], z, u, 0.0);
            this.raw_vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i + 1], radiusMidInner * TileEntityStargateBaseRenderer.sin[i + 1], z, u, dv);
        }
        GL11.glEnd();
        GL11.glPopMatrix();
        this.caller.bind(this.stargateTex);
    }

    private void renderRing(TileEntityStargateBase te) {
        double radiusInner = 3.0;
        double radiusOuter = 3.5;
        double radiusMidInner = 3.1;
        double radiusMidOuter = 3.3;
        double ringDepth = 0.15;
        double bevelDepth = 0.0875;
        GL11.glBegin((int)7);
        for (int i = 0; i < 38; ++i) {
            this.selectTile(4);
            GL11.glNormal3d((double)(-TileEntityStargateBaseRenderer.cos[i]), (double)(-TileEntityStargateBaseRenderer.sin[i]), (double)0.0);
            this.vertex(radiusOuter * TileEntityStargateBaseRenderer.cos[i], radiusOuter * TileEntityStargateBaseRenderer.sin[i], ringDepth, 0.0, 0.0);
            this.vertex(radiusOuter * TileEntityStargateBaseRenderer.cos[i], radiusOuter * TileEntityStargateBaseRenderer.sin[i], -ringDepth, 0.0, 16.0);
            this.vertex(radiusOuter * TileEntityStargateBaseRenderer.cos[i + 1], radiusOuter * TileEntityStargateBaseRenderer.sin[i + 1], -ringDepth, 16.0, 16.0);
            this.vertex(radiusOuter * TileEntityStargateBaseRenderer.cos[i + 1], radiusOuter * TileEntityStargateBaseRenderer.sin[i + 1], ringDepth, 16.0, 0.0);
            this.selectTile(20);
            this.vertex(radiusMidOuter * TileEntityStargateBaseRenderer.cos[i], radiusMidOuter * TileEntityStargateBaseRenderer.sin[i], ringDepth, 0.0, 0.0);
            this.vertex(radiusMidOuter * TileEntityStargateBaseRenderer.cos[i + 1], radiusMidOuter * TileEntityStargateBaseRenderer.sin[i + 1], ringDepth, 16.0, 0.0);
            this.vertex(radiusMidOuter * TileEntityStargateBaseRenderer.cos[i + 1], radiusMidOuter * TileEntityStargateBaseRenderer.sin[i + 1], -ringDepth, 16.0, 16.0);
            this.vertex(radiusMidOuter * TileEntityStargateBaseRenderer.cos[i], radiusMidOuter * TileEntityStargateBaseRenderer.sin[i], -ringDepth, 0.0, 16.0);
            this.selectTile(23);
            GL11.glNormal3d((double)(-TileEntityStargateBaseRenderer.cos[i]), (double)(-TileEntityStargateBaseRenderer.sin[i]), (double)0.0);
            this.vertex(radiusInner * TileEntityStargateBaseRenderer.cos[i], radiusInner * TileEntityStargateBaseRenderer.sin[i], bevelDepth, 0.0, 0.0);
            this.vertex(radiusInner * TileEntityStargateBaseRenderer.cos[i + 1], radiusInner * TileEntityStargateBaseRenderer.sin[i + 1], bevelDepth, 16.0, 0.0);
            this.vertex(radiusInner * TileEntityStargateBaseRenderer.cos[i + 1], radiusInner * TileEntityStargateBaseRenderer.sin[i + 1], -bevelDepth, 16.0, 16.0);
            this.vertex(radiusInner * TileEntityStargateBaseRenderer.cos[i], radiusInner * TileEntityStargateBaseRenderer.sin[i], -bevelDepth, 0.0, 16.0);
            this.selectTile(20);
            this.vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i], radiusMidInner * TileEntityStargateBaseRenderer.sin[i], ringDepth, 0.0, 0.0);
            this.vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i], radiusMidInner * TileEntityStargateBaseRenderer.sin[i], -ringDepth, 0.0, 16.0);
            this.vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i + 1], radiusMidInner * TileEntityStargateBaseRenderer.sin[i + 1], -ringDepth, 16.0, 16.0);
            this.vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i + 1], radiusMidInner * TileEntityStargateBaseRenderer.sin[i + 1], ringDepth, 16.0, 0.0);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            this.selectTile(20);
            this.vertex(radiusInner * TileEntityStargateBaseRenderer.cos[i], radiusInner * TileEntityStargateBaseRenderer.sin[i], -bevelDepth, 0.0, 16.0);
            this.vertex(radiusInner * TileEntityStargateBaseRenderer.cos[i + 1], radiusInner * TileEntityStargateBaseRenderer.sin[i + 1], -bevelDepth, 16.0, 16.0);
            this.vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i + 1], radiusMidInner * TileEntityStargateBaseRenderer.sin[i + 1], -ringDepth, 16.0, 0.0);
            this.vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i], radiusMidInner * TileEntityStargateBaseRenderer.sin[i], -ringDepth, 0.0, 0.0);
            this.vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i], radiusMidInner * TileEntityStargateBaseRenderer.sin[i], -ringDepth, 0.0, 16.0);
            this.vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i + 1], radiusMidInner * TileEntityStargateBaseRenderer.sin[i + 1], -ringDepth, 16.0, 16.0);
            this.vertex(radiusOuter * TileEntityStargateBaseRenderer.cos[i + 1], radiusOuter * TileEntityStargateBaseRenderer.sin[i + 1], -ringDepth, 16.0, 0.0);
            this.vertex(radiusOuter * TileEntityStargateBaseRenderer.cos[i], radiusOuter * TileEntityStargateBaseRenderer.sin[i], -ringDepth, 0.0, 0.0);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            this.selectTile(20);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            this.vertex(radiusInner * TileEntityStargateBaseRenderer.cos[i], radiusInner * TileEntityStargateBaseRenderer.sin[i], bevelDepth, 16.0, 16.0);
            this.vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i], radiusMidInner * TileEntityStargateBaseRenderer.sin[i], ringDepth, 16.0, 0.0);
            this.vertex(radiusMidInner * TileEntityStargateBaseRenderer.cos[i + 1], radiusMidInner * TileEntityStargateBaseRenderer.sin[i + 1], ringDepth, 0.0, 0.0);
            this.vertex(radiusInner * TileEntityStargateBaseRenderer.cos[i + 1], radiusInner * TileEntityStargateBaseRenderer.sin[i + 1], bevelDepth, 0.0, 16.0);
            this.vertex(radiusMidOuter * TileEntityStargateBaseRenderer.cos[i], radiusMidOuter * TileEntityStargateBaseRenderer.sin[i], ringDepth, 16.0, 16.0);
            this.vertex(radiusOuter * TileEntityStargateBaseRenderer.cos[i], radiusOuter * TileEntityStargateBaseRenderer.sin[i], ringDepth, 16.0, 0.0);
            this.vertex(radiusOuter * TileEntityStargateBaseRenderer.cos[i + 1], radiusOuter * TileEntityStargateBaseRenderer.sin[i + 1], ringDepth, 0.0, 0.0);
            this.vertex(radiusMidOuter * TileEntityStargateBaseRenderer.cos[i + 1], radiusMidOuter * TileEntityStargateBaseRenderer.sin[i + 1], ringDepth, 0.0, 16.0);
        }
        GL11.glEnd();
    }

    private void renderChevrons(TileEntityStargateBase te) {
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        int sizeof = te.getDialledAddress() != null ? te.getDialledAddress().length() : -1;
        int[] renderQueue = sizeof == 7 ? StargateRenderConstants.standardRenderQueue : StargateRenderConstants.extendedRenderQueue;
        for (int i = 0; i < 9; ++i) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)((float)(40.0 * (double)i - -90.0)), (float)0.0f, (float)0.0f, (float)1.0f);
            this.chevron(sizeof != -1 && this.before(renderQueue, i, te.getEncodedChevrons()));
            GL11.glPopMatrix();
        }
    }

    private boolean before(int[] i, int j, int k) {
        if (k >= i.length) {
            return true;
        }
        for (int l = k; 0 <= l; --l) {
            if (i[l] != j) continue;
            return true;
        }
        return false;
    }

    private void chevron(boolean engaged) {
        double r1 = 3.3;
        double r2 = 3.5625;
        double z2 = 0.11875;
        double z1 = z2 + 0.0625;
        double w1 = 0.08333333333333333;
        double w2 = w1 * 1.25;
        double x1 = r1;
        double y1 = 0.125;
        double x2 = r2;
        double y2 = 0.25;
        if (engaged) {
            GL11.glTranslated((double)-0.0625, (double)0.0, (double)0.0);
        }
        GL11.glBegin((int)7);
        this.selectTile(5);
        this.vertex(x2, y2, z1, 0.0, 2.0);
        this.vertex(x1, y1, z1, 0.0, 16.0);
        this.vertex(x1 + w1, y1 - w1, z1, 4.0, 12.0);
        this.vertex(x2, y2 - w2, z1, 4.0, 2.0);
        this.vertex(x2, y2, z1, 0.0, 0.0);
        this.vertex(x2, y2, z2, 0.0, 4.0);
        this.vertex(x1, y1, z2, 16.0, 4.0);
        this.vertex(x1, y1, z1, 16.0, 0.0);
        this.vertex(x2, y2, z1, 16.0, 0.0);
        this.vertex(x2, y2 - w2, z1, 12.0, 0.0);
        this.vertex(x2, y2 - w2, z2, 12.0, 4.0);
        this.vertex(x2, y2, z2, 16.0, 4.0);
        this.vertex(x1 + w1, y1 - w1, z1, 4.0, 12.0);
        this.vertex(x1, y1, z1, 0.0, 16.0);
        this.vertex(x1, -y1, z1, 16.0, 16.0);
        this.vertex(x1 + w1, -y1 + w1, z1, 12.0, 12.0);
        this.vertex(x1, y1, z1, 0.0, 0.0);
        this.vertex(x1, y1, z2, 0.0, 4.0);
        this.vertex(x1, -y1, z2, 16.0, 4.0);
        this.vertex(x1, -y1, z1, 16.0, 0.0);
        this.vertex(x2, -y2 + w2, z1, 12.0, 0.0);
        this.vertex(x1 + w1, -y1 + w1, z1, 12.0, 12.0);
        this.vertex(x1, -y1, z1, 16.0, 16.0);
        this.vertex(x2, -y2, z1, 16.0, 0.0);
        this.vertex(x1, -y1, z1, 0.0, 0.0);
        this.vertex(x1, -y1, z2, 0.0, 4.0);
        this.vertex(x2, -y2, z2, 16.0, 4.0);
        this.vertex(x2, -y2, z1, 16.0, 0.0);
        this.vertex(x2, -y2, z1, 0.0, 0.0);
        this.vertex(x2, -y2, z2, 0.0, 4.0);
        this.vertex(x2, -y2 + w2, z2, 4.0, 4.0);
        this.vertex(x2, -y2 + w2, z1, 4.0, 0.0);
        this.vertex(x2, -y2, z2, 0.0, 0.0);
        this.vertex(x1, -y1, z2, 0.0, 16.0);
        this.vertex(x1, y1, z2, 16.0, 16.0);
        this.vertex(x2, y2, z2, 16.0, 0.0);
        GL11.glEnd();
        this.selectTile(22);
        if (!engaged) {
            GL11.glColor3d((double)0.5, (double)0.5, (double)0.5);
        } else {
            GL11.glDisable((int)2896);
        }
        GL11.glBegin((int)7);
        this.vertex(x2, y2 - w2, z1, 0.0, 4.0);
        this.vertex(x1 + w1, y1 - w1, z1, 4.0, 16.0);
        this.vertex(x1 + w1, 0.0, z1, 8.0, 16.0);
        this.vertex(x2, 0.0, z1, 8.0, 4.0);
        this.vertex(x2, 0.0, z1, 8.0, 4.0);
        this.vertex(x1 + w1, 0.0, z1, 8.0, 16.0);
        this.vertex(x1 + w1, -y1 + w1, z1, 12.0, 16.0);
        this.vertex(x2, -y2 + w2, z1, 16.0, 4.0);
        this.vertex(x2, y2 - w2, z2, 0.0, 0.0);
        this.vertex(x2, y2 - w2, z1, 0.0, 4.0);
        this.vertex(x2, -y2 + w2, z1, 16.0, 4.0);
        this.vertex(x2, -y2 + w2, z2, 16.0, 0.0);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glEnable((int)2896);
    }

    private void selectTile(int index) {
        this.u0 = (double)(index & 0xF) / 16.0;
        this.v0 = (double)(index >> 4) / 16.0;
    }

    private void raw_vertex(double x, double y, double z, double u, double v) {
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }

    private void vertex(double x, double y, double z, double u, double v) {
        GL11.glTexCoord2d((double)(this.u0 + u * 0.00390625), (double)(this.v0 + v * 0.00390625));
        GL11.glVertex3d((double)x, (double)y, (double)z);
    }
}

