/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.render.stargate;

import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import pcl.lc.LanteaCraft;
import pcl.lc.render.stargate.IStargateRenderer;
import pcl.lc.render.tileentity.TileEntityStargateBaseRenderer;
import pcl.lc.tileentity.TileEntityStargateBase;

public class EventHorizonRenderer
implements IStargateRenderer {
    public static final int ehGridRadialSize = 10;
    public static final int ehGridPolarSize = 38;
    public static final double ehBandWidth = 0.3;
    private static ResourceLocation eventHorizonTexture = LanteaCraft.getResource("textures/fx/eventhorizon_" + LanteaCraft.getProxy().getRenderMode() + ".png");
    private static ResourceLocation irisTexture = LanteaCraft.getResource("textures/fx/energy_iris_128.png");
    private TileEntityStargateBaseRenderer caller;

    @Override
    public void renderStargateAt(TileEntityStargateBaseRenderer renderer, TileEntityStargateBase te, double x, double y, double z, float t) {
        this.caller = renderer;
        this.renderEventHorizon(te);
    }

    private void renderEventHorizon(TileEntityStargateBase te) {
        this.caller.bind(eventHorizonTexture);
        GL11.glDisable((int)2884);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
        double[][] grid = te.getEventHorizonGrid()[0];
        for (int i = 1; i < 10; ++i) {
            GL11.glBegin((int)8);
            for (int j = 0; j <= 38; ++j) {
                this.eventHVertex(grid, i, j);
                this.eventHVertex(grid, i + 1, j);
            }
            GL11.glEnd();
        }
        GL11.glBegin((int)6);
        GL11.glTexCoord2d((double)0.5, (double)0.5);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)grid[1][0]);
        for (int j = 0; j <= 38; ++j) {
            this.eventHVertex(grid, 1, j);
        }
        GL11.glEnd();
        GL11.glEnable((int)2884);
    }

    private void eventHVertex(double[][] grid, int i, int j) {
        double r = (double)i * 0.3;
        double x = r * TileEntityStargateBaseRenderer.cos[j];
        double y = r * TileEntityStargateBaseRenderer.sin[j];
        double u = (x + 3.0) / 6.0;
        double v = (y + 3.0) / 6.0;
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex3d((double)x, (double)y, (double)grid[j + 1][i]);
    }

    private void irisIntVertex(double k, int i, int j) {
        double r = (double)i * 0.3;
        double x = r * TileEntityStargateBaseRenderer.cos[j];
        double y = r * TileEntityStargateBaseRenderer.sin[j];
        double u = (x + 3.0) / 6.0;
        double v = (y + 3.0) / 6.0;
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex3d((double)x, (double)y, (double)k);
    }
}

