/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.render.effects;

import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import pcl.common.network.StandardModPacket;
import pcl.common.util.Facing3;
import pcl.common.util.Vector3;
import pcl.lc.LanteaCraft;

public class EffectBeam
extends EntityFX {
    private final Vector3 origin;
    private final Vector3 destination;
    private final Vector3 delta;
    private final Vector3 deltaVelocity;
    private final double length;
    private Vector3 position;
    private Facing3 rotation;
    private final int duration;
    private int ticks;

    public static EntityFX fromPacket(StandardModPacket spacket) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Vector3 o = (Vector3)spacket.getValue("origin");
        Vector3 d = (Vector3)spacket.getValue("destination");
        int duration = (Integer)spacket.getValue("duration");
        if (spacket.hasField("length")) {
            double length = (Double)spacket.getValue("length");
            return new EffectBeam((World)world, o, d, length, duration);
        }
        return new EffectBeam((World)world, o, d, duration);
    }

    protected EffectBeam(World par1World, Vector3 origin, Vector3 destination, int duration) {
        super(par1World, origin.x, origin.y, origin.z);
        this.origin = origin;
        this.destination = destination;
        this.delta = this.destination.sub(origin);
        this.deltaVelocity = Vector3.zero;
        this.length = this.delta.mag();
        this.duration = duration;
        this.initialize();
    }

    protected EffectBeam(World par1World, Vector3 origin, Vector3 destination, double length, int duration) {
        super(par1World, origin.x, origin.y, origin.z);
        this.origin = origin;
        this.destination = destination;
        this.delta = this.destination.sub(origin);
        this.deltaVelocity = new Vector3(this.delta.x / (double)duration, this.delta.y / (double)duration, this.delta.z / (double)duration);
        this.length = length;
        this.duration = duration;
        this.initialize();
    }

    public void initialize() {
        LanteaCraft.getLogger().log(Level.INFO, "Spawning EffectBeam!");
        if (0 >= this.duration) {
            LanteaCraft.getLogger().log(Level.WARNING, "Spawned EffectBeam with no duration, this might end badly!");
        }
        if (0 >= this.duration && this.length != 0.0) {
            LanteaCraft.getLogger().log(Level.WARNING, "Even worse, an animation was requested but with no duration.");
        }
        this.position = this.origin;
        this.rotation = new Facing3(0.0, 0.0);
        Vector3 d0 = this.deltaVelocity.equals(Vector3.zero) ? this.delta.mul(0.5) : this.deltaVelocity.mul(0.5);
        this.position.add(d0);
        Vector3 d1 = d0.unitV();
        double dxdz = Math.sqrt(Math.pow(d1.x, 2.0) + Math.pow(d1.z, 2.0));
        this.rotation.yaw = Math.toDegrees(Math.atan2(dxdz, d1.y));
        this.rotation.pitch = Math.toDegrees(Math.atan2(d1.z, d1.x));
    }

    public void func_70071_h_() {
        if (this.duration > 0 && this.ticks > this.duration) {
            LanteaCraft.getLogger().log(Level.INFO, "EffectBeam is now dead.");
            this.func_70106_y();
            return;
        }
        if (this.deltaVelocity.mag() > 0.0) {
            this.position.add(this.deltaVelocity);
        }
        ++this.ticks;
    }

    public void func_70539_a(Tessellator tessellator, float partialTicks, float playerYawC, float playerPitchC, float playerYawS, float f4, float f5) {
        tessellator.func_78381_a();
        Vector3 renderOrigin = this.position.copy().add(this.deltaVelocity.mul(partialTicks));
        GL11.glPushMatrix();
        System.out.println(String.format("RenderAt: %s %s %s", renderOrigin.x, renderOrigin.y, renderOrigin.z));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(LanteaCraft.getResource("textures/models/transport_rings_" + LanteaCraft.getProxy().getRenderMode() + ".png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glTexCoord2d((double)1.0, (double)0.0);
        GL11.glVertex3d((double)32.0, (double)0.0, (double)0.0);
        GL11.glTexCoord2d((double)1.0, (double)1.0);
        GL11.glVertex3d((double)32.0, (double)32.0, (double)0.0);
        GL11.glTexCoord2d((double)0.0, (double)1.0);
        GL11.glVertex3d((double)0.0, (double)32.0, (double)0.0);
        GL11.glEnd();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        tessellator.func_78382_b();
    }
}

