/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.network;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import net.minecraft.network.packet.Packet250CustomPayload;
import pcl.common.network.ModPacket;
import pcl.lc.LanteaCraft;

public class PacketLogger {
    private final File file;
    private FileOutputStream outstream;
    private DataOutputStream datastream;
    private long packetcount = 0L;

    public PacketLogger(File file) {
        this.file = file;
    }

    public void open() {
        try {
            if (this.outstream != null) {
                throw new IOException("Can't reopen an existing PacketLogger.");
            }
            this.outstream = new FileOutputStream(this.file, true);
            this.datastream = new DataOutputStream(this.outstream);
        }
        catch (IOException ioex) {
            LanteaCraft.getLogger().log(Level.WARNING, "Could not create PacketLogger, an error occured.", ioex);
        }
    }

    public void close() {
        try {
            this.datastream.flush();
            this.datastream.close();
            this.outstream.flush();
            this.outstream.close();
        }
        catch (IOException ioex) {
            LanteaCraft.getLogger().log(Level.WARNING, "Could not close PacketLogger, an error occured.", ioex);
        }
    }

    public void logPacket(ModPacket packet) {
        if (this.datastream == null) {
            return;
        }
        Packet250CustomPayload payload = packet.toPacket();
        try {
            this.datastream.writeLong(this.packetcount++);
            this.datastream.writeLong(payload.field_73629_c.length);
            this.datastream.write(payload.field_73629_c);
            if (this.packetcount >= 0x7FFFFFFFFFFFFFFEL) {
                this.packetcount %= 0x7FFFFFFFFFFFFFFEL;
            }
        }
        catch (IOException ioex) {
            LanteaCraft.getLogger().log(Level.WARNING, "Could not pack ModPacket into PacketLogger stream.", ioex);
        }
    }
}

