/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.network;

import cpw.mods.fml.common.network.Player;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.tileentity.TileEntity;
import pcl.common.network.IPacketHandler;
import pcl.common.network.ModPacket;
import pcl.common.network.StandardModPacket;
import pcl.common.util.WorldLocation;
import pcl.lc.LanteaCraft;
import pcl.lc.LanteaCraftClientProxy;
import pcl.lc.network.PacketLogger;
import pcl.lc.render.effects.EffectBeam;

public class ClientPacketHandler {
    private PacketLogger logger;

    public ClientPacketHandler(PacketLogger logger) {
        this.logger = logger;
    }

    public void handlePacket(ModPacket packet, Player player) {
        int currentWorld;
        WorldLocation target;
        if (this.logger != null) {
            this.logger.logPacket(packet);
        }
        if ((target = packet.getOriginLocation()) == null) {
            LanteaCraft.getLogger().log(Level.WARNING, String.format("ModPacket type %s sent without OriginLocation, much bad!", packet.getClass()));
        }
        if ((currentWorld = Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g) == target.dimension) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (packet.getType().equals("LanteaPacket.EntityFX")) {
                StandardModPacket payload = (StandardModPacket)packet;
                String name = (String)payload.getValue("FXType");
                EntityFX effect = null;
                if (name.equals("EffectBeam")) {
                    effect = EffectBeam.fromPacket(payload);
                }
                if (effect != null) {
                    ((LanteaCraftClientProxy)LanteaCraft.getProxy()).spawnEffect(effect);
                }
            } else {
                TileEntity tile = world.func_72796_p(target.x, target.y, target.z);
                if (tile instanceof IPacketHandler) {
                    IPacketHandler handler = (IPacketHandler)tile;
                    handler.handlePacket(packet);
                } else {
                    LanteaCraft.getLogger().log(Level.WARNING, String.format("Dropping packet %s for coords %s %s %s because the destination class %s wasn't a handler.", packet.getType(), target.x, target.y, target.z, tile != null ? tile.getClass().getName() : "<nullptr>"));
                }
            }
        }
    }
}

