/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.multiblock;

import java.lang.ref.WeakReference;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import pcl.common.helpers.ScanningHelper;
import pcl.common.multiblock.GenericMultiblock;
import pcl.common.multiblock.MultiblockPart;
import pcl.common.network.ModPacket;
import pcl.common.network.StandardModPacket;
import pcl.common.util.Vector3;
import pcl.common.util.WorldLocation;
import pcl.lc.multiblock.StargateMultiblock;
import pcl.lc.tileentity.TileEntityStargateBase;

public class StargatePart
extends MultiblockPart {
    private String typeof;
    private boolean modified = false;
    private WeakReference<GenericMultiblock> currentHost;

    public StargatePart(TileEntity host) {
        super(host);
    }

    @Override
    public void tick() {
        if (!this.host.field_70331_k.field_72995_K && this.modified) {
            this.modified = !this.modified;
            this.host.func_70319_e();
        }
    }

    public void setType(String typeof) {
        this.typeof = typeof;
        this.modified = true;
    }

    @Override
    public GenericMultiblock findHostMultiblock(boolean allowScanning) {
        if (this.currentHost != null && this.currentHost.get() != null) {
            return (GenericMultiblock)this.currentHost.get();
        }
        if (!allowScanning) {
            return null;
        }
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)-7.0, (double)-7.0, (double)-7.0, (double)7.0, (double)7.0, (double)7.0);
        TileEntity entity = ScanningHelper.findNearestTileEntityOf(this.host.field_70331_k, TileEntityStargateBase.class, this.host.field_70329_l, this.host.field_70330_m, this.host.field_70327_n, bounds);
        if (entity == null) {
            return null;
        }
        TileEntityStargateBase baseObj = (TileEntityStargateBase)entity;
        StargateMultiblock stargateStruct = baseObj.getAsStructure();
        return stargateStruct;
    }

    @Override
    public boolean canMergeWith(GenericMultiblock structure) {
        if (this.isClient) {
            return true;
        }
        if (this.currentHost == null) {
            return true;
        }
        if (this.currentHost.get() == null) {
            return true;
        }
        return ((GenericMultiblock)this.currentHost.get()).equals(structure);
    }

    @Override
    public boolean mergeWith(GenericMultiblock structure) {
        this.currentHost = new WeakReference<GenericMultiblock>(structure);
        this.modified = true;
        return true;
    }

    @Override
    public boolean isMerged() {
        return this.currentHost != null && this.currentHost.get() != null;
    }

    @Override
    public void release() {
        this.currentHost = null;
        this.modified = true;
    }

    @Override
    public String getType() {
        return this.typeof;
    }

    @Override
    public Vector3 getVectorLoc() {
        return new Vector3(this.host);
    }

    public ModPacket pack() {
        StandardModPacket packet = new StandardModPacket(new WorldLocation(this.host));
        packet.setIsForServer(false);
        packet.setType("LanteaPacket.MultiblockUpdate");
        if (this.currentHost != null && this.currentHost.get() != null) {
            packet.setValue("currentHost", ((GenericMultiblock)this.currentHost.get()).getLocation());
        }
        return packet;
    }

    public void unpack(ModPacket packetOf) {
        StandardModPacket packet = (StandardModPacket)packetOf;
        if (packet.hasFieldWithValue("currentHost")) {
            Vector3 location = (Vector3)packet.getValue("currentHost");
            TileEntity target = this.host.field_70331_k.func_72796_p(location.floorX(), location.floorY(), location.floorZ());
            if (target != null && target instanceof TileEntityStargateBase) {
                TileEntityStargateBase stargateBase = (TileEntityStargateBase)target;
                this.currentHost = new WeakReference<StargateMultiblock>(stargateBase.getAsStructure());
            }
        } else {
            this.currentHost = null;
        }
        this.host.field_70331_k.func_72902_n(this.host.field_70329_l, this.host.field_70330_m, this.host.field_70327_n);
    }
}

