/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.multiblock;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import pcl.common.multiblock.EnumOrientations;
import pcl.common.multiblock.GenericMultiblock;
import pcl.common.multiblock.MultiblockPart;
import pcl.common.network.ModPacket;
import pcl.common.network.StandardModPacket;
import pcl.common.util.ImmutablePair;
import pcl.common.util.WorldLocation;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumStargateState;
import pcl.lc.core.WorldLog;
import pcl.lc.multiblock.StargatePart;
import pcl.lc.tileentity.TileEntityStargateRing;

public class StargateMultiblock
extends GenericMultiblock {
    private int rotation;
    private int watcher = 0;
    private boolean watcherLast = false;
    private boolean modified = false;
    private int[][] stargateModel = new int[][]{{1, 2, 1, 3, 1, 2, 1}, {2, 0, 0, 0, 0, 0, 2}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {2, 0, 0, 0, 0, 0, 2}, {1, 0, 0, 0, 0, 0, 1}, {1, 2, 1, 2, 1, 2, 1}};

    public StargateMultiblock(TileEntity host) {
        super(host);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isClient && this.modified) {
            this.modified = !this.modified;
            this.host.func_70319_e();
            WorldLog log = LanteaCraft.getProxy().getWorldLog();
            log.log(Level.INFO, String.format("Stargate state changed to %s at (%s %s %s, dim: %s).", this.isValid, this.xCoord, this.yCoord, this.zCoord, this.host.field_70331_k.field_73011_w.field_76574_g));
        }
        if (!this.isClient) {
            if (0 > this.watcher) {
                this.watcher += 20;
                boolean result = this.isValidStructure(this.host.field_70331_k, this.host.field_70329_l, this.host.field_70330_m, this.host.field_70327_n);
                if (result != this.watcherLast) {
                    this.watcherLast = result;
                    this.invalidate();
                }
            } else {
                --this.watcher;
            }
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getPartCount() {
        return this.structureParts.size();
    }

    private boolean isGateTileEntity(TileEntity entity) {
        return entity instanceof TileEntityStargateRing;
    }

    private EnumOrientations getOrientation(World worldAccess, int baseX, int baseY, int baseZ) {
        if (this.isGateTileEntity(worldAccess.func_72796_p(baseX, baseY, baseZ + 1)) && this.isGateTileEntity(worldAccess.func_72796_p(baseX, baseY, baseZ - 1))) {
            return EnumOrientations.NORTH_SOUTH;
        }
        if (this.isGateTileEntity(worldAccess.func_72796_p(baseX + 1, baseY, baseZ)) && this.isGateTileEntity(worldAccess.func_72796_p(baseX - 1, baseY, baseZ))) {
            return EnumOrientations.EAST_WEST;
        }
        return null;
    }

    @Override
    public boolean isValidStructure(World worldAccess, int baseX, int baseY, int baseZ) {
        EnumOrientations currentOrientation = this.getOrientation(worldAccess, baseX, baseY, baseZ);
        if (currentOrientation == EnumOrientations.EAST_WEST) {
            LanteaCraft.getLogger().log(Level.FINE, "Testing EASTWEST");
            for (int y = 0; y < 7; ++y) {
                for (int x = 0; x < 7; ++x) {
                    int blockId = worldAccess.func_72798_a(baseX + (x - 3), baseY + y, baseZ);
                    TileEntity entity = worldAccess.func_72796_p(baseX + (x - 3), baseY + y, baseZ);
                    if (this.testIsValidForExpected(worldAccess, baseX + (x - 3), baseY + y, baseZ, entity, blockId, this.stargateModel[y][x])) continue;
                    return false;
                }
            }
            return true;
        }
        if (currentOrientation == EnumOrientations.NORTH_SOUTH) {
            LanteaCraft.getLogger().log(Level.FINE, "Testing NORTHSOUTH");
            for (int y = 0; y < 7; ++y) {
                for (int z = 0; z < 7; ++z) {
                    int blockId = worldAccess.func_72798_a(baseX, baseY + y, baseZ + (z - 3));
                    TileEntity entity = worldAccess.func_72796_p(baseX, baseY + y, baseZ + (z - 3));
                    if (this.testIsValidForExpected(worldAccess, baseX, baseY + y, baseZ + (z - 3), entity, blockId, this.stargateModel[y][z])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean testIsValidForExpected(World world, int x, int y, int z, TileEntity entity, int blockId, int expectedType) {
        if (expectedType == 0) {
            if (blockId == 0 || Block.field_71973_m[blockId] == null) {
                return true;
            }
            return Block.field_71973_m[blockId].isAirBlock(world, x, y, z);
        }
        if (expectedType == 1 || expectedType == 2) {
            if (!(entity instanceof TileEntityStargateRing)) {
                return false;
            }
            TileEntityStargateRing entityAsRing = (TileEntityStargateRing)entity;
            StargatePart teAsPart = null;
            teAsPart = entityAsRing.getAsPart();
            if (expectedType == 1) {
                if (teAsPart.getType() == null || !teAsPart.getType().equals("partStargateBlock")) {
                    return false;
                }
                if (!teAsPart.canMergeWith(this)) {
                    return false;
                }
            }
            if (expectedType == 2) {
                if (teAsPart.getType() == null || !teAsPart.getType().equals("partStargateChevron")) {
                    return false;
                }
                if (!teAsPart.canMergeWith(this)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean collectStructure(World worldAccess, int baseX, int baseY, int baseZ) {
        EnumOrientations currentOrientation = this.getOrientation(worldAccess, baseX, baseY, baseZ);
        if (currentOrientation == EnumOrientations.EAST_WEST) {
            LanteaCraft.getLogger().log(Level.FINE, "Globbing EASTWEST");
            for (int x = 0; x < 7; ++x) {
                for (int y = 0; y < 7; ++y) {
                    TileEntity entity = worldAccess.func_72796_p(baseX + (x - 3), baseY + y, baseZ);
                    if (this.stargateModel[y][x] == 0 || this.stargateModel[y][x] == 3) continue;
                    TileEntityStargateRing entityAsRing = (TileEntityStargateRing)entity;
                    StargatePart teAsPart = entityAsRing.getAsPart();
                    if (!teAsPart.canMergeWith(this)) {
                        return false;
                    }
                    teAsPart.mergeWith(this);
                    this.structureParts.put(new ImmutablePair<Integer, Integer>(x, y), teAsPart);
                }
            }
            LanteaCraft.getLogger().log(Level.FINE, "Merged in orientation EAST-WEST OK");
            this.structureOrientation = EnumOrientations.EAST_WEST;
            this.modified = true;
            return true;
        }
        if (currentOrientation == EnumOrientations.NORTH_SOUTH) {
            LanteaCraft.getLogger().log(Level.FINE, "Globbing NORTHSOUTH");
            for (int z = 0; z < 7; ++z) {
                for (int y = 0; y < 7; ++y) {
                    TileEntity entity = worldAccess.func_72796_p(baseX, baseY + y, baseZ + (z - 3));
                    if (this.stargateModel[y][z] == 0 || this.stargateModel[y][z] == 3) continue;
                    TileEntityStargateRing entityAsRing = (TileEntityStargateRing)entity;
                    StargatePart teAsPart = entityAsRing.getAsPart();
                    if (!teAsPart.canMergeWith(this)) {
                        return false;
                    }
                    teAsPart.mergeWith(this);
                    this.structureParts.put(new ImmutablePair<Integer, Integer>(z, y), teAsPart);
                }
            }
            LanteaCraft.getLogger().log(Level.FINE, "Merged in orientation NORTH-SOUTH OK");
            this.structureOrientation = EnumOrientations.NORTH_SOUTH;
            this.modified = true;
            return true;
        }
        LanteaCraft.getLogger().log(Level.FINE, "Weird orientation result!");
        return false;
    }

    @Override
    public void freeStructure() {
        LanteaCraft.getLogger().log(Level.INFO, (this.isClient ? "[client]" : "[server]") + " Releasing multiblock structure.");
        for (Map.Entry part : this.structureParts.entrySet()) {
            ((MultiblockPart)part.getValue()).release();
        }
        EnumStargateState stateOf = (EnumStargateState)((Object)this.getMetadata("state"));
        if (!this.isClient && (stateOf == EnumStargateState.Connected || stateOf == EnumStargateState.Disconnecting) && LanteaCraft.getProxy().doExplosion()) {
            LanteaCraft.getLogger().log(Level.INFO, "Creating explosion: gate destroyed while connected!");
            int k = this.host.field_70331_k.func_72798_a(this.host.field_70329_l, this.host.field_70330_m, this.host.field_70327_n);
            if (k == LanteaCraft.Blocks.stargateBaseBlock.field_71990_ca) {
                LanteaCraft.Blocks.stargateBaseBlock.explode(this.host.field_70331_k, this.host.field_70329_l, this.host.field_70330_m, this.host.field_70327_n, 500.0);
            }
        }
        this.structureParts.clear();
        this.modified = true;
    }

    @Override
    public MultiblockPart getPart(Object reference) {
        return (MultiblockPart)this.structureParts.get(reference);
    }

    @Override
    public MultiblockPart[] getAllParts() {
        return this.structureParts.values().toArray(new MultiblockPart[0]);
    }

    @Override
    public void validated(boolean oldState, boolean newState) {
        if (!this.isClient) {
            this.host.func_70319_e();
        }
    }

    @Override
    public void disband() {
        LanteaCraft.getLogger().log(Level.FINE, (this.isClient ? "[client]" : "[server]") + " Disbanding structure.");
        boolean wasValid = this.isValid();
        this.freeStructure();
        this.isValid = false;
        this.validated(wasValid, this.isValid());
    }

    @Override
    public ModPacket pack() {
        StandardModPacket packet = new StandardModPacket(new WorldLocation(this.host));
        packet.setIsForServer(false);
        packet.setType("LanteaPacket.MultiblockUpdate");
        packet.setValue("metadata", this.metadata);
        packet.setValue("isValid", this.isValid());
        packet.setValue("orientation", (Object)this.getOrientation());
        HashMap gparts = new HashMap();
        for (Map.Entry part : this.structureParts.entrySet()) {
            gparts.put(part.getKey(), ((MultiblockPart)part.getValue()).getVectorLoc());
        }
        packet.setValue("parts", gparts);
        return packet;
    }

    @Override
    public void unpack(ModPacket packet) {
        StandardModPacket packetStandard = (StandardModPacket)packet;
        this.metadata = (HashMap)packetStandard.getValue("metadata");
        this.isValid = (Boolean)packetStandard.getValue("isValid");
        this.setOrientation((EnumOrientations)((Object)packetStandard.getValue("orientation")));
    }

    @Override
    public ModPacket pollForUpdate() {
        StandardModPacket packet = new StandardModPacket(new WorldLocation(this.host));
        packet.setIsForServer(true);
        packet.setType("LanteaPacket.UpdateRequest");
        return packet;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StargateMultiblock)) {
            return false;
        }
        StargateMultiblock that = (StargateMultiblock)o;
        if (that.host == null || this.host == null) {
            return false;
        }
        return that.host.field_70329_l == this.host.field_70329_l && that.host.field_70330_m == this.host.field_70330_m && that.host.field_70327_n == this.host.field_70327_n;
    }
}

