/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.integration.computercraft;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import pcl.common.util.Vector3;
import pcl.lc.module.integration.computercraft.ComputerCraftWrapperPool;

public class TileEntityComputerCraftConnector
extends TileEntity
implements IPeripheral {
    private TileEntity target;
    private ComputerCraftWrapperPool.ComputerCraftVirtualPeripheral iface;
    protected final ArrayList<WeakReference<IComputerAccess>> clients = new ArrayList();

    public void func_70316_g() {
        if (this.iface != null) {
            this.iface.update();
        } else {
            this.findTarget();
        }
    }

    private void findTarget() {
        Vector3 origin = new Vector3(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            Vector3 target = origin.add(direction);
            if (this.field_70331_k.func_72798_a(target.floorX(), target.floorY(), target.floorZ()) <= 0 || !ComputerCraftWrapperPool.canWrap(this.field_70331_k.func_72796_p(target.floorX(), target.floorY(), target.floorZ()))) continue;
            this.target = this.field_70331_k.func_72796_p(target.floorX(), target.floorY(), target.floorZ());
            this.iface = ComputerCraftWrapperPool.wrap(this.target, this);
        }
    }

    public void attach(IComputerAccess computer) {
        this.clients.add(new WeakReference<IComputerAccess>(computer));
    }

    public void detach(IComputerAccess computer) {
        ArrayList<WeakReference<IComputerAccess>> remove = new ArrayList<WeakReference<IComputerAccess>>();
        for (WeakReference<IComputerAccess> weakReference : this.clients) {
            if (weakReference == null || weakReference.get() == null || !((IComputerAccess)weakReference.get()).equals(computer)) continue;
            remove.add(weakReference);
        }
        for (WeakReference<Object> weakReference : remove) {
            this.clients.remove(weakReference);
        }
    }

    public void pushEvent(String label, Object[] varargs) {
        for (WeakReference<IComputerAccess> client : this.clients) {
            if (client == null || client.get() == null) continue;
            ((IComputerAccess)client.get()).queueEvent(label, varargs);
        }
    }

    public String getType() {
        if (this.iface == null) {
            this.findTarget();
        }
        return this.iface.getType();
    }

    public String[] getMethodNames() {
        if (this.iface == null) {
            this.findTarget();
        }
        return this.iface.getMethodNames();
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        return this.iface.callMethod(computer, context, method, arguments);
    }

    public boolean equals(IPeripheral other) {
        return this.iface.equals(other);
    }
}

