/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.integration.computercraft;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.tileentity.TileEntity;
import pcl.lc.BuildInfo;
import pcl.lc.api.EnumStargateState;
import pcl.lc.api.INaquadahGeneratorAccess;
import pcl.lc.api.IStargateAccess;
import pcl.lc.api.IStargateControllerAccess;
import pcl.lc.module.integration.computercraft.TileEntityComputerCraftConnector;

public class ComputerCraftWrapperPool {
    public static boolean canWrap(TileEntity tile) {
        return tile instanceof IStargateAccess || tile instanceof IStargateControllerAccess || tile instanceof INaquadahGeneratorAccess;
    }

    public static ComputerCraftVirtualPeripheral wrap(TileEntity tile, TileEntityComputerCraftConnector host) {
        if (tile instanceof IStargateAccess) {
            return new StargateAccessWrapper(host, (IStargateAccess)tile);
        }
        if (tile instanceof IStargateControllerAccess) {
            return new StargateControllerAccessWrapper(host, (IStargateControllerAccess)tile);
        }
        if (tile instanceof INaquadahGeneratorAccess) {
            return new NaquadahGeneratorAccessWrapper(host, (INaquadahGeneratorAccess)tile);
        }
        return null;
    }

    public static class NaquadahGeneratorAccessWrapper
    extends ComputerCraftVirtualPeripheral {
        private final INaquadahGeneratorAccess access;

        public NaquadahGeneratorAccessWrapper(TileEntityComputerCraftConnector host, INaquadahGeneratorAccess access) {
            super(host);
            this.access = access;
        }

        @Override
        public void update() {
        }

        @Override
        public String getType() {
            return "naquadah_generator";
        }

        @Override
        public String[] getMethodNames() {
            return new String[]{"isEnabled", "setEnabled", "getStoredEnergy", "getMaximumStoredEnergy"};
        }

        @Override
        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
            switch (method) {
                case 0: {
                    return new Object[]{this.access.isEnabled()};
                }
                case 1: {
                    if (!(arguments[0] instanceof Boolean)) {
                        throw new Exception("boolean expected");
                    }
                    boolean state = (Boolean)arguments[0];
                    if (state != this.access.setEnabled(state)) {
                        throw new Exception("Cannot set Naquadah Generator state");
                    }
                    return new Object[]{this.access.isEnabled()};
                }
                case 2: {
                    return new Object[]{this.access.getStoredEnergy()};
                }
                case 3: {
                    return new Object[]{this.access.getMaximumStoredEnergy()};
                }
            }
            throw new Exception(String.format("Warning, unhandled method id %s!", method));
        }

        @Override
        public boolean equals(IPeripheral other) {
            return false;
        }
    }

    public static class StargateControllerAccessWrapper
    extends ComputerCraftVirtualPeripheral {
        private final IStargateControllerAccess access;

        public StargateControllerAccessWrapper(TileEntityComputerCraftConnector host, IStargateControllerAccess access) {
            super(host);
            this.access = access;
        }

        @Override
        public void update() {
        }

        @Override
        public String getType() {
            return "stargate_controller";
        }

        @Override
        public String[] getMethodNames() {
            return new String[]{"isValid", "isBusy", "ownsCurrentConnection", "getDialledAddress", "disconnect"};
        }

        @Override
        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
            switch (method) {
                case 0: {
                    return new Object[]{this.access.isValid()};
                }
                case 1: {
                    return new Object[]{this.access.isBusy()};
                }
                case 2: {
                    return new Object[]{this.access.ownsCurrentConnection()};
                }
                case 3: {
                    return new Object[]{this.access.getDialledAddress()};
                }
                case 4: {
                    if (!this.access.disconnect()) {
                        throw new Exception("Stargate cannot be closed by this controller");
                    }
                    return new Object[]{true};
                }
            }
            throw new Exception(String.format("Warning, unhandled method id %s!", method));
        }

        @Override
        public boolean equals(IPeripheral other) {
            return false;
        }
    }

    public static class StargateAccessWrapper
    extends ComputerCraftVirtualPeripheral {
        private final IStargateAccess access;
        private EnumStargateState stateWatcher;

        public StargateAccessWrapper(TileEntityComputerCraftConnector host, IStargateAccess access) {
            super(host);
            this.access = access;
        }

        @Override
        public String getType() {
            return "stargate";
        }

        @Override
        public String[] getMethodNames() {
            return new String[]{"dial", "connect", "disconnect", "isConnected", "getAddress", "isDialing", "isComplete", "hasFuel", "getInterfaceVersion"};
        }

        @Override
        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
            switch (method) {
                case 0: 
                case 1: {
                    String address = arguments[0].toString().toUpperCase();
                    if (address.length() != 7 && address.length() != 9) {
                        throw new Exception("Stargate addresses must be 7 or 9 characters.");
                    }
                    if (address == this.access.getLocalAddress() || address == this.access.getLocalAddress().substring(0, 7)) {
                        throw new Exception("Stargate cannot connect to itself.");
                    }
                    if (!this.access.connect(address)) {
                        throw new Exception("Stargate cannot dial now.");
                    }
                    return new Object[]{true};
                }
                case 2: {
                    if (!this.access.disconnect()) {
                        throw new Exception("Stargate cannot be closed from this end");
                    }
                    return new Object[]{true};
                }
                case 3: {
                    return new Object[]{this.access.isBusy()};
                }
                case 4: {
                    return new Object[]{this.access.getLocalAddress()};
                }
                case 5: {
                    return new Object[]{this.access.getState() == EnumStargateState.Dialling || this.access.getState() == EnumStargateState.Dialling || this.access.getState() == EnumStargateState.InterDialling};
                }
                case 6: {
                    return new Object[]{this.access.isValid()};
                }
                case 7: {
                    return new Object[]{this.access.getRemainingConnectionTime() > 0.0 && this.access.getRemainingDials() > 0.0};
                }
                case 8: {
                    return new Object[]{"RC1." + BuildInfo.getBuildNumber()};
                }
            }
            throw new Exception(String.format("Warning, unhandled method id %s!", method));
        }

        @Override
        public void update() {
            if (this.access.getState() != this.stateWatcher) {
                this.stateWatcher = this.access.getState();
                switch (this.stateWatcher) {
                    case Idle: {
                        this.pushEvent("sgIdle", new Object[]{true});
                        break;
                    }
                    case Dialling: {
                        if (this.access.isOutgoingConnection()) {
                            this.pushEvent("sgOutgoing", new Object[]{this.access.getConnectionAddress()});
                            break;
                        }
                        this.pushEvent("sgIncoming", new Object[]{Character.toString(this.access.getConnectionAddress().charAt(this.access.getEncodedChevrons()))});
                        break;
                    }
                    case InterDialling: {
                        this.pushEvent("sgChevronEncode", new Object[]{this.access.getEncodedChevrons()});
                        break;
                    }
                    case Transient: {
                        EnumStargateState enumStargateState = this.access.getState();
                        this.access.getState();
                        if (enumStargateState == EnumStargateState.Connected) break;
                        this.pushEvent("sgChevronEncode", new Object[]{this.access.getEncodedChevrons()});
                        this.pushEvent("sgWormholeOpening", new Object[]{true});
                        break;
                    }
                    case Disconnecting: {
                        this.pushEvent("sgWormholeClosing", new Object[]{true});
                    }
                }
            }
        }

        @Override
        public boolean equals(IPeripheral other) {
            return false;
        }
    }

    public static abstract class ComputerCraftVirtualPeripheral {
        private final TileEntityComputerCraftConnector host;

        public ComputerCraftVirtualPeripheral(TileEntityComputerCraftConnector host) {
            this.host = host;
        }

        public void pushEvent(String label, Object[] varargs) {
            this.host.pushEvent(label, varargs);
        }

        public abstract String getType();

        public abstract String[] getMethodNames();

        public abstract Object[] callMethod(IComputerAccess var1, ILuaContext var2, int var3, Object[] var4) throws Exception;

        public abstract boolean equals(IPeripheral var1);

        public abstract void update();
    }
}

