/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.integration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.Block;
import li.cil.oc.api.driver.MethodWhitelist;
import li.cil.oc.api.network.Arguments;
import li.cil.oc.api.network.Callback;
import li.cil.oc.api.network.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumStargateState;
import pcl.lc.api.INaquadahGeneratorAccess;
import pcl.lc.api.IStargateAccess;
import pcl.lc.api.IStargateControllerAccess;

public class OpenComputersWrapperPool {

    public static class NaquadahGeneratorAccessWrapper
    extends OpenComputersHostStub {
        private final INaquadahGeneratorAccess access;

        public NaquadahGeneratorAccessWrapper(INaquadahGeneratorAccess access) {
            this.access = access;
        }

        public void update() {
        }

        @Override
        public String getComponentName() {
            return "naquadah_generator";
        }

        @Callback
        public Object[] greet(Context context, Arguments args) {
            return new Object[]{String.format("Hello, %s!", args.checkString(0))};
        }

        @Callback
        public Object[] isEnabled(Context context, Arguments args) {
            return new Object[]{this.access.isEnabled()};
        }

        @Callback
        public Object[] setEnabled(Context context, Arguments args) throws Exception {
            if (!args.checkBoolean(0)) {
                throw new Exception("boolean expected");
            }
            boolean state = args.checkBoolean(0);
            if (state != this.access.setEnabled(state)) {
                throw new Exception("Cannot set Naquadah Generator state");
            }
            return new Object[]{this.access.isEnabled()};
        }

        @Callback
        public Object[] getStoredEnergy(Context context, Arguments args) {
            return new Object[]{this.access.getStoredEnergy()};
        }

        @Callback
        public Object[] getMaximumStoredEnergy(Context context, Arguments args) {
            return new Object[]{this.access.getMaximumStoredEnergy()};
        }

        public String[] whitelistedMethods() {
            return this.getMethods(this.getClass());
        }
    }

    public static class StargateControllerAccessWrapper
    extends OpenComputersHostStub {
        private final IStargateControllerAccess access;

        public StargateControllerAccessWrapper(IStargateControllerAccess access) {
            this.access = access;
        }

        public void update() {
        }

        @Override
        public String getComponentName() {
            return "stargate_controller";
        }

        @Callback
        public Object[] greet(Context context, Arguments args) {
            return new Object[]{String.format("Hello, %s!", args.checkString(0))};
        }

        @Callback
        public Object[] isValid(Context context, Arguments args) {
            return new Object[]{this.access.isValid()};
        }

        @Callback
        public Object[] isBusy(Context context, Arguments args) {
            return new Object[]{this.access.isBusy()};
        }

        @Callback
        public Object[] ownsCurrentConnection(Context context, Arguments args) {
            return new Object[]{this.access.ownsCurrentConnection()};
        }

        @Callback
        public Object[] getDialledAddress(Context context, Arguments args) {
            return new Object[]{this.access.getDialledAddress()};
        }

        @Callback
        public Object[] disconnect(Context context, Arguments args) throws Exception {
            if (!this.access.isBusy()) {
                throw new Exception("Stargate is not connected");
            }
            if (!this.access.disconnect()) {
                throw new Exception("Stargate cannot be disconnected");
            }
            return new Object[]{true};
        }

        public String[] whitelistedMethods() {
            return this.getMethods(this.getClass());
        }
    }

    public static class StargateAccessWrapper
    extends OpenComputersHostStub {
        private final IStargateAccess access;
        private EnumStargateState stateWatcher;

        public StargateAccessWrapper(IStargateAccess access) {
            this.access = access;
        }

        @Override
        public String getComponentName() {
            return "stargate";
        }

        public void update() {
            if (this.access.getState() != this.stateWatcher) {
                this.stateWatcher = this.access.getState();
                switch (this.stateWatcher) {
                    case Idle: {
                        this.node.sendToReachable("computer.signal", new Object[]{"sgIdle", true});
                        break;
                    }
                    case Dialling: {
                        if (this.access.isOutgoingConnection()) {
                            this.node.sendToReachable("computer.signal", new Object[]{"sgOutgoing", this.access.getConnectionAddress()});
                            break;
                        }
                        this.node.sendToReachable("computer.signal", new Object[]{"sgIncoming", Character.toString(this.access.getConnectionAddress().charAt(this.access.getEncodedChevrons()))});
                        break;
                    }
                    case InterDialling: {
                        this.node.sendToReachable("computer.signal", new Object[]{"sgChevronEncode", this.access.getEncodedChevrons()});
                        break;
                    }
                    case Transient: {
                        EnumStargateState enumStargateState = this.access.getState();
                        this.access.getState();
                        if (enumStargateState == EnumStargateState.Connected) break;
                        this.node.sendToReachable("computer.signal", new Object[]{"sgChevronEncode", this.access.getEncodedChevrons()});
                        this.node.sendToReachable("computer.signal", new Object[]{"sgWormholeOpening", true});
                        break;
                    }
                    case Disconnecting: {
                        this.node.sendToReachable("computer.signal", new Object[]{"sgWormholeClosing", true});
                        break;
                    }
                    case Connected: {
                        this.node.sendToReachable("computer.signal", new Object[]{"sgWormholeStable", true});
                        break;
                    }
                }
            }
        }

        @Callback
        public Object[] greet(Context context, Arguments args) {
            return new Object[]{String.format("Hello, %s!", args.checkString(0))};
        }

        @Callback
        public Object[] getInterfaceVersion(Context context, Arguments args) throws Exception {
            return new Object[]{"RC1." + BuildInfo.getBuildNumber()};
        }

        @Callback
        public Object[] dial(Context context, Arguments args) throws Exception {
            return this.dialTheGate(args.checkString(0).toUpperCase());
        }

        @Callback
        public Object[] connect(Context context, Arguments args) throws Exception {
            return this.dialTheGate(args.checkString(0).toUpperCase());
        }

        public Object[] dialTheGate(String address) throws Exception {
            if (address.length() != 7 && address.length() != 9) {
                throw new Exception("Stargate addresses must be 7 or 9 characters.");
            }
            if (address.equals(this.access.getLocalAddress()) || address.equals(this.access.getLocalAddress().substring(0, 7))) {
                throw new Exception("Stargate cannot connect to itself.");
            }
            if (!this.access.connect(address)) {
                throw new Exception("Stargate cannot dial now.");
            }
            return new Object[]{true};
        }

        @Callback
        public Object[] disconnect(Context context, Arguments args) throws Exception {
            if (!this.access.isBusy()) {
                throw new Exception("Stargate is not connected");
            }
            if (!this.access.disconnect()) {
                throw new Exception("Stargate cannot be disconnected");
            }
            return new Object[]{true};
        }

        @Callback
        public Object[] isConnected(Context context, Arguments args) {
            return new Object[]{this.access.isBusy()};
        }

        @Callback
        public Object[] getAddress(Context context, Arguments args) {
            return new Object[]{this.access.getLocalAddress()};
        }

        @Callback
        public Object[] isDialing(Context context, Arguments args) {
            return new Object[]{this.access.getState() == EnumStargateState.Dialling || this.access.getState() == EnumStargateState.Dialling || this.access.getState() == EnumStargateState.InterDialling};
        }

        @Callback
        public Object[] isComplete(Context context, Arguments args) {
            return new Object[]{this.access.isValid()};
        }

        @Callback
        public Object[] hasFuel(Context context, Arguments args) {
            return new Object[]{this.access.getRemainingConnectionTime() > 0.0 && this.access.getRemainingDials() > 0.0};
        }

        public String[] whitelistedMethods() {
            return this.getMethods(this.getClass());
        }
    }

    private static abstract class OpenComputersHostStub
    implements IHookManagedEnvironment,
    MethodWhitelist {
        private String[] methodList = null;
        protected Node node = Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).create();

        private OpenComputersHostStub() {
        }

        public Node node() {
            return this.node;
        }

        public void load(NBTTagCompound nbt) {
            if (this.node != null) {
                this.node.load(nbt.func_74775_l("node"));
            }
        }

        public void save(NBTTagCompound nbt) {
            if (this.node != null) {
                NBTTagCompound nodeTag = new NBTTagCompound();
                this.node.save(nodeTag);
                nbt.func_74766_a("node", nodeTag);
            }
        }

        public boolean canUpdate() {
            return true;
        }

        public void onConnect(Node node) {
        }

        public void onDisconnect(Node node) {
        }

        public void onMessage(Message message) {
        }

        protected String[] getMethods(Class<? extends OpenComputersHostStub> clazz) {
            if (this.methodList != null) {
                return this.methodList;
            }
            ArrayList<String> methodView = new ArrayList<String>();
            for (Method method : clazz.getMethods()) {
                Annotation[] annotations = method.getAnnotations();
                if (annotations == null || annotations.length <= 0) continue;
                for (Annotation annotation : annotations) {
                    if (!annotation.annotationType().equals(Callback.class)) continue;
                    methodView.add(method.getName());
                }
            }
            this.methodList = methodView.toArray(new String[0]);
            return this.methodList;
        }
    }

    private static interface IHookManagedEnvironment
    extends ManagedEnvironment {
        public String getComponentName();
    }

    public static class OpenComputersDriver
    implements Block {
        public boolean worksWith(World world, int x, int y, int z) {
            int id = world.func_72798_a(x, y, z);
            return id == LanteaCraft.Blocks.stargateBaseBlock.field_71990_ca || id == LanteaCraft.Blocks.naquadahGenerator.field_71990_ca || id == LanteaCraft.Blocks.stargateControllerBlock.field_71990_ca;
        }

        public ManagedEnvironment createEnvironment(World world, int x, int y, int z) {
            int id = world.func_72798_a(x, y, z);
            try {
                if (id == LanteaCraft.Blocks.stargateBaseBlock.field_71990_ca) {
                    IStargateAccess base = (IStargateAccess)world.func_72796_p(x, y, z);
                    return new StargateAccessWrapper(base);
                }
                if (id == LanteaCraft.Blocks.naquadahGenerator.field_71990_ca) {
                    INaquadahGeneratorAccess generator = (INaquadahGeneratorAccess)world.func_72796_p(x, y, z);
                    return new NaquadahGeneratorAccessWrapper(generator);
                }
                if (id == LanteaCraft.Blocks.stargateControllerBlock.field_71990_ca) {
                    IStargateControllerAccess dhd = (IStargateControllerAccess)world.func_72796_p(x, y, z);
                    return new StargateControllerAccessWrapper(dhd);
                }
                throw new RuntimeException("Driver.Block handler specified invalid typeof!");
            }
            catch (Throwable t) {
                LanteaCraft.getLogger().log(Level.WARNING, "Failed when handling OpenComputers createEnvironment request.", t);
                return null;
            }
        }
    }
}

