/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module.compat;

import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import pcl.lc.LanteaCraft;
import pcl.lc.core.OreTypes;

public class UpgradeHelper {
    private static ArrayList<UpgradeMapping> upgrades = new ArrayList();

    public static boolean detectSGCraftInstall() {
        try {
            Class<?> clazz_a = Class.forName("gcewing.sg.SGCraft");
            Class<?> clazz_b = Class.forName("gcewing.sg.Utils");
            return clazz_a != null && clazz_b != null;
        }
        catch (ClassNotFoundException notfound) {
            return false;
        }
    }

    public static boolean detectSGCraftReloadedInstall() {
        try {
            Class<?> clazz = Class.forName("gcewing.sg.GCESGCompatHelper");
            return clazz != null;
        }
        catch (ClassNotFoundException notfound) {
            return false;
        }
    }

    public void hookSGCraft() {
        try {
            Class<?> clazz = Class.forName("gcewing.sg.SGCraft");
            for (UpgradeMapping mapping : upgrades) {
                Field f1;
                if (!mapping.isItemSource()) {
                    try {
                        f1 = clazz.getField(mapping.getSourceName());
                        if (f1 == null || (Block)f1.get(null) == null) continue;
                        this.createBlockConversionRecipe(mapping, (Block)f1.get(null));
                    }
                    catch (ClassCastException cast) {
                        LanteaCraft.getLogger().log(Level.WARNING, String.format("Failed to cast block field %s  to Block typeof, ignoring!", mapping.getSourceName()));
                    }
                    catch (NoSuchFieldException field) {
                        LanteaCraft.getLogger().log(Level.WARNING, String.format("Failed to find block field %s, ignoring!", mapping.getSourceName()));
                    }
                    catch (IllegalAccessException illegal) {
                        LanteaCraft.getLogger().log(Level.WARNING, String.format("Could not access block field %s, ignoring!", mapping.getSourceName()));
                    }
                    continue;
                }
                try {
                    f1 = clazz.getField(mapping.getSourceName());
                    if (f1 == null || (Item)f1.get(null) == null) continue;
                    this.createItemConversionRecipe(mapping, (Item)f1.get(null));
                }
                catch (ClassCastException cast) {
                    LanteaCraft.getLogger().log(Level.WARNING, String.format("Failed to cast item field %s to Item typeof, ignoring!", mapping.getSourceName()));
                }
                catch (NoSuchFieldException field) {
                    LanteaCraft.getLogger().log(Level.WARNING, String.format("Failed to find item field %s, ignoring!", mapping.getSourceName()));
                }
                catch (IllegalAccessException illegal) {
                    LanteaCraft.getLogger().log(Level.WARNING, String.format("Could not access item field %s, ignoring!", mapping.getSourceName()));
                }
            }
        }
        catch (ClassNotFoundException notfound) {
            LanteaCraft.getLogger().log(Level.WARNING, "Could not locate a class required for upgrade!", notfound);
        }
    }

    public void hookSGCraftReloaded() {
        try {
            Class<?> clazz_blocks = Class.forName("gcewing.sg.SGCraft$Blocks");
            Class<?> clazz_items = Class.forName("gcewing.sg.SGCraft$Items");
            for (UpgradeMapping mapping : upgrades) {
                Field f1;
                if (!mapping.isItemSource()) {
                    try {
                        f1 = clazz_blocks.getField(mapping.getSourceName());
                        if (f1 == null || (Block)f1.get(null) == null) continue;
                        this.createBlockConversionRecipe(mapping, (Block)f1.get(null));
                    }
                    catch (ClassCastException cast) {
                        LanteaCraft.getLogger().log(Level.WARNING, String.format("Failed to cast block field %s  to Block typeof, ignoring!", mapping.getSourceName()));
                    }
                    catch (NoSuchFieldException field) {
                        LanteaCraft.getLogger().log(Level.WARNING, String.format("Failed to find block field %s, ignoring!", mapping.getSourceName()));
                    }
                    catch (IllegalAccessException illegal) {
                        LanteaCraft.getLogger().log(Level.WARNING, String.format("Could not access block field %s, ignoring!", mapping.getSourceName()));
                    }
                    continue;
                }
                try {
                    f1 = clazz_items.getField(mapping.getSourceName());
                    if (f1 == null || (Item)f1.get(null) == null) continue;
                    this.createItemConversionRecipe(mapping, (Item)f1.get(null));
                }
                catch (ClassCastException cast) {
                    LanteaCraft.getLogger().log(Level.WARNING, String.format("Failed to cast item field %s to Item typeof, ignoring!", mapping.getSourceName()));
                }
                catch (NoSuchFieldException field) {
                    LanteaCraft.getLogger().log(Level.WARNING, String.format("Failed to find item field %s, ignoring!", mapping.getSourceName()));
                }
                catch (IllegalAccessException illegal) {
                    LanteaCraft.getLogger().log(Level.WARNING, String.format("Could not access item field %s, ignoring!", mapping.getSourceName()));
                }
            }
        }
        catch (ClassNotFoundException notfound) {
            LanteaCraft.getLogger().log(Level.WARNING, "Could not locate a class required for upgrade!", notfound);
        }
    }

    public void createBlockConversionRecipe(UpgradeMapping mapping, Block foreign) {
        LanteaCraft.getLogger().log(Level.INFO, String.format("Adding block conversion {foreign: %s; local: %s}.", foreign.getClass().getCanonicalName(), mapping.getResultStack().toString()));
        if (mapping.getInputMetadata() != -1) {
            GameRegistry.addShapelessRecipe((ItemStack)mapping.getResultStack(), (Object[])new Object[]{new ItemStack(foreign, 1, mapping.getInputMetadata())});
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)mapping.getResultStack(), (Object[])new Object[]{new ItemStack(foreign, 1)});
        }
    }

    public void createItemConversionRecipe(UpgradeMapping mapping, Item foreign) {
        LanteaCraft.getLogger().log(Level.INFO, String.format("Adding item conversion {foreign: %s; local: %s}.", foreign.getClass().getCanonicalName(), mapping.getResultStack().toString()));
        if (mapping.getInputMetadata() != -1) {
            GameRegistry.addShapelessRecipe((ItemStack)mapping.getResultStack(), (Object[])new Object[]{new ItemStack(foreign, 1, mapping.getInputMetadata())});
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)mapping.getResultStack(), (Object[])new Object[]{new ItemStack(foreign, 1)});
        }
    }

    static {
        upgrades.add(new UpgradeMapping("sgBaseBlock", new ItemStack((Block)LanteaCraft.Blocks.stargateBaseBlock, 1), false));
        upgrades.add(new UpgradeMapping("sgRingBlock", new ItemStack((Block)LanteaCraft.Blocks.stargateRingBlock, 1, 0), false, 0));
        upgrades.add(new UpgradeMapping("sgRingBlock", new ItemStack((Block)LanteaCraft.Blocks.stargateRingBlock, 1, 1), false, 1));
        upgrades.add(new UpgradeMapping("sgControllerBlock", new ItemStack((Block)LanteaCraft.Blocks.stargateControllerBlock, 1), false));
        upgrades.add(new UpgradeMapping("naquadahBlock", new ItemStack((Block)LanteaCraft.Blocks.lanteaOreAsBlock, 1, OreTypes.NAQUADAH.ordinal()), false));
        upgrades.add(new UpgradeMapping("naquadahOre", new ItemStack((Block)LanteaCraft.Blocks.lanteaOre, 1, OreTypes.NAQUADAH.ordinal()), false));
        upgrades.add(new UpgradeMapping("naquadah", new ItemStack((Item)LanteaCraft.Items.lanteaOreItem, 1, OreTypes.NAQUADAH.ordinal()), true));
        upgrades.add(new UpgradeMapping("naquadahIngot", new ItemStack((Item)LanteaCraft.Items.lanteaOreIngot, 1, OreTypes.NAQUADAH.ordinal()), true));
        upgrades.add(new UpgradeMapping("sgCoreCrystal", new ItemStack((Item)LanteaCraft.Items.coreCrystal, 1), true));
        upgrades.add(new UpgradeMapping("sgControllerCrystal", new ItemStack((Item)LanteaCraft.Items.controllerCrystal, 1), true));
    }

    static class UpgradeMapping {
        private String sourceName;
        private ItemStack destinationStack;
        private boolean sourceIsItem;
        private int inputMetadata;

        public UpgradeMapping(String s, ItemStack d, boolean i) {
            this.sourceName = s;
            this.destinationStack = d;
            this.sourceIsItem = i;
            this.inputMetadata = -1;
        }

        public UpgradeMapping(String s, ItemStack d, boolean i, int j) {
            this.sourceName = s;
            this.destinationStack = d;
            this.sourceIsItem = i;
            this.inputMetadata = j;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public ItemStack getResultStack() {
            return this.destinationStack;
        }

        public boolean isItemSource() {
            return this.sourceIsItem;
        }

        public int getInputMetadata() {
            return this.inputMetadata;
        }
    }
}

