/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.module;

import cpw.mods.fml.common.Loader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import pcl.lc.LanteaCraft;
import pcl.lc.api.internal.Agent;
import pcl.lc.api.internal.IIntegrationAgent;
import pcl.lc.api.internal.IModule;
import pcl.lc.core.ModuleManager;
import pcl.lc.module.integration.ComputerCraftAgent;
import pcl.lc.module.integration.OpenComputersAgent;
import pcl.lc.module.integration.WailaAgent;

public class ModuleIntegration
implements IModule {
    private static ArrayList<Class<? extends IIntegrationAgent>> clazz_integration = new ArrayList();
    private ArrayList<IIntegrationAgent> agents = new ArrayList(clazz_integration.size());

    public static void registerIntegrationAgent(Class<? extends IIntegrationAgent> theAgent) {
        LanteaCraft.getLogger().log(Level.INFO, "Integration agent registration: " + theAgent.getName());
        if (!clazz_integration.contains(theAgent)) {
            clazz_integration.add(theAgent);
        }
    }

    @Override
    public Set<ModuleManager.Module> getDependencies() {
        return EnumSet.of(ModuleManager.Module.CORE);
    }

    @Override
    public Set<ModuleManager.Module> getLoadDependenciesAfter() {
        return EnumSet.of(ModuleManager.Module.CORE);
    }

    @Override
    public void preInit() {
        LanteaCraft.getLogger().log(Level.INFO, "Preparing integration module loading.");
        for (Class<? extends IIntegrationAgent> agent : clazz_integration) {
            Annotation[] annotations = agent.getAnnotations();
            if (annotations.length == 0) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("Not loading class %s because it is missing an Agent directive.", agent.getName()));
            }
            for (Annotation annotate : annotations) {
                if (!annotate.annotationType().equals(Agent.class)) continue;
                Agent theAgent = (Agent)annotate;
                if (Loader.isModLoaded((String)theAgent.modname())) {
                    try {
                        LanteaCraft.getLogger().log(Level.INFO, String.format("Hot-loading agent %s", agent.getName()));
                        IIntegrationAgent singleton = agent.newInstance();
                        this.agents.add(singleton);
                        LanteaCraft.getLogger().log(Level.INFO, String.format("Loaded agent %s.", agent.getName()));
                    }
                    catch (Throwable t) {
                        LanteaCraft.getLogger().log(Level.WARNING, "Exception in integration agent initalizer.", t);
                    }
                    continue;
                }
                LanteaCraft.getLogger().log(Level.INFO, String.format("Not loading agent %s, missing mod %s.", agent.getName(), theAgent.modname()));
            }
        }
        LanteaCraft.getLogger().log(Level.INFO, "Done hotloading integration modules.");
    }

    @Override
    public void init() {
        Iterator<IIntegrationAgent> agents = this.agents.iterator();
        while (agents.hasNext()) {
            try {
                agents.next().init();
            }
            catch (Throwable t) {
                LanteaCraft.getLogger().log(Level.WARNING, "Integration agent threw init-time exception.", t);
            }
        }
    }

    @Override
    public void postInit() {
    }

    static {
        ModuleIntegration.registerIntegrationAgent(ComputerCraftAgent.class);
        ModuleIntegration.registerIntegrationAgent(OpenComputersAgent.class);
        ModuleIntegration.registerIntegrationAgent(WailaAgent.class);
    }
}

