/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.items;

import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumIrisType;

public class ItemIris
extends Item {
    private Icon iconMissing;
    private Icon iconMechanical;
    private Icon iconEnergy;

    public ItemIris(int id) {
        super(id);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77656_e(21);
        this.setNoRepair();
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < EnumIrisType.values().length; ++i) {
            ItemStack stack = new ItemStack((Item)LanteaCraft.Items.iris, 1);
            this.setType(stack, EnumIrisType.fromOrdinal(i));
            this.setIrisDamage(stack, 0.0);
            par3List.add(stack);
        }
    }

    public void func_94581_a(IconRegister reg) {
        this.iconMissing = reg.func_94245_a(LanteaCraft.getAssetKey() + ":missing");
        this.iconMechanical = reg.func_94245_a(LanteaCraft.getAssetKey() + ":energy_iris_upgrade_" + LanteaCraft.getProxy().getRenderMode());
        this.iconEnergy = reg.func_94245_a(LanteaCraft.getAssetKey() + ":iris_upgrade_" + LanteaCraft.getProxy().getRenderMode());
    }

    public Icon func_77650_f(ItemStack par1ItemStack) {
        EnumIrisType typeof = this.getType(par1ItemStack);
        if (typeof != null) {
            switch (typeof) {
                case ENERGY: {
                    return this.iconEnergy;
                }
                case MECHANICAL: {
                    return this.iconMechanical;
                }
            }
        }
        return this.iconMissing;
    }

    public void acceptDamage(ItemStack stack, double quantity) {
        EnumIrisType typeof = this.getType(stack);
        if (!typeof.isInvulnerable()) {
            this.setIrisDamage(stack, this.getIrisDamage(stack) + quantity);
        }
    }

    public double getMaximumDamage(EnumIrisType typeof) {
        switch (typeof) {
            case MECHANICAL: {
                return 1024.0;
            }
            case ENERGY: {
                return 99999.0;
            }
        }
        return -1.0;
    }

    public EnumIrisType getType(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.field_77990_d.func_74764_b("type")) {
            stack.field_77990_d.func_74768_a("type", 0);
        }
        return EnumIrisType.fromOrdinal(stack.field_77990_d.func_74762_e("type"));
    }

    public void setType(ItemStack stack, EnumIrisType type) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a("type", type.ordinal());
        this.updateDisplay(stack);
    }

    public double getIrisDamage(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.field_77990_d.func_74764_b("damage")) {
            return 0.0;
        }
        return stack.field_77990_d.func_74769_h("damage");
    }

    public void setIrisDamage(ItemStack stack, double value) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74780_a("damage", value);
        this.updateDisplay(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean wat) {
        double damage = 100.0 * this.getIrisDamage(stack) / this.getMaximumDamage(this.getType(stack));
        list.add(String.format("Type: %s", this.getType(stack).getName()));
        list.add(String.format("Damage: %.2f%%", damage));
    }

    private void updateDisplay(ItemStack stack) {
        double ratio = this.getIrisDamage(stack) / this.getMaximumDamage(this.getType(stack));
        stack.func_77964_b(21 - (int)Math.floor(20.0 * ratio));
    }
}

