/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.guis;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.util.logging.Level;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import pcl.common.audio.AudioPosition;
import pcl.common.audio.SoundHost;
import pcl.common.base.GenericContainerGUI;
import pcl.common.network.StandardModPacket;
import pcl.common.util.Vector3;
import pcl.common.util.WorldLocation;
import pcl.lc.LanteaCraft;
import pcl.lc.api.EnumStargateState;
import pcl.lc.containers.ContainerStargateController;
import pcl.lc.core.GateAddressHelper;
import pcl.lc.tileentity.TileEntityStargateBase;
import pcl.lc.tileentity.TileEntityStargateController;

public class ScreenStargateController
extends GenericContainerGUI {
    static final int dhdWidth = 260;
    static final int dhdHeight = 180;
    static final double dhdRadius1 = 26.0;
    static final double dhdRadius2 = 71.5;
    static final double dhdRadius3 = 117.0;
    private TileEntityStargateController controller;
    private ResourceLocation dhdLayer;
    private ResourceLocation dhdButtonLayer;
    private int dhdTop;
    private int dhdCentreX;
    private int dhdCentreY;
    private String enteredAddress = "";
    private String warningMessage = "";
    private int ticks = 0;
    private int ticksWarning = 0;
    private SoundHost soundHost;
    private AudioPosition soundHostPosition;

    public ScreenStargateController(TileEntityStargateController controller, EntityPlayer actor) {
        super(new ContainerStargateController(controller, actor), 260, 180);
        this.controller = controller;
        this.dhdLayer = LanteaCraft.getResource("textures/gui/dhd_gui.png");
        this.dhdButtonLayer = LanteaCraft.getResource("textures/gui/dhd_centre.png");
        this.soundHost = new SoundHost(controller);
        this.soundHostPosition = new AudioPosition(controller.field_70331_k, new Vector3(controller));
        this.soundHost.addChannel("click", "stargate/milkyway/milkyway_dhd_button.ogg", this.soundHostPosition, 1.0f, 0);
    }

    TileEntityStargateBase getStargateTE() {
        return this.controller.getLinkedStargateTE();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_74198_m = 0;
        this.field_74197_n = 0;
        this.dhdTop = this.field_73881_g - 180;
        this.dhdCentreX = this.field_73880_f / 2;
        this.dhdCentreY = this.dhdTop + 90;
    }

    public void func_73876_c() {
        super.func_73876_c();
        ++this.ticks;
        if (this.ticks > 20) {
            this.ticks = 0;
        }
        if (this.ticksWarning > 0) {
            --this.ticksWarning;
        }
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        int i;
        if (mouseButton == 0 && (i = this.findDHDButton(x, y)) >= 0) {
            this.soundHost.playChannel("click");
            this.dhdButtonPressed(i);
            return;
        }
        super.func_73864_a(x, y, mouseButton);
    }

    int findDHDButton(int mx, int my) {
        int x = -(mx - this.dhdCentreX);
        int y = -(my - this.dhdCentreY) * 260 / 180;
        double r = Math.hypot(x, y);
        if (r > 117.0) {
            return -1;
        }
        if (r <= 26.0) {
            return 0;
        }
        double a = Math.toDegrees(Math.atan2(y, x));
        if (a < 0.0) {
            a += 360.0;
        }
        int i0 = r > 71.5 ? 1 : 15;
        return i0 + (int)Math.floor(a * 14.0 / 360.0);
    }

    private void dhdButtonPressed(int i) {
        if (i == 0) {
            this.orangeButtonPressed(false);
        } else if (i >= 27) {
            this.backspace();
        } else {
            this.enterCharacter(GateAddressHelper.singleton().index(i - 1));
        }
    }

    protected void func_73869_a(char c, int key) {
        if (key == 1) {
            this.close();
        } else if (key == 14 || key == 211) {
            this.backspace();
        } else if (key == 28 || key == 156) {
            this.orangeButtonPressed(true);
        } else {
            String C = String.valueOf(c).toUpperCase();
            if (GateAddressHelper.singleton().isLegal(C)) {
                this.soundHost.playChannel("click");
                this.enterCharacter(C.charAt(0));
            }
        }
        if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && key == 47) {
            try {
                String data = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
                for (char c1 : data.toCharArray()) {
                    if (!GateAddressHelper.singleton().isLegal(c1)) continue;
                    this.enterCharacter(c1);
                }
            }
            catch (Throwable t) {
                LanteaCraft.getLogger().log(Level.WARNING, "Clipboard pull failed!", t);
                this.warningMessage = "Couldn't read the clipboard!";
                this.ticksWarning = 200;
            }
        }
    }

    void orangeButtonPressed(boolean connectOnly) {
        TileEntityStargateBase te = this.getStargateTE();
        if (!(te == null || connectOnly && te.isConnected())) {
            StandardModPacket packet = new StandardModPacket(new WorldLocation(te));
            packet.setIsForServer(true);
            packet.setType("LanteaPacket.DialRequest");
            packet.setValue("Address", this.enteredAddress);
            LanteaCraft.getProxy().sendToServer(packet);
            this.close();
        }
    }

    private void backspace() {
        int n = this.enteredAddress.length();
        if (n > 0) {
            this.enteredAddress = this.enteredAddress.substring(0, n - 1);
        }
    }

    private void enterCharacter(char c) {
        if (this.enteredAddress.length() < 9) {
            this.enteredAddress = this.enteredAddress + c;
        }
    }

    void drawEnteredSymbols() {
        this.drawFramedSymbols(this.field_73880_f / 2, this.dhdTop - 60, this.enteredAddress);
    }

    void drawEnteredString() {
        this.drawAddressString(this.field_73880_f / 2, this.dhdTop - 12, this.enteredAddress, 9, " ", this.ticks > 10 ? "_" : " ");
    }

    @Override
    protected void drawBackgroundLayer(float partialTickCount, int mouseX, int mouseY) {
        boolean connected;
        this.bindTexture(this.dhdLayer);
        this.drawTexturedRect((this.field_73880_f - 260) / 2, this.field_73881_g - 180, 260.0, 180.0);
        this.bindTexture(this.dhdButtonLayer, 128, 64);
        GL11.glEnable((int)3042);
        TileEntityStargateBase te = this.getStargateTE();
        boolean bl = connected = te != null && te.isConnected();
        if (te == null || !te.getAsStructure().isValid()) {
            this.setColor(0.2, 0.2, 0.2);
        } else if (connected) {
            this.setColor(1.0, 0.5, 0.0);
        } else {
            this.setColor(0.5, 0.25, 0.0);
        }
        double rx = 24.375;
        double ry = 30.0;
        Tessellator.field_78398_a.func_78383_c();
        this.drawTexturedRect((double)this.dhdCentreX - rx, (double)this.dhdCentreY - ry, 2.0 * rx, 1.5 * ry, 64.0, 0.0, 64.0, 48.0);
        this.resetColor();
        if (connected) {
            GL11.glBlendFunc((int)1, (int)1);
            double d = 5.0;
            this.drawTexturedRect((double)this.dhdCentreX - rx - d, (double)this.dhdCentreY - ry - d, 2.0 * (rx + d), ry + d, 0.0, 0.0, 64.0, 32.0);
            this.drawTexturedRect((double)this.dhdCentreX - rx - d, this.dhdCentreY, 2.0 * (rx + d), 0.5 * ry + d, 0.0, 32.0, 64.0, 32.0);
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        TileEntityStargateBase te = this.getStargateTE();
        if (te != null && te.getState() == EnumStargateState.Idle) {
            this.drawEnteredSymbols();
            this.drawEnteredString();
        }
        if (this.ticksWarning > 0 && this.warningMessage != null) {
            this.func_73732_a(this.field_73886_k, this.warningMessage, this.field_73880_f / 2, this.dhdTop - 3, 0xFFAAAA);
        }
    }
}

