/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.guis;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import pcl.common.base.GenericContainerGUI;
import pcl.common.util.ImmutablePair;
import pcl.lc.LanteaCraft;
import pcl.lc.containers.ContainerStargateBase;
import pcl.lc.core.AddressingError;
import pcl.lc.guis.IconButtonRenderer;
import pcl.lc.tileentity.TileEntityStargateBase;

public class ScreenStargateBase
extends GenericContainerGUI {
    private static String screenTitle = "Stargate Address";
    private static final int guiWidth = 256;
    private static final int guiHeight = 208;
    private ResourceLocation background;
    private TileEntityStargateBase te;
    private String address;
    private boolean mouseDown = false;
    private int clipboardAction = 0;

    public ScreenStargateBase(TileEntityStargateBase entity, EntityPlayer player) {
        super(new ContainerStargateBase(entity, player));
        this.te = entity;
        this.background = LanteaCraft.getResource("textures/gui/sg_gui_" + LanteaCraft.getProxy().getRenderMode() + ".png");
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.clipboardAction > 0) {
            --this.clipboardAction;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    protected void drawForegroundLayer(int x, int y) {
        String address = this.getAddress();
        int cx = this.field_74194_b / 2;
        this.drawFramedSymbols(cx, 22, address);
        this.textColor = 19558;
        this.drawCenteredString(screenTitle, cx, 8);
        this.drawCenteredString(address, cx, 72);
        ImmutablePair<Integer, Integer> coord = this.transformMouseCoordinates(x, y);
        IconButtonRenderer.drawButton(Minecraft.func_71410_x(), this.clipboardAction > 0 ? "tick" : "copy", coord.getA() >= 232 && coord.getA() <= 244 && coord.getB() >= 70 && coord.getB() <= 82, this.mouseDown, 232, 70, 0.5, this.field_73735_i);
    }

    @Override
    public void drawBackgroundLayer(float partialTickCount, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_74198_m, (float)this.field_74197_n, (float)0.0f);
        this.bindTexture(this.background, 256, 256);
        this.drawTexturedRect(0.0, 0.0, 256.0, 208.0, 0.0, 0.0);
        GL11.glPopMatrix();
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        ImmutablePair<Integer, Integer> coord;
        if (mouseButton == 0 && (coord = this.transformMouseCoordinates(x, y)).getA() >= 232 && coord.getA() <= 244 && coord.getB() >= 70 && coord.getB() <= 82) {
            this.mouseDown = true;
        }
        super.func_73864_a(x, y, mouseButton);
    }

    protected void func_73879_b(int x, int y, int which) {
        if ((which == 0 || which == 1) && this.mouseDown) {
            ImmutablePair<Integer, Integer> coord = this.transformMouseCoordinates(x, y);
            if (coord.getA() >= 232 && coord.getA() <= 244 && coord.getB() >= 70 && coord.getB() <= 82) {
                this.addressToClipboard();
            }
            this.mouseDown = false;
        }
        super.func_73879_b(x, y, which);
    }

    protected void func_73869_a(char c, int key) {
        if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && key == 46) {
            this.addressToClipboard();
        }
        super.func_73869_a(c, key);
    }

    private ImmutablePair<Integer, Integer> transformMouseCoordinates(int x, int y) {
        return new ImmutablePair<Integer, Integer>(x - this.field_74198_m, y - this.field_74197_n);
    }

    private void addressToClipboard() {
        try {
            this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 1.0f);
            Clipboard destination = Toolkit.getDefaultToolkit().getSystemClipboard();
            destination.setContents(new StringSelection(this.address), null);
            this.clipboardAction = 60;
        }
        catch (Throwable t) {
            LanteaCraft.getLogger().log(Level.WARNING, "Clipboard push failed!", t);
        }
    }

    private String getAddress() {
        if (this.address == null) {
            try {
                this.address = this.te.getHomeAddress();
            }
            catch (AddressingError.CoordRangeError e) {
                this.address = "Coordinates out of stargate range";
            }
            catch (AddressingError.DimensionRangeError e) {
                this.address = "Dimension not reachable by stargate";
            }
            catch (AddressingError e) {
                LanteaCraft.getLogger().log(Level.INFO, "Addressing error!", e);
                this.address = "Stargate addressing error; check the log";
            }
        }
        return this.address;
    }
}

