/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.fluids;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class SpecialFluidTank
implements IFluidTank {
    private boolean canFill;
    private boolean canDrain;
    private int capacity;
    private int volume;
    private Fluid fluid;
    private boolean changed;

    public SpecialFluidTank(Fluid f, int cap, int vol, boolean fill, boolean drain) {
        this.fluid = f;
        this.capacity = cap;
        this.volume = vol;
        this.canFill = fill;
        this.canDrain = drain;
    }

    public boolean hasChanged() {
        if (this.changed) {
            this.changed = !this.changed;
            return true;
        }
        return false;
    }

    public boolean canFill() {
        return this.canFill;
    }

    public boolean canDrain() {
        return this.canDrain;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.capacity = nbt.func_74762_e("capacity");
        this.volume = nbt.func_74762_e("volume");
        this.changed = true;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("capacity", this.capacity);
        nbt.func_74768_a("volume", this.volume);
    }

    public FluidStack getFluid() {
        if (this.volume > 0) {
            return new FluidStack(this.fluid, this.volume);
        }
        return null;
    }

    public int getFluidAmount() {
        return this.volume;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.canFill || !resource.isFluidEqual(new FluidStack(this.fluid, this.volume))) {
            return 0;
        }
        int quantity = Math.min(resource.amount, this.capacity - this.volume);
        if (doFill) {
            this.volume += quantity;
            this.changed = true;
        }
        return quantity;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.canDrain) {
            return null;
        }
        int quantity = Math.min(maxDrain, this.volume);
        if (doDrain) {
            this.volume -= quantity;
            this.changed = true;
        }
        return new FluidStack(this.fluid, quantity);
    }
}

