/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.core;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerInstance;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.ForgeChunkManager;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.api.internal.ITickAgent;

public class RemoteChunkLoading
implements ITickAgent {
    private ArrayList<ChunkLoadRequest> requests = new ArrayList();
    private ArrayList<ChunkLoadRequest> expiredRequests = new ArrayList();

    public static boolean arePlayersWatchingChunk(WorldServer serverWorld, ChunkCoordIntPair chunk) {
        PlayerInstance watcher = serverWorld.func_73040_p().func_72690_a(chunk.field_77276_a, chunk.field_77275_b, false);
        if (watcher == null) {
            return false;
        }
        List players = (List)ReflectionHelper.getPrivateValue(PlayerInstance.class, (Object)watcher, (int)0);
        return !players.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChunkLoadRequest create(String name, World world, int maxAge, NBTTagCompound metadata) {
        if (BuildInfo.CHUNK_DEBUGGING && world != null && world.field_73011_w != null) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("RemoteChunkLoading CSR: %s (world: %s)", name, world.field_73011_w.field_76574_g));
        }
        if (BuildInfo.CHUNK_DEBUGGING && (world == null || world.field_73011_w == null)) {
            LanteaCraft.getLogger().log(Level.WARNING, String.format("RemoteChunkLoading CSR: %s (no provider!!)", name));
        }
        ArrayList<ChunkLoadRequest> arrayList = this.requests;
        synchronized (arrayList) {
            for (ChunkLoadRequest request : this.requests) {
                if (!request.equals(metadata)) continue;
                request.extend(maxAge);
                if (BuildInfo.CHUNK_DEBUGGING) {
                    LanteaCraft.getLogger().log(Level.INFO, String.format("RemoteChunkLoading CSR: returning cached request for CSR %s", name));
                }
                return request;
            }
        }
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)LanteaCraft.getInstance(), (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            if (BuildInfo.CHUNK_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.WARNING, String.format("Ticket request failed, null result!", new Object[0]));
            }
            return null;
        }
        ChunkLoadRequest request = new ChunkLoadRequest(name, ticket, metadata, maxAge);
        for (ChunkCoordIntPair chunk : request.chunksIn()) {
            if (BuildInfo.CHUNK_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.WARNING, String.format("Forcing chunk (%s, %s)", chunk.field_77276_a, chunk.field_77275_b));
            }
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
            IChunkProvider provider = world.func_72863_F();
            if (!(provider.func_73154_d(chunk.field_77276_a, chunk.field_77275_b) instanceof EmptyChunk)) continue;
            provider.func_73158_c(chunk.field_77276_a, chunk.field_77275_b);
        }
        ArrayList<ChunkLoadRequest> arrayList2 = this.requests;
        synchronized (arrayList2) {
            this.requests.add(request);
        }
        if (BuildInfo.CHUNK_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("RemoteChunkLoading CSR success: %s", name));
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advance() {
        ArrayList<ChunkLoadRequest> arrayList = this.requests;
        synchronized (arrayList) {
            for (ChunkLoadRequest request : this.requests) {
                request.tick();
                if (!request.expired()) continue;
                this.expiredRequests.add(request);
            }
        }
        if (this.expiredRequests.size() > 0) {
            for (ChunkLoadRequest expired : this.expiredRequests) {
                this.remove(expired);
            }
            this.expiredRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ChunkLoadRequest request) {
        if (BuildInfo.CHUNK_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("RemoteChunkLoading remove request: %s", request.name));
        }
        if (request.ticket != null) {
            if (BuildInfo.CHUNK_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("Requesting FCM release ticket %s.", request.ticket.toString()));
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)request.ticket);
        }
        WorldServer ws = (WorldServer)((ChunkLoadRequest)request).ticket.world;
        for (ChunkCoordIntPair chunk : request.chunksIn()) {
            if (RemoteChunkLoading.arePlayersWatchingChunk(ws, chunk)) continue;
            ws.field_73059_b.func_73241_b(chunk.field_77276_a, chunk.field_77275_b);
        }
        ArrayList<ChunkLoadRequest> arrayList = this.requests;
        synchronized (arrayList) {
            this.requests.remove(request);
        }
    }

    public static class ChunkLoadRequest {
        private final String name;
        private final ForgeChunkManager.Ticket ticket;
        private final NBTTagCompound metadata;
        private int max_age;
        private int age;

        public ChunkLoadRequest(String name, ForgeChunkManager.Ticket ticket, NBTTagCompound metadata, int expiry) {
            this.name = name;
            this.ticket = ticket;
            this.metadata = metadata;
            this.max_age = expiry;
        }

        public String name() {
            return this.name;
        }

        public boolean expired() {
            return this.age > this.max_age;
        }

        public void tick() {
            if (this.max_age >= this.age) {
                ++this.age;
            }
            if (this.age > this.max_age && BuildInfo.CHUNK_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("Request %s expired, waiting for kill...", this.name));
            }
        }

        public void expireNow() {
            this.age = this.max_age + 1;
            if (BuildInfo.CHUNK_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("Request %s expired on demand, waiting for kill...", this.name));
            }
        }

        public void extend(int ticks) {
            if (BuildInfo.CHUNK_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("Request %s extending by %s ticks.", this.name, ticks));
            }
            this.max_age += ticks;
        }

        public List<ChunkCoordIntPair> chunksIn() {
            ArrayList<ChunkCoordIntPair> chunks = new ArrayList<ChunkCoordIntPair>();
            int minX = this.metadata.func_74762_e("minX");
            int minZ = this.metadata.func_74762_e("minZ");
            int maxX = this.metadata.func_74762_e("maxX");
            int maxZ = this.metadata.func_74762_e("maxZ");
            for (int i = minX; i <= maxX; ++i) {
                for (int j = minZ; j <= maxZ; ++j) {
                    chunks.add(new ChunkCoordIntPair(i, j));
                }
            }
            return chunks;
        }

        public boolean equals(Object o) {
            if (o instanceof ChunkLoadRequest) {
                ChunkLoadRequest req = (ChunkLoadRequest)o;
                return req.name.equals(this.name) && req.max_age == this.max_age && req.age == this.age;
            }
            if (o instanceof NBTTagCompound) {
                NBTTagCompound compound = (NBTTagCompound)o;
                if (!compound.func_74764_b("minX") || !compound.func_74764_b("minZ")) {
                    return false;
                }
                if (!compound.func_74764_b("maxX") || !compound.func_74764_b("maxZ")) {
                    return false;
                }
                if (compound.func_74762_e("minX") != this.metadata.func_74762_e("minX")) {
                    return false;
                }
                if (compound.func_74762_e("minZ") != this.metadata.func_74762_e("minZ")) {
                    return false;
                }
                if (compound.func_74762_e("maxX") != this.metadata.func_74762_e("maxX")) {
                    return false;
                }
                return compound.func_74762_e("maxZ") == this.metadata.func_74762_e("maxZ");
            }
            return false;
        }
    }
}

