/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.core;

import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import pcl.common.util.ChunkLocation;
import pcl.common.util.WorldLocation;
import pcl.lc.core.AddressingError;

public class GateAddressHelper {
    private static GateAddressHelper singleton = new GateAddressHelper();
    private static long maximumShortSize;
    private static long maximumLongSize;
    private final char[] radix = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-+".toCharArray();
    public final int radixSize = this.radix.length;

    public static GateAddressHelper singleton() {
        return singleton;
    }

    public static String addressForLocation(WorldLocation position) throws AddressingError {
        return GateAddressHelper.addressForLocation(position.toChunkLocation());
    }

    public static String addressForLocation(ChunkLocation location) throws AddressingError {
        try {
            int dcx = Math.abs(location.cx);
            int dcz = Math.abs(location.cz);
            int dd = Math.abs(location.dimension);
            if ((long)dcx > maximumLongSize) {
                throw new AddressingError.CoordRangeError("X-coordinate out of range");
            }
            if ((long)dcz > maximumLongSize) {
                throw new AddressingError.CoordRangeError("Z-coordinate out of range");
            }
            if ((long)dd > maximumShortSize) {
                throw new AddressingError.DimensionRangeError("Dimension out of range");
            }
            StringBuilder output = new StringBuilder();
            output.append(singleton.btos(new boolean[]{dcx != location.cx, dcz != location.cz, dd != location.dimension, false}));
            output.append(singleton.itos(dcx, 3)).append(singleton.itos(dcz, 3));
            output.append(singleton.itos(dd, 2));
            singleton.legal(output.toString());
            return output.toString();
        }
        catch (NumberFormatException format) {
            throw new AddressingError("Unexpected exception.", format);
        }
    }

    public static ChunkLocation locationForAddress(String address) throws AddressingError {
        try {
            singleton.legal(address);
        }
        catch (NumberFormatException format) {
            throw new AddressingError("Illegal address character!");
        }
        try {
            if (address.length() != 7 && address.length() != 9) {
                throw new AddressingError("Not enough symbols.");
            }
            boolean[] flags = singleton.stob(address.substring(0, 1));
            int dcx = singleton.stoi(address.substring(1, 4));
            int dcz = singleton.stoi(address.substring(4, 7));
            if (flags[0]) {
                dcx = -dcx;
            }
            if (flags[1]) {
                dcz = -dcz;
            }
            if (address.length() > 7) {
                int ddimension = singleton.stoi(address.substring(7));
                if (flags[2]) {
                    ddimension = -ddimension;
                }
                return new ChunkLocation(ddimension, dcx, dcz);
            }
            return new ChunkLocation(dcx, dcz);
        }
        catch (NumberFormatException format) {
            throw new AddressingError("");
        }
    }

    public static World getWorld(int dimension) {
        MinecraftServer s = MinecraftServer.func_71276_C();
        return s.func_71218_a(dimension);
    }

    private GateAddressHelper() {
        maximumLongSize = this.stoi(this.build(this.radix[this.radixSize - 1], 3));
        maximumShortSize = this.stoi(this.build(this.radix[this.radixSize - 1], 2));
    }

    private String build(char c, int l) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < l; ++i) {
            result.append(c);
        }
        return result.toString();
    }

    public void legal(String s) {
        for (char c : s.toCharArray()) {
            this.index(c);
        }
    }

    public boolean isLegal(String s) {
        try {
            this.legal(s);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public boolean isLegal(char c) {
        try {
            return this.index(c) > -1;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public int index(char c) {
        for (int i = 0; i < this.radix.length; ++i) {
            if (this.radix[i] != c) continue;
            return i;
        }
        throw new NumberFormatException("Illegal radix value.");
    }

    public char index(int i) {
        if (0 > i || i > this.radix.length) {
            throw new NumberFormatException("Illegal radix value.");
        }
        return this.radix[i];
    }

    private String btos(boolean[] flags) {
        int accum = 0;
        if (flags.length != 4) {
            throw new NumberFormatException("Illegal btos dimension.");
        }
        for (int i = 0; i < 4; ++i) {
            if (!flags[i]) continue;
            accum |= 1 << i;
        }
        return this.itos(accum, 1);
    }

    private boolean[] stob(String value) {
        boolean[] result = new boolean[4];
        int accum = this.stoi(value);
        for (int i = 0; i < 4; ++i) {
            if ((accum & 1 << i) == 0) continue;
            result[i] = true;
        }
        return result;
    }

    private String itos(int value, int width) {
        char[] buf = new char[width];
        while (width > 0) {
            buf[--width] = this.index(value % this.radix.length);
            value /= this.radix.length;
        }
        if (value != 0) {
            throw new NumberFormatException("Number too large.");
        }
        return new String(buf);
    }

    private int stoi(String value) {
        int result = 0;
        int i = 0;
        int len = value.length();
        int limit = -2147483647;
        if (len > 0) {
            int multmin = limit / this.radix.length;
            while (i < len) {
                int digit;
                if ((digit = this.index(value.charAt(i++))) < 0) {
                    throw new NumberFormatException("Not a legal radix-38 symbol.");
                }
                if (result < multmin) {
                    throw new NumberFormatException("Out of legal radix-multiplication range.");
                }
                if ((result *= this.radix.length) < limit + digit) {
                    throw new NumberFormatException("Out of legal radix range.");
                }
                result += digit;
            }
        } else {
            throw new NumberFormatException("Not a legal radix-38 number.");
        }
        return result;
    }
}

